/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.pricefeeds;

import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.LastPrice;
import com.nubits.nubot.pricefeeds.AbstractPriceFeed;
import com.nubits.nubot.trading.TradeUtils;
import com.nubits.nubot.utils.Utils;
import java.io.IOException;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class CcedkPriceFeed
extends AbstractPriceFeed {
    private static final Logger LOG = Logger.getLogger(CcedkPriceFeed.class.getName());

    public CcedkPriceFeed() {
        this.name = "ccedk";
        this.refreshMinTime = 50000L;
    }

    @Override
    public LastPrice getLastPrice(CurrencyPair pair) {
        String url = TradeUtils.getCCEDKTickerUrl(pair);
        long now = System.currentTimeMillis();
        long diff = now - this.lastRequest;
        if (diff >= this.refreshMinTime) {
            String htmlString;
            try {
                htmlString = Utils.getHTML(url, true);
            }
            catch (IOException ex) {
                LOG.severe(ex.toString());
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
            JSONParser parser = new JSONParser();
            try {
                JSONObject httpAnswerJson = (JSONObject)parser.parse(htmlString);
                JSONObject tickerObject = (JSONObject)httpAnswerJson.get("response");
                JSONObject entityObject = (JSONObject)tickerObject.get("entity");
                double last = Double.valueOf((String)entityObject.get("avg"));
                this.lastRequest = System.currentTimeMillis();
                this.lastPrice = new LastPrice(false, this.name, pair.getOrderCurrency(), new Amount(last, pair.getPaymentCurrency()));
                return this.lastPrice;
            }
            catch (Exception ex) {
                LOG.severe(ex.toString());
                this.lastRequest = System.currentTimeMillis();
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
        }
        LOG.fine("Wait " + (this.refreshMinTime - (System.currentTimeMillis() - this.lastRequest)) + " ms " + "before making a new request. Now returning the last saved price\n\n");
        return this.lastPrice;
    }
}

