/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.notifications.jhipchat;

import com.nubits.nubot.notifications.jhipchat.HipChat;
import com.nubits.nubot.notifications.jhipchat.RoomId;
import com.nubits.nubot.notifications.jhipchat.UserId;
import com.nubits.nubot.notifications.jhipchat.UtilParser;
import com.nubits.nubot.notifications.jhipchat.messages.HistoryMessage;
import com.nubits.nubot.notifications.jhipchat.messages.Message;
import com.nubits.nubot.notifications.jhipchat.messages.MessageParser;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class Room
extends RoomId {
    private String name;
    private String topic;
    private Date lastActive;
    private Date created;
    private String ownerId;
    private Boolean isArchived;
    private Boolean isPrivate;
    private String xmppJId;
    private String guestAccessUrl;
    private List<UserId> participants;
    private static final Logger LOG = Logger.getLogger(Room.class.getName());

    private Room(String id, HipChat origin) {
        super(id, origin);
    }

    public String getName() {
        return this.name;
    }

    public String getTopic() {
        return this.topic;
    }

    public Date getLastActive() {
        return this.lastActive;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public Boolean getIsArchived() {
        return this.isArchived;
    }

    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    public String getXmppJId() {
        return this.xmppJId;
    }

    public List<UserId> getParticipants() {
        return this.participants;
    }

    public String getGuestAccessUrl() {
        return this.guestAccessUrl;
    }

    public static Room create(String id, HipChat origin) {
        return new Room(id, origin);
    }

    public static Room create(String id, HipChat origin, String name, String topic, long lastActive, long created, String ownerId, Boolean isArchived, Boolean isPrivate, String xmppJId, List<UserId> participants, String guestAccessUrl) {
        Room room = new Room(id, origin);
        room.name = name;
        room.topic = topic;
        room.lastActive = new Date(lastActive);
        room.created = new Date(created);
        room.ownerId = ownerId;
        room.isArchived = isArchived;
        room.isPrivate = isPrivate;
        room.xmppJId = xmppJId;
        room.participants = participants;
        room.guestAccessUrl = guestAccessUrl;
        return room;
    }

    public List<HistoryMessage> getHistory() {
        return this.getHistory(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HistoryMessage> getHistory(Date date) {
        HipChat hc = this.getOrigin();
        Calendar c = Calendar.getInstance();
        String dateString = null;
        String tzString = null;
        if (date != null) {
            c.setTime(date);
            TimeZone tz = c.getTimeZone();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            dateString = sdf.format(date);
            tzString = tz.getDisplayName(tz.inDaylightTime(date), 0);
        } else {
            Date tDate = new Date();
            c.setTime(tDate);
            TimeZone tz = c.getTimeZone();
            dateString = "recent";
            tzString = tz.getDisplayName(tz.inDaylightTime(tDate), 0);
        }
        String query = String.format("?room_id=%s&date=%s&timezone=%s&format=%s&auth_token=%s", this.getId(), dateString, tzString, "json", hc.getAuthToken());
        OutputStream output = null;
        InputStream input = null;
        HttpURLConnection connection = null;
        List<HistoryMessage> messages = null;
        try {
            URL requestUrl = new URL("https://api.hipchat.com/v1/rooms/history" + query);
            connection = (HttpURLConnection)requestUrl.openConnection();
            connection.setDoInput(true);
            input = connection.getInputStream();
            messages = MessageParser.parseRoomHistory(this, input);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(output);
            connection.disconnect();
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean sendMessage(String message, UserId from, boolean notify, Message.Color color) {
        boolean result;
        block12: {
            String query = String.format("?format=%s&auth_token=%s", "json", this.getOrigin().getAuthToken());
            StringBuilder params = new StringBuilder();
            if (message == null || from == null) {
                throw new IllegalArgumentException("Cant send message with null message or null user");
            }
            params.append("room_id=");
            params.append(this.getId());
            params.append("&from=");
            try {
                params.append(URLEncoder.encode(from.getName(), "UTF-8"));
                params.append("&message=");
                params.append(URLEncoder.encode(message, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (notify) {
                params.append("&notify=1");
            }
            if (color != null) {
                params.append("&color=");
                params.append(color.name().toLowerCase());
            }
            String paramsToSend = params.toString();
            BufferedOutputStream output = null;
            InputStream input = null;
            HttpURLConnection connection = null;
            result = false;
            try {
                URL requestUrl = new URL("https://api.hipchat.com/v1/rooms/message" + query);
                connection = (HttpURLConnection)requestUrl.openConnection();
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", Integer.toString(paramsToSend.getBytes().length));
                connection.setRequestProperty("Content-Language", "en-US");
                output = new BufferedOutputStream(connection.getOutputStream());
                IOUtils.write(paramsToSend, (OutputStream)output);
                IOUtils.closeQuietly(output);
                input = connection.getInputStream();
                result = UtilParser.parseMessageResult(input);
                IOUtils.closeQuietly(output);
                connection.disconnect();
            }
            catch (MalformedURLException e) {
                LOG.severe(e.getMessage());
            }
            catch (IOException e2) {
                LOG.severe(e2.getMessage());
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(output);
                connection.disconnect();
            }
        }
        return result;
    }
}

