/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.notifications;

import com.nubits.nubot.global.Global;
import com.nubits.nubot.notifications.jhipchat.HipChat;
import com.nubits.nubot.notifications.jhipchat.Room;
import com.nubits.nubot.notifications.jhipchat.UserId;
import com.nubits.nubot.notifications.jhipchat.messages.Message;
import java.util.logging.Logger;

public class HipChatNotifications {
    private static final Logger LOG = Logger.getLogger(HipChatNotifications.class.getName());
    private static String BOT_NAME = "Custodian Bot";
    private static HipChat hipchat = new HipChat("b3ca1e9c657c7bb97e9aaaf9fc8329");
    private static UserId hipchatUser = UserId.create("idbot", BOT_NAME);
    private static Room notificationRoom = Room.create("826590", hipchat);
    private static Room criticalNotificationRoom = Room.create("1016112", hipchat);

    public static void sendMessage(String message, Message.Color color) {
        String publicAddress = "";
        boolean send = true;
        boolean notify = false;
        if (Global.options != null) {
            publicAddress = Global.options.getNubitsAddress();
            send = Global.options.isSendHipchat();
            notify = false;
        }
        String toSend = message + " (" + publicAddress + ")";
        if (color == Message.Color.RED) {
            notify = true;
        }
        if (send) {
            try {
                if (notify) {
                    criticalNotificationRoom.sendMessage(toSend, hipchatUser, notify, color);
                } else {
                    notificationRoom.sendMessage(toSend, hipchatUser, notify, color);
                }
            }
            catch (Exception e) {
                LOG.severe("Not sending hipchat notification. Network problem");
            }
        }
    }
}

