/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.models;

import com.nubits.nubot.utils.FileSystem;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Logger;

public class Currency {
    private static final Logger LOG = Logger.getLogger(Currency.class.getName());
    private boolean fiat;
    private String code;
    private String extendedName;
    private static final String PATH_TO_CURRENCIES = "res/currencies.csv";

    public static Currency createCurrency(String code) {
        Currency toRet = null;
        ArrayList<String[]> currencyList = FileSystem.parseCsvFromFile(PATH_TO_CURRENCIES);
        boolean found = false;
        for (int j = 1; j < currencyList.size(); ++j) {
            String[] tempLine = currencyList.get(j);
            if (!tempLine[0].equalsIgnoreCase(code)) continue;
            return new Currency(Boolean.parseBoolean(tempLine[2]), tempLine[0], tempLine[1]);
        }
        if (!found) {
            LOG.warning("Didn't find a currency with code " + code + " in lookup table " + PATH_TO_CURRENCIES + "\nUpdate the currency file to avoid malfunctionings.");
            return new Currency(false, code, "");
        }
        return toRet;
    }

    private Currency(boolean fiat, String code, String extendedName) {
        this.fiat = fiat;
        this.code = code;
        this.extendedName = extendedName;
    }

    public boolean isFiat() {
        return this.fiat;
    }

    public void setFiat(boolean fiat) {
        this.fiat = fiat;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getExtendedName() {
        return this.extendedName;
    }

    public void setExtendedName(String extendedName) {
        this.extendedName = extendedName;
    }

    public String toString() {
        return "Currency{fiat=" + this.fiat + ", code=" + this.code + ", extendedName=" + this.extendedName + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Currency other = (Currency)obj;
        return Objects.equals(this.code, other.code);
    }
}

