/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class FileSystem {
    private static final Logger LOG = Logger.getLogger(FileSystem.class.getName());

    public static void deleteFile(String path) {
        try {
            File file = new File(path);
            if (file.delete()) {
                LOG.fine("file " + file.getName() + " deleted!");
            } else {
                LOG.severe("Delete operation is failed for : " + path);
            }
        }
        catch (Exception e) {
            LOG.severe(e.toString());
        }
    }

    public static void deleteFile(String path, boolean verbose) {
        block6: {
            try {
                File file = new File(path);
                if (file.delete()) {
                    if (verbose) {
                        LOG.info("file " + file.getName() + " deleted!");
                    }
                } else if (verbose) {
                    LOG.info("Delete operation is failed for : " + path);
                }
            }
            catch (Exception e) {
                if (!verbose) break block6;
                LOG.info(e.toString());
            }
        }
    }

    public static void mkdir(String path) {
        new File(path).mkdirs();
    }

    public static void writeToFile(String what, String where, boolean append) {
        if (!append) {
            try {
                PrintWriter writer = new PrintWriter(where, "UTF-8");
                writer.println(what);
                writer.close();
            }
            catch (FileNotFoundException ex) {
                LOG.severe(ex.toString());
            }
            catch (UnsupportedEncodingException ex) {
                LOG.severe(ex.toString());
            }
        } else {
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(where, true)));){
                out.println(what);
            }
            catch (IOException e) {
                LOG.severe(e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromFile(String path) {
        File file = new File(path);
        StringBuilder fileContent = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String text;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((text = bufferedReader.readLine()) != null) {
                fileContent.append(text);
            }
        }
        catch (FileNotFoundException ex) {
            LOG.severe(ex.toString());
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException ex) {
                LOG.severe("File not found " + path + "\n " + ex.toString());
            }
        }
        return fileContent.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String[]> parseCsvFromFile(String path) {
        BufferedReader br = null;
        String line = "";
        String cvsSplitBy = ",";
        ArrayList<String[]> toReturn = new ArrayList<String[]>();
        try {
            br = new BufferedReader(new FileReader(path));
            while ((line = br.readLine()) != null) {
                String[] tempLine = line.split(cvsSplitBy);
                toReturn.add(tempLine);
            }
        }
        catch (FileNotFoundException e) {
            LOG.severe(e.toString());
        }
        catch (IOException e) {
            LOG.severe(e.toString());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOG.severe(e.toString());
                }
            }
        }
        return toReturn;
    }
}

