/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.trading;

import com.nubits.nubot.global.Constant;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.utils.Utils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class TradeUtils {
    private static final Logger LOG = Logger.getLogger(TradeUtils.class.getName());
    public static int offset = 0;

    public static boolean tryCancelAllOrders(CurrencyPair pair) {
        boolean toRet = false;
        ApiResponse activeOrdersResponse = Global.exchange.getTrade().getActiveOrders(Global.options.getPair());
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            if (orderList.size() == 0) {
                toRet = true;
            } else {
                LOG.info("There are still : " + orderList.size() + " active orders");
                ApiResponse deleteOrdersResponse = Global.exchange.getTrade().clearOrders(pair);
                if (deleteOrdersResponse.isPositive()) {
                    boolean deleted = (Boolean)deleteOrdersResponse.getResponseObject();
                    if (deleted) {
                        LOG.info("Order clear request succesfully");
                    } else {
                        toRet = false;
                        LOG.info("Could not submit request to clear orders");
                    }
                } else {
                    toRet = false;
                    LOG.severe(deleteOrdersResponse.getError().toString());
                }
            }
        } else {
            toRet = false;
            LOG.severe(activeOrdersResponse.getError().toString());
        }
        return toRet;
    }

    public static boolean takeDownOrders(String type, CurrencyPair pair) {
        boolean completed = true;
        ApiResponse activeOrdersResponse = Global.exchange.getTrade().getActiveOrders(Global.options.getPair());
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            for (int i = 0; i < orderList.size(); ++i) {
                boolean tempDeleted;
                Order tempOrder = (Order)orderList.get(i);
                if (!tempOrder.getType().equalsIgnoreCase(type) || (tempDeleted = TradeUtils.takeDownAndWait(tempOrder.getId(), 120000L, pair))) continue;
                completed = false;
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
            return false;
        }
        return completed;
    }

    public static boolean takeDownAndWait(String orderID, long timeoutMS, CurrencyPair pair) {
        ApiResponse deleteOrderResponse = Global.exchange.getTrade().cancelOrder(orderID, pair);
        if (deleteOrderResponse.isPositive()) {
            boolean delRequested = (Boolean)deleteOrderResponse.getResponseObject();
            if (delRequested) {
                LOG.warning("Order " + orderID + " delete request submitted");
            } else {
                LOG.severe("Could not submit request to delete order" + orderID);
            }
        } else {
            LOG.severe(deleteOrderResponse.getError().toString());
        }
        boolean timedout = false;
        boolean deleted = false;
        long wait = 6000L;
        long count = 0L;
        do {
            try {
                Thread.sleep(wait);
                timedout = (count += wait) > timeoutMS;
                ApiResponse orderDetailResponse = Global.exchange.getTrade().isOrderActive(orderID);
                if (!orderDetailResponse.isPositive()) {
                    LOG.severe(orderDetailResponse.getError().toString());
                    return false;
                }
                deleted = (Boolean)orderDetailResponse.getResponseObject() == false;
                LOG.fine("Does order " + orderID + "  still exist?" + !deleted);
            }
            catch (InterruptedException ex) {
                LOG.severe(ex.toString());
                return false;
            }
        } while (!deleted && !timedout);
        return !timedout;
    }

    public static double getSellPrice(double txFee) {
        if (Global.isDualSide) {
            return 1.0 + 0.01 * txFee;
        }
        return 1.0 + 0.01 * txFee + Global.options.getPriceIncrement();
    }

    public static double getBuyPrice(double txFeeUSDNTB) {
        return 1.0 - 0.01 * txFeeUSDNTB;
    }

    public static ArrayList<Order> filterOrders(ArrayList<Order> originalList, String type) {
        ArrayList<Order> toRet = new ArrayList<Order>();
        for (int i = 0; i < originalList.size(); ++i) {
            Order temp = originalList.get(i);
            if (!temp.getType().equalsIgnoreCase(type)) continue;
            toRet.add(temp);
        }
        return toRet;
    }

    public static String buildQueryString(HashMap<String, String> args, String encoding) {
        String result = new String();
        for (String hashkey : args.keySet()) {
            if (result.length() > 0) {
                result = result + '&';
            }
            try {
                result = result + URLEncoder.encode(hashkey, encoding) + "=" + URLEncoder.encode(args.get(hashkey), encoding);
            }
            catch (Exception ex) {
                LOG.severe(ex.toString());
            }
        }
        return result;
    }

    public static String buildQueryString(TreeMap<String, String> args, String encoding) {
        String result = new String();
        for (String hashkey : args.keySet()) {
            if (result.length() > 0) {
                result = result + '&';
            }
            try {
                result = result + URLEncoder.encode(hashkey, encoding) + "=" + URLEncoder.encode(args.get(hashkey), encoding);
            }
            catch (Exception ex) {
                LOG.severe(ex.toString());
            }
        }
        return result;
    }

    public static String getCCDKEvalidNonce() {
        String validNonce;
        String wrongNonce = "1234567891";
        if (offset == 0) {
            try {
                String htmlString = Utils.getHTML("https://www.ccedk.com/api/v1/currency/list?nonce=" + wrongNonce, false);
                validNonce = TradeUtils.getCCDKEvalidNonce(htmlString);
                offset = Integer.parseInt(validNonce) - (int)(System.currentTimeMillis() / 1000L);
            }
            catch (IOException io) {
                validNonce = "";
            }
        } else {
            validNonce = Objects.toString((int)(System.currentTimeMillis() / 1000L) + offset - 1);
        }
        if (!validNonce.equals("")) {
            String lastdigits = validNonce.substring(validNonce.length() - 2);
            if (lastdigits.equals("98") || lastdigits.equals("99")) {
                offset = 0;
                validNonce = TradeUtils.getCCDKEvalidNonce();
            }
        } else {
            offset = 0;
            validNonce = TradeUtils.getCCDKEvalidNonce();
        }
        return validNonce;
    }

    public static String getCCDKEvalidNonce(String htmlString) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject httpAnswerJson = (JSONObject)parser.parse(htmlString);
            JSONObject errors = (JSONObject)httpAnswerJson.get("errors");
            String nonceError = (String)errors.get("nonce");
            String startStr2 = " till";
            int indexStart2 = nonceError.lastIndexOf(startStr2) + startStr2.length() + 2;
            String to = nonceError.substring(indexStart2, indexStart2 + 10);
            return to;
        }
        catch (ParseException ex) {
            LOG.severe(htmlString + " " + ex.toString());
            return "1234567891";
        }
    }

    public static int getCCDKECurrencyId(String currencyCode) {
        String BTC = Constant.BTC.getCode();
        String USD = Constant.USD.getCode();
        String PPC = Constant.PPC.getCode();
        int toRet = -1;
        switch (currencyCode) {
            case "BTC": {
                toRet = 2;
                break;
            }
            case "USD": {
                toRet = 3;
                break;
            }
            case "PPC": {
                toRet = 8;
                break;
            }
            case "LTC": {
                toRet = 1;
                break;
            }
            case "NBT": {
                toRet = 15;
                break;
            }
            case "EUR": {
                toRet = 4;
                break;
            }
            default: {
                LOG.severe("Currency " + currencyCode + "not available");
            }
        }
        return toRet;
    }

    public static int getCCDKECurrencyPairId(CurrencyPair pair) {
        int toRet = -1;
        if (pair.equals(Constant.BTC_USD)) {
            return 2;
        }
        if (pair.equals(Constant.PPC_USD)) {
            return 14;
        }
        if (pair.equals(Constant.PPC_BTC)) {
            return 13;
        }
        if (pair.equals(Constant.PPC_LTC)) {
            return 12;
        }
        if (pair.equals(Constant.NBT_BTC)) {
            return 47;
        }
        if (pair.equals(Constant.NBT_PPC)) {
            return 48;
        }
        if (pair.equals(Constant.NBT_USD)) {
            return 46;
        }
        if (pair.equals(Constant.NBT_EUR)) {
            return 49;
        }
        LOG.severe("Pair " + pair.toString() + " not available");
        return toRet;
    }

    public static CurrencyPair getCCEDKPairFromID(int id) {
        CurrencyPair toRet = new CurrencyPair(Constant.BTC, Constant.BTC);
        switch (id) {
            case 2: {
                toRet = Constant.BTC_USD;
                break;
            }
            case 12: {
                toRet = Constant.PPC_LTC;
                break;
            }
            case 13: {
                toRet = Constant.PPC_BTC;
                break;
            }
            case 14: {
                toRet = Constant.PPC_USD;
                break;
            }
            case 46: {
                toRet = Constant.NBT_USD;
                break;
            }
            case 47: {
                toRet = Constant.NBT_BTC;
                break;
            }
            case 48: {
                toRet = Constant.NBT_PPC;
                break;
            }
            case 49: {
                toRet = Constant.NBT_EUR;
                break;
            }
            default: {
                LOG.severe("Pair with id = " + id + " not available");
            }
        }
        return toRet;
    }

    public static String getCCEDKTickerUrl(CurrencyPair pair) {
        String nonce = TradeUtils.getCCDKEvalidNonce();
        return "https://www.ccedk.com/api/v1/stats/marketdepth?nonce=" + nonce + "&pair_id=" + TradeUtils.getCCDKECurrencyPairId(pair);
    }
}

