/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tests;

import com.nubits.nubot.global.Constant;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.LastPrice;
import com.nubits.nubot.pricefeeds.AbstractPriceFeed;
import com.nubits.nubot.pricefeeds.BitstampEURPriceFeed;
import com.nubits.nubot.pricefeeds.PriceFeedManager;
import com.nubits.nubot.utils.Utils;
import com.nubits.nubot.utils.logging.NuLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestPriceFeed {
    private static final Logger LOG = Logger.getLogger(TestPriceFeed.class.getName());
    AbstractPriceFeed feed;
    CurrencyPair pair;

    public static void main(String[] a) {
        TestPriceFeed test = new TestPriceFeed();
        test.init();
        test.pair = Constant.BTC_USD;
        test.execute();
    }

    private void init() {
        Utils.loadProperties("settings.properties");
        String folderName = "tests_" + System.currentTimeMillis() + "/";
        String logsFolder = Global.settings.getProperty("log_path") + folderName;
        try {
            NuLogger.setup(false, logsFolder);
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
        LOG.setLevel(Level.INFO);
        this.feed = new BitstampEURPriceFeed();
        LOG.info("Set up SSL certificates");
        System.setProperty("javax.net.ssl.trustStore", Global.settings.getProperty("keystore_path"));
        System.setProperty("javax.net.ssl.trustStorePassword", Global.settings.getProperty("keystore_pass"));
    }

    private void executeSingle() {
        LastPrice lastPrice = this.feed.getLastPrice(this.pair);
        if (!lastPrice.isError()) {
            LOG.info(lastPrice.toString());
        } else {
            LOG.severe("There was a problem while updating the price");
        }
    }

    private void execute() {
        String mainFeed = "btce";
        ArrayList<String> backupFeedList = new ArrayList<String>();
        backupFeedList.add("bitcoinaverage");
        backupFeedList.add("blockchain");
        backupFeedList.add("coinbase");
        backupFeedList.add("bter");
        backupFeedList.add("ccedk");
        backupFeedList.add("bitstamp");
        backupFeedList.add("bitfinex");
        PriceFeedManager pfm = new PriceFeedManager(mainFeed, backupFeedList, this.pair);
        PriceFeedManager.LastPriceResponse lpr = pfm.getLastPrices();
        ArrayList<LastPrice> priceList = pfm.getLastPrices().getPrices();
        LOG.info("CheckLastPrice received values from remote feeds. ");
        LOG.info("Positive response from " + priceList.size() + "/" + pfm.getFeedList().size() + " feeds");
        for (int i = 0; i < priceList.size(); ++i) {
            LastPrice tempPrice = priceList.get(i);
            LOG.info(tempPrice.getSource() + ":1 " + tempPrice.getCurrencyMeasured().getCode() + " = " + tempPrice.getPrice().getQuantity() + " " + tempPrice.getPrice().getCurrency().getCode());
        }
    }

    private void executePPC() {
        String mainFeed = "btce";
        ArrayList<String> backupFeedList = new ArrayList<String>();
        backupFeedList.add("coinmarketcap_no");
        backupFeedList.add("coinmarketcap_ne");
        PriceFeedManager pfm = new PriceFeedManager(mainFeed, backupFeedList, this.pair);
        ArrayList<LastPrice> priceList = pfm.getLastPrices().getPrices();
        LOG.info("CheckLastPrice received values from remote feeds. ");
        LOG.info("Positive response from " + priceList.size() + "/" + pfm.getFeedList().size() + " feeds");
        for (int i = 0; i < priceList.size(); ++i) {
            LastPrice tempPrice = priceList.get(i);
            LOG.info(tempPrice.getSource() + ":1 " + tempPrice.getCurrencyMeasured().getCode() + " = " + tempPrice.getPrice().getQuantity() + " " + tempPrice.getPrice().getCurrency().getCode());
        }
    }
}

