/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tasks.strategy;

import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Balance;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.notifications.HipChatNotifications;
import com.nubits.nubot.notifications.MailNotifications;
import com.nubits.nubot.notifications.jhipchat.messages.Message;
import com.nubits.nubot.tasks.strategy.StrategySecondaryPegTask;
import com.nubits.nubot.trading.TradeUtils;
import com.nubits.nubot.utils.Utils;
import java.util.ArrayList;
import java.util.logging.Logger;

public class StrategySecondaryPegUtils {
    private static final Logger LOG = Logger.getLogger(StrategySecondaryPegUtils.class.getName());
    private StrategySecondaryPegTask strategy;
    private final int MAX_RANDOM_WAIT_SECONDS = 5;
    private final int SHORT_WAIT_SECONDS = 6;

    public StrategySecondaryPegUtils(StrategySecondaryPegTask strategy) {
        this.strategy = strategy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reInitiateOrders(boolean firstTime) {
        if (this.strategy.getTotalActiveOrders() == 0) {
            if (firstTime) {
                Global.frozenBalances.setBalanceAlreadyThere(Global.options.getPair().getPaymentCurrency());
            }
            this.placeInitialWalls();
        } else {
            ApiResponse deleteOrdersResponse = Global.exchange.getTrade().clearOrders(Global.options.getPair());
            if (!deleteOrdersResponse.isPositive()) {
                LOG.severe(deleteOrdersResponse.getError().toString());
                String message = "Could not submit request to clear orders";
                LOG.severe(message);
                return false;
            }
            boolean deleted = (Boolean)deleteOrdersResponse.getResponseObject();
            if (!deleted) {
                String message = "Could not submit request to clear orders";
                LOG.severe(message);
                return false;
            }
            LOG.warning("Clear all orders request succesfully");
            if (firstTime) {
                Global.frozenBalances.setBalanceAlreadyThere(Global.options.getPair().getPaymentCurrency());
            }
            boolean timedOut = false;
            long timeout = Global.options.getEmergencyTimeout() * 1000;
            long wait = 6000L;
            long count = 0L;
            boolean areAllOrdersCanceled = false;
            do {
                try {
                    Thread.sleep(wait);
                    areAllOrdersCanceled = TradeUtils.tryCancelAllOrders(Global.options.getPair());
                    LOG.info("Are all orders canceled? " + areAllOrdersCanceled);
                    timedOut = (count += wait) > timeout;
                }
                catch (InterruptedException ex) {
                    LOG.severe(ex.toString());
                }
            } while (!areAllOrdersCanceled && !timedOut);
            if (timedOut) {
                String message = "There was a problem cancelling all existing orders";
                LOG.severe(message);
                HipChatNotifications.sendMessage(message, Message.Color.YELLOW);
                MailNotifications.send(Global.options.getMailRecipient(), "NuBot : Problem cancelling existing orders", message);
            }
            this.placeInitialWalls();
        }
        try {
            Thread.sleep(6L);
            return true;
        }
        catch (InterruptedException ex) {
            LOG.severe(ex.toString());
        }
        return true;
    }

    public void placeInitialWalls() {
        boolean buysOrdersOk = true;
        boolean sellsOrdersOk = this.initOrders("SELL", this.strategy.getSellPricePEG());
        if (Global.options.isDualSide()) {
            buysOrdersOk = this.initOrders("BUY", this.strategy.getBuyPricePEG());
        }
        if (buysOrdersOk && sellsOrdersOk) {
            this.strategy.setMightNeedInit(false);
            LOG.info("Initial walls placed");
        } else {
            this.strategy.setMightNeedInit(true);
        }
    }

    public boolean initOrders(String type, double price) {
        boolean success = true;
        Amount balance = null;
        Currency currency = !Global.swappedPair ? (type.equals("SELL") ? Global.options.getPair().getOrderCurrency() : Global.options.getPair().getPaymentCurrency()) : (type.equals("SELL") ? Global.options.getPair().getPaymentCurrency() : Global.options.getPair().getOrderCurrency());
        ApiResponse balancesResponse = Global.exchange.getTrade().getAvailableBalance(currency);
        if (balancesResponse.isPositive()) {
            double oneNBT = 1.0;
            if (type.equals("SELL")) {
                balance = (Amount)balancesResponse.getResponseObject();
            } else {
                balance = (Amount)balancesResponse.getResponseObject();
                balance = Global.frozenBalances.removeFrozenAmount(balance, Global.frozenBalances.getFrozenAmount());
                oneNBT = Utils.round(1.0 / Global.conversion, 8);
            }
            if (balance.getQuantity() > oneNBT * 2.0) {
                ApiResponse txFeeNTBPEGResponse = Global.exchange.getTrade().getTxFee(Global.options.getPair());
                if (txFeeNTBPEGResponse.isPositive()) {
                    String orderString1;
                    double txFeePEGNTB = (Double)txFeeNTBPEGResponse.getResponseObject();
                    LOG.fine("Updated Transaction fee = " + txFeePEGNTB + "%");
                    double amount1 = Utils.round(balance.getQuantity() / 2.0, 8);
                    if (Global.options.getMaxSellVolume() > 0.0 && type.equals("SELL")) {
                        double d = amount1 = amount1 > Global.options.getMaxSellVolume() / 2.0 ? Global.options.getMaxSellVolume() / 2.0 : amount1;
                    }
                    if (type.equals("BUY") && !Global.swappedPair) {
                        amount1 = Utils.round(amount1 / price, 8);
                        if (Global.options.getMaxBuyVolume() > 0.0) {
                            amount1 = amount1 > Global.options.getMaxBuyVolume() / 2.0 ? Global.options.getMaxBuyVolume() / 2.0 : amount1;
                        }
                    }
                    String sideStr = type + " side order : ";
                    if (!Global.swappedPair) {
                        orderString1 = sideStr + " " + type + " " + Utils.round(amount1, 4) + " " + Global.options.getPair().getOrderCurrency().getCode() + " @ " + price + " " + Global.options.getPair().getPaymentCurrency().getCode();
                    } else {
                        String typeStr;
                        if (type.equals("SELL")) {
                            typeStr = "BUY";
                            amount1 = Utils.round(amount1 / Global.conversion, 8);
                            if (Global.options.getMaxSellVolume() > 0.0) {
                                amount1 = amount1 > Global.options.getMaxSellVolume() ? Global.options.getMaxSellVolume() : amount1;
                            }
                        } else {
                            typeStr = "SELL";
                        }
                        orderString1 = sideStr + " " + typeStr + " " + Utils.round(amount1, 4) + " " + Global.options.getPair().getOrderCurrency().getCode() + " @ " + price + " " + Global.options.getPair().getPaymentCurrency().getCode();
                    }
                    if (Global.options.isExecuteOrders()) {
                        LOG.warning("Strategy - Submit order : " + orderString1);
                        ApiResponse order1Response = type.equals("SELL") ? (Global.swappedPair ? Global.exchange.getTrade().buy(Global.options.getPair(), amount1, price) : Global.exchange.getTrade().sell(Global.options.getPair(), amount1, price)) : (Global.swappedPair ? Global.exchange.getTrade().sell(Global.options.getPair(), amount1, price) : Global.exchange.getTrade().buy(Global.options.getPair(), amount1, price));
                        if (order1Response.isPositive()) {
                            HipChatNotifications.sendMessage("New " + type + " wall is up on " + Global.options.getExchangeName() + " : " + orderString1, Message.Color.YELLOW);
                            String response1String = (String)order1Response.getResponseObject();
                            LOG.warning("Strategy - " + type + " Response1 = " + response1String);
                        } else {
                            LOG.severe(order1Response.getError().toString());
                            success = false;
                        }
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ex) {
                            LOG.severe(ex.toString());
                        }
                        ApiResponse balancesResponse2 = Global.exchange.getTrade().getAvailableBalance(currency);
                        if (balancesResponse2.isPositive()) {
                            String orderString2;
                            balance = (Amount)balancesResponse2.getResponseObject();
                            if (type.equals("BUY")) {
                                balance = Global.frozenBalances.removeFrozenAmount(balance, Global.frozenBalances.getFrozenAmount());
                            }
                            double amount2 = balance.getQuantity();
                            if (Global.options.getMaxSellVolume() > 0.0 && type.equals("SELL")) {
                                double d = amount2 = amount2 > Global.options.getMaxSellVolume() / 2.0 ? Global.options.getMaxSellVolume() / 2.0 : amount2;
                            }
                            if (type.equals("BUY") && !Global.swappedPair || type.equals("SELL") && Global.swappedPair) {
                                amount2 = Utils.round(amount2 - oneNBT * 0.9, 8);
                                amount2 = Utils.round(amount2 / price, 8);
                                if (Global.options.getMaxBuyVolume() > 0.0) {
                                    double d = amount2 = amount2 > Global.options.getMaxBuyVolume() / 2.0 ? Global.options.getMaxBuyVolume() / 2.0 : amount2;
                                }
                            }
                            if (!Global.swappedPair) {
                                orderString2 = sideStr + " " + type + " " + Utils.round(amount2, 4) + " " + Global.options.getPair().getOrderCurrency().getCode() + " @ " + price + " " + Global.options.getPair().getPaymentCurrency().getCode();
                            } else {
                                String typeStr = type.equals("SELL") ? "BUY" : "SELL";
                                orderString2 = sideStr + " " + typeStr + " " + Utils.round(amount2, 4) + " " + Global.options.getPair().getOrderCurrency().getCode() + " @ " + price + " " + Global.options.getPair().getPaymentCurrency().getCode();
                            }
                            LOG.warning("Strategy - Submit order : " + orderString2);
                            ApiResponse order2Response = type.equals("SELL") ? (Global.swappedPair ? Global.exchange.getTrade().buy(Global.options.getPair(), amount2, price) : Global.exchange.getTrade().sell(Global.options.getPair(), amount2, price)) : (Global.swappedPair ? Global.exchange.getTrade().sell(Global.options.getPair(), amount2, price) : Global.exchange.getTrade().buy(Global.options.getPair(), amount2, price));
                            if (order2Response.isPositive()) {
                                HipChatNotifications.sendMessage("New " + type + " wall is up on " + Global.options.getExchangeName() + " : " + orderString2, Message.Color.YELLOW);
                                String response2String = (String)order2Response.getResponseObject();
                                LOG.warning("Strategy : " + type + " Response2 = " + response2String);
                            } else {
                                LOG.severe(order2Response.getError().toString());
                                success = false;
                            }
                        } else {
                            LOG.severe("Error while reading the balance the second time " + balancesResponse2.getError().toString());
                        }
                    } else {
                        LOG.warning("Should execute orders");
                    }
                }
            } else {
                LOG.fine(type + " available balance < 1 NBT, no need to execute orders");
            }
        } else {
            LOG.severe(balancesResponse.getError().toString());
            success = false;
        }
        return success;
    }

    public int countActiveOrders(String type) {
        int toRet = 0;
        ApiResponse activeOrdersResponse = Global.exchange.getTrade().getActiveOrders(Global.options.getPair());
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            for (int i = 0; i < orderList.size(); ++i) {
                Order tempOrder = (Order)orderList.get(i);
                if (!tempOrder.getType().equalsIgnoreCase(type)) continue;
                ++toRet;
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
            return -1;
        }
        return toRet;
    }

    public void recount() {
        ApiResponse balancesResponse = Global.exchange.getTrade().getAvailableBalances(Global.options.getPair());
        if (balancesResponse.isPositive()) {
            Balance balance = (Balance)balancesResponse.getResponseObject();
            double balanceNBT = balance.getNBTAvailable().getQuantity();
            double balancePEG = Global.frozenBalances.removeFrozenAmount(balance.getPEGAvailableBalance(), Global.frozenBalances.getFrozenAmount()).getQuantity();
            this.strategy.setActiveSellOrders(this.countActiveOrders("SELL"));
            this.strategy.setActiveBuyOrders(this.countActiveOrders("BUY"));
            this.strategy.setTotalActiveOrders(this.strategy.getActiveBuyOrders() + this.strategy.getActiveSellOrders());
            this.strategy.setOrdersAndBalancesOK(false);
            double oneNBT = Utils.round(1.0 / Global.conversion, 8);
            int activeSellOrders = this.strategy.getActiveSellOrders();
            int activeBuyOrders = this.strategy.getActiveBuyOrders();
            if (Global.options.isDualSide()) {
                this.strategy.setOrdersAndBalancesOK(activeSellOrders == 2 && activeBuyOrders == 2 || activeSellOrders == 2 && activeBuyOrders == 0 && balancePEG < oneNBT || activeSellOrders == 0 && activeBuyOrders == 2 && balanceNBT < 1.0);
                if (balancePEG > oneNBT && Global.options.getPair().getPaymentCurrency().isFiat() && !this.strategy.isFirstTime() && Global.options.getMaxBuyVolume() != 0.0) {
                    LOG.warning("The " + balance.getPEGAvailableBalance().getCurrency().getCode() + " balance is not zero (" + balancePEG + " ). If the balance represent proceedings " + "from a sale the bot will notice.  On the other hand, If you keep seying this message repeatedly over and over, you should restart the bot. ");
                    this.strategy.setProceedsInBalance(true);
                } else {
                    this.strategy.setProceedsInBalance(false);
                }
            } else if (Global.options.isAggregate()) {
                this.strategy.setOrdersAndBalancesOK(activeSellOrders == 2 && activeBuyOrders == 0 && balanceNBT < 1.0);
            } else {
                this.strategy.setOrdersAndBalancesOK(activeSellOrders == 2 && activeBuyOrders == 0);
            }
        } else {
            LOG.severe(balancesResponse.getError().toString());
        }
    }

    public void aggregateAndKeepProceeds() {
        boolean cancel = TradeUtils.takeDownOrders("BUY", Global.options.getPair());
        if (cancel) {
            Global.frozenBalances.freezeNewFunds();
            try {
                Thread.sleep(Utils.randInt(0, 5) * 1000);
            }
            catch (InterruptedException ex) {
                LOG.severe(ex.toString());
            }
            this.initOrders("BUY", this.strategy.getBuyPricePEG());
        } else {
            LOG.severe("An error occurred while attempting to cancel buy orders.");
        }
    }

    public String[] getSmallerWallID(String type) {
        String[] toRet = new String[2];
        Order smallerOrder = new Order();
        Order biggerOrder = new Order();
        smallerOrder.setId("-1");
        biggerOrder.setId("-1");
        ApiResponse activeOrdersResponse = Global.exchange.getTrade().getActiveOrders(Global.options.getPair());
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            ArrayList<Order> orderListCategorized = TradeUtils.filterOrders(orderList, type);
            if (orderListCategorized.size() != 2) {
                LOG.severe("The number of orders on the " + type + " side is not two (" + orderListCategorized.size() + ")");
                String[] err = new String[]{"-1", "-1"};
                return err;
            }
            Order tempOrder1 = orderListCategorized.get(0);
            Order tempOrder2 = orderListCategorized.get(1);
            smallerOrder = tempOrder1;
            biggerOrder = tempOrder2;
            if (tempOrder1.getAmount().getQuantity() > tempOrder2.getAmount().getQuantity()) {
                smallerOrder = tempOrder2;
                biggerOrder = tempOrder1;
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
            String[] err = new String[]{"-1", "-1"};
            return err;
        }
        toRet[0] = smallerOrder.getId();
        toRet[1] = biggerOrder.getId();
        return toRet;
    }

    public boolean shiftWalls() {
        double priceWaitType;
        double priceImmediatelyType;
        String waitAndShiftOrderType;
        String shiftImmediatelyOrderType;
        boolean success = true;
        int WAIT_TIME_FIX_156_EXCOIN = 3500;
        int refresh_time_seconds = Integer.parseInt(Global.settings.getProperty("refresh_time_seconds"));
        this.strategy.getPriceMonitorTask().setWallsBeingShifted(true);
        this.strategy.getSendLiquidityTask().setWallsBeingShifted(true);
        double sellPrice = this.strategy.getSellPricePEG();
        double buyPrice = this.strategy.getBuyPricePEG();
        if (this.strategy.getPriceDirection().equals("up")) {
            shiftImmediatelyOrderType = "SELL";
            waitAndShiftOrderType = "BUY";
            if (!Global.swappedPair) {
                priceImmediatelyType = sellPrice;
                priceWaitType = buyPrice;
            } else {
                priceImmediatelyType = buyPrice;
                priceWaitType = sellPrice;
            }
        } else {
            shiftImmediatelyOrderType = "BUY";
            waitAndShiftOrderType = "SELL";
            if (!Global.swappedPair) {
                priceImmediatelyType = buyPrice;
                priceWaitType = sellPrice;
            } else {
                priceImmediatelyType = sellPrice;
                priceWaitType = buyPrice;
            }
        }
        if (!Global.isDualSide && shiftImmediatelyOrderType.equals("SELL") || Global.isDualSide) {
            LOG.info("Immediately try to cancel all orders");
            ApiResponse deleteOrdersResponse = Global.exchange.getTrade().clearOrders(Global.options.getPair());
            if (deleteOrdersResponse.isPositive()) {
                boolean deleted = (Boolean)deleteOrdersResponse.getResponseObject();
                if (deleted) {
                    boolean init1;
                    if (Global.options.isMultipleCustodians()) {
                        try {
                            Thread.sleep(6 + Utils.randInt(0, 5) * 1000);
                        }
                        catch (InterruptedException ex) {
                            LOG.severe(ex.toString());
                        }
                    }
                    if (shiftImmediatelyOrderType.equals("BUY") && !Global.options.getPair().getPaymentCurrency().isFiat()) {
                        Global.frozenBalances.freezeNewFunds();
                    }
                    if (!Global.swappedPair) {
                        init1 = this.initOrders(shiftImmediatelyOrderType, priceImmediatelyType);
                    } else {
                        try {
                            Thread.sleep(WAIT_TIME_FIX_156_EXCOIN);
                        }
                        catch (InterruptedException ex) {
                            LOG.severe(ex.toString());
                        }
                        init1 = this.initOrders(waitAndShiftOrderType, priceImmediatelyType);
                    }
                    if (!init1) {
                        success = false;
                    }
                    if (success) {
                        if (!Global.isDualSide && shiftImmediatelyOrderType.equals("BUY") || Global.isDualSide) {
                            boolean init2;
                            if (waitAndShiftOrderType.equals("BUY") && !Global.options.getPair().getPaymentCurrency().isFiat()) {
                                Global.frozenBalances.freezeNewFunds();
                            }
                            if (!Global.swappedPair) {
                                init2 = this.initOrders(waitAndShiftOrderType, priceWaitType);
                            } else {
                                try {
                                    Thread.sleep(WAIT_TIME_FIX_156_EXCOIN);
                                }
                                catch (InterruptedException ex) {
                                    LOG.severe(ex.toString());
                                }
                                init2 = this.initOrders(shiftImmediatelyOrderType, priceWaitType);
                            }
                            if (!init2) {
                                success = false;
                            }
                        }
                    } else if (!Global.isDualSide && shiftImmediatelyOrderType.equals("SELL") || Global.isDualSide) {
                        LOG.severe("NuBot has not been able to shift " + shiftImmediatelyOrderType + " orders");
                    }
                    try {
                        Thread.sleep(6000L);
                    }
                    catch (InterruptedException ex) {
                        LOG.severe(ex.toString());
                    }
                    this.strategy.getPriceMonitorTask().setWallsBeingShifted(false);
                    this.strategy.getSendLiquidityTask().setWallsBeingShifted(false);
                } else {
                    LOG.info("Could not submit request to clear orders");
                    success = false;
                }
            } else {
                success = false;
                this.strategy.getPriceMonitorTask().setWallsBeingShifted(false);
                this.strategy.getSendLiquidityTask().setWallsBeingShifted(false);
                LOG.severe(deleteOrdersResponse.getError().toString());
            }
        }
        return success;
    }
}

