/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tasks;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class BotTask {
    private static final Logger LOG = Logger.getLogger(BotTask.class.getName());
    private Timer timer;
    private boolean running;
    private long interval;
    private TimerTask task;
    private String name;

    public BotTask(TimerTask task, long interval, String name) {
        this.timer = new Timer(name);
        this.running = false;
        this.name = name;
        this.interval = interval;
        this.task = task;
    }

    public void toggle() {
        if (!this.isRunning()) {
            this.start();
        } else {
            this.stop();
        }
    }

    public void start() {
        this.timer.scheduleAtFixedRate(this.task, 0L, this.interval * 1000L);
        this.setRunning(true);
        LOG.fine("Started BotTask " + this.name);
    }

    public void start(int delay) {
        this.timer.scheduleAtFixedRate(this.task, delay * 1000, this.interval * 1000L);
        this.setRunning(true);
        LOG.fine("Started BotTask " + this.name);
    }

    public void stop() {
        this.timer.cancel();
        this.setRunning(false);
        LOG.fine("Stopped BotTask " + this.name);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public TimerTask getTask() {
        return this.task;
    }

    public void setTask(TimerTask task) {
        this.task = task;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

