/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.pricefeeds;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.exchanges.ExchangeLiveData;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.LastPrice;
import com.nubits.nubot.pricefeeds.AbstractPriceFeed;
import com.nubits.nubot.trading.Ticker;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.trading.wrappers.BterWrapper;
import java.util.logging.Logger;

public class BterPriceFeed
extends AbstractPriceFeed {
    private static final Logger LOG = Logger.getLogger(BterPriceFeed.class.getName());

    public BterPriceFeed() {
        this.name = "bter";
        this.refreshMinTime = 50000L;
    }

    @Override
    public LastPrice getLastPrice(CurrencyPair pair) {
        long now = System.currentTimeMillis();
        long diff = now - this.lastRequest;
        if (diff >= this.refreshMinTime) {
            try {
                Exchange exch = new Exchange("bter");
                ExchangeLiveData liveData = new ExchangeLiveData();
                exch.setLiveData(liveData);
                ApiKeys keys = new ApiKeys("a", "b");
                exch.setTrade(new BterWrapper(keys, exch));
                BterWrapper trader = (BterWrapper)exch.getTrade();
                ApiResponse lastPriceResponse = trader.getLastPriceFeed(pair);
                if (lastPriceResponse.isPositive()) {
                    Ticker ticker = (Ticker)lastPriceResponse.getResponseObject();
                    double last = ticker.getLast();
                    this.lastRequest = System.currentTimeMillis();
                    this.lastPrice = new LastPrice(false, this.name, pair.getOrderCurrency(), new Amount(last, pair.getPaymentCurrency()));
                    return this.lastPrice;
                }
                LOG.severe(lastPriceResponse.getError().toString());
                this.lastRequest = System.currentTimeMillis();
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
            catch (Exception ex) {
                LOG.severe(ex.toString());
                this.lastRequest = System.currentTimeMillis();
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
        }
        LOG.fine("Wait " + (this.refreshMinTime - (System.currentTimeMillis() - this.lastRequest)) + " ms " + "before making a new request. Now returning the last saved price\n\n");
        return this.lastPrice;
    }

    private String getUrl(CurrencyPair pair) {
        return "http://data.bter.com/api/1/ticker/" + pair.toString("_");
    }
}

