/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.options;

import com.nubits.nubot.models.CurrencyPair;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class SecondaryPegOptionsJSON {
    private static final Logger LOG = Logger.getLogger(SecondaryPegOptionsJSON.class.getName());
    private String mainFeed;
    private ArrayList<String> backupFeedNames;
    private double wallchangeThreshold;
    private double spread;
    private double distanceThreshold;

    public SecondaryPegOptionsJSON(double wallchangeThreshold, double spread, double distanceThreshold, String mainFeed, ArrayList<String> backupFeedNames) {
        this.wallchangeThreshold = wallchangeThreshold;
        this.spread = spread;
        this.distanceThreshold = distanceThreshold;
        this.mainFeed = mainFeed;
        this.backupFeedNames = backupFeedNames;
    }

    public static SecondaryPegOptionsJSON create(JSONObject optionsJSON, CurrencyPair pair) {
        Object options = null;
        try {
            String mainFeed = (String)optionsJSON.get("main-feed");
            ArrayList<String> backupFeedNames = new ArrayList<String>();
            JSONObject dataJson = (JSONObject)optionsJSON.get("backup-feeds");
            String[] names = JSONObject.getNames(dataJson);
            if (names.length < 2) {
                LOG.severe("The bot requires at least two backup data feeds to run");
                System.exit(0);
            }
            for (int i = 0; i < names.length; ++i) {
                try {
                    JSONObject tempJson = dataJson.getJSONObject(names[i]);
                    backupFeedNames.add((String)tempJson.get("name"));
                    continue;
                }
                catch (JSONException ex) {
                    LOG.severe(ex.toString());
                    System.exit(0);
                }
            }
            if (pair.getPaymentCurrency().isFiat()) {
                long refreshTime = 28320000L;
            } else {
                long refreshTime = 61L;
            }
            double wallchangeThreshold = 0.5;
            double spread = 0.0;
            double distanceThreshold = 10.0;
            if (optionsJSON.has("wallshift-threshold")) {
                wallchangeThreshold = new Double(optionsJSON.get("wallshift-threshold").toString());
            }
            if (optionsJSON.has("spread") && (spread = new Double(optionsJSON.get("spread").toString()).doubleValue()) != 0.0) {
                LOG.warning("You are using the \"spread\" != 0 , which is not reccomented by Nu developers for purposes different from testing.");
            }
            if (optionsJSON.has("price-distance-threshold")) {
                distanceThreshold = new Double(optionsJSON.get("price-distance-threshold").toString());
            }
            return new SecondaryPegOptionsJSON(wallchangeThreshold, spread, distanceThreshold, mainFeed, backupFeedNames);
        }
        catch (JSONException ex) {
            LOG.severe(ex.toString());
            System.exit(0);
            return null;
        }
    }

    public double getWallchangeThreshold() {
        return this.wallchangeThreshold;
    }

    public void setWallchangeThreshold(double wallchangeThreshold) {
        this.wallchangeThreshold = wallchangeThreshold;
    }

    public double getSpread() {
        return this.spread;
    }

    public void setSpread(double spread) {
        this.spread = spread;
    }

    public double getDistanceThreshold() {
        return this.distanceThreshold;
    }

    public void setDistanceThreshold(double distanceThreshold) {
        this.distanceThreshold = distanceThreshold;
    }

    public String getMainFeed() {
        return this.mainFeed;
    }

    public void setMainFeed(String mainFeed) {
        this.mainFeed = mainFeed;
    }

    public ArrayList<String> getBackupFeedNames() {
        return this.backupFeedNames;
    }

    public void setBackupFeedNames(ArrayList<String> backupFeedNames) {
        this.backupFeedNames = backupFeedNames;
    }

    public String toString() {
        return "SecondaryPegOptionsJSON [backupFeedNames " + this.backupFeedNames + " " + "distanceThreshold " + this.distanceThreshold + "mainFeed " + this.mainFeed + " " + "spread " + this.spread + "  " + "wallchangeThreshold " + this.wallchangeThreshold + "]";
    }

    String toHtmlString() {
        return "SecondaryPegOptionsJSON : <br>backupFeedNames " + this.backupFeedNames + " <br>" + "distanceThreshold " + this.distanceThreshold + "<br>" + "mainFeed " + this.mainFeed + " <br>" + "spread " + this.spread + " <br>" + "wallchangeThreshold " + this.wallchangeThreshold;
    }
}

