/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.notifications.jhipchat;

import com.nubits.nubot.notifications.jhipchat.HipChat;
import com.nubits.nubot.notifications.jhipchat.User;
import com.nubits.nubot.notifications.jhipchat.UtilParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class UserParser {
    public static List<User> parseUserList(HipChat origin, InputStream input) throws JsonParseException, JsonMappingException, IOException {
        JsonParser jp = HipChat.JSON_FACTORY.createJsonParser(input);
        ObjectMapper mapper = new ObjectMapper();
        List<User> users = null;
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String tag = jp.getText();
            if (!"users".equals(tag)) continue;
            jp.nextToken();
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                User user = UserParser.parseUser(origin, mapper, jp);
                if (users == null) {
                    users = new ArrayList<User>();
                }
                users.add(user);
            }
        }
        if (users == null) {
            users = Collections.emptyList();
        }
        return users;
    }

    public static User parseUser(HipChat origin, InputStream input) throws JsonParseException, JsonMappingException, IOException {
        JsonParser jp = HipChat.JSON_FACTORY.createJsonParser(input);
        ObjectMapper mapper = new ObjectMapper();
        User user = null;
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String tag = jp.getText();
            if (!"user".equals(tag)) continue;
            jp.nextToken();
            user = UserParser.parseUser(origin, mapper, jp);
        }
        return user;
    }

    private static User parseUser(HipChat origin, ObjectMapper mapper, JsonParser jp) throws JsonParseException, JsonMappingException, IOException {
        User result = null;
        String userId = null;
        String name = null;
        String email = null;
        String title = null;
        String password = null;
        String photoUrl = null;
        String status = null;
        String statusMessage = null;
        boolean isGroupAdmin = false;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String tag = jp.getText();
            jp.nextToken();
            if ("user_id".equals(tag)) {
                userId = UtilParser.parseString(jp);
                continue;
            }
            if ("name".equals(tag)) {
                name = UtilParser.parseString(jp);
                continue;
            }
            if ("email".equals(tag)) {
                email = UtilParser.parseString(jp);
                continue;
            }
            if ("title".equals(tag)) {
                title = UtilParser.parseString(jp);
                continue;
            }
            if ("is_group_admin".equals(tag)) {
                int admin = jp.getIntValue();
                isGroupAdmin = admin == 1;
                continue;
            }
            if ("password".equals(tag)) {
                password = UtilParser.parseString(jp);
                continue;
            }
            if ("photo_url".equals(tag)) {
                photoUrl = UtilParser.parseString(jp);
                continue;
            }
            if ("status".equals(tag)) {
                status = UtilParser.parseString(jp);
                continue;
            }
            if (!"status_message".equals(tag)) continue;
            statusMessage = UtilParser.parseString(jp);
        }
        result = User.create(userId, name, email, title, photoUrl, password, status, statusMessage, isGroupAdmin);
        return result;
    }
}

