/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.notifications;

import com.nubits.nubot.global.Global;
import com.sun.mail.smtp.SMTPTransport;
import com.sun.net.ssl.internal.ssl.Provider;
import java.security.Security;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailNotifications {
    private static final Logger LOG = Logger.getLogger(MailNotifications.class.getName());

    public static void send(String address, String title, String message) {
        if (Global.options == null || Global.options.isSendMails()) {
            try {
                MailNotifications.Send(address, title, message);
            }
            catch (AddressException ex) {
                LOG.severe(ex.toString());
            }
            catch (MessagingException ex) {
                LOG.severe(ex.toString());
            }
        }
    }

    private MailNotifications() {
    }

    private static void Send(String recipientEmail, String title, String message) throws AddressException, MessagingException {
        title = "[NuBot] " + title;
        Date now = new Date();
        String footer = "\n --- \n Message generated at " + now;
        if (Global.options != null) {
            footer = footer + "from bot with custodial address " + Global.options.getNubitsAddress() + " on " + Global.options.getExchangeName();
        }
        message = message + footer;
        MailNotifications.Send(recipientEmail, "", title, message);
    }

    private static void Send(String recipientEmail, String ccEmail, String title, String message) throws AddressException, MessagingException {
        Security.addProvider((java.security.Provider)new Provider());
        String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
        Properties props = System.getProperties();
        props.setProperty("mail.smtps.host", "mail.privateemail.com");
        props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.setProperty("mail.smtp.port", "465");
        props.setProperty("mail.smtp.socketFactory.port", "465");
        props.setProperty("mail.smtps.auth", "false");
        props.put("mail.smtps.quitwait", "false");
        Session session = Session.getInstance(props, null);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom(new InternetAddress("nubot@nubottrading.com"));
        msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(recipientEmail, false));
        if (ccEmail.length() > 0) {
            msg.setRecipients(Message.RecipientType.CC, InternetAddress.parse(ccEmail, false));
        }
        msg.setSubject(title);
        msg.setText(message, "utf-8");
        msg.setSentDate(new Date());
        SMTPTransport t = (SMTPTransport)session.getTransport("smtps");
        t.connect("mail.privateemail.com", "nubot@nubottrading.com", ":xB46wKntu[9:");
        t.sendMessage(msg, msg.getAllRecipients());
        t.close();
    }
}

