/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.models;

import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.CurrencyPair;
import java.text.DecimalFormat;
import java.util.Date;

public class Trade {
    private String id;
    private String order_id;
    private CurrencyPair pair;
    private String type;
    private Amount price;
    private Amount amount;
    private Amount fee;
    private Date date;
    private String exchangeName;

    public Trade(String id, String order_id, CurrencyPair pair, String type, Amount price, Amount amount, Amount fee, Date date, String exchangeName) {
        this.id = id;
        this.order_id = order_id;
        this.pair = pair;
        this.type = type;
        this.price = price;
        this.amount = amount;
        this.date = date;
        this.fee = fee;
        this.exchangeName = exchangeName;
    }

    public Trade() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrder_id() {
        return this.order_id;
    }

    public void setOrder_id(String order_id) {
        this.order_id = order_id;
    }

    public CurrencyPair getPair() {
        return this.pair;
    }

    public void setPair(CurrencyPair pair) {
        this.pair = pair;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Amount getPrice() {
        return this.price;
    }

    public void setPrice(Amount price) {
        this.price = price;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Amount getFee() {
        return this.fee;
    }

    public void setFee(Amount fee) {
        this.fee = fee;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public String toString() {
        return "Trade{id=" + this.id + ", order_id=" + this.order_id + ", pair=" + this.pair + ", type=" + this.type + ", price=" + this.price + ", amount=" + this.amount + ", fee=" + this.fee + ", date=" + this.date + ", exchangeName=" + this.exchangeName + '}';
    }

    public String toJSONString() {
        DecimalFormat df = new DecimalFormat("0");
        df.setMaximumFractionDigits(8);
        String feeString = "N.A.";
        if (this.fee != null) {
            feeString = df.format(this.fee.getQuantity());
        }
        return "\"Trade_" + this.id + "\":{\n" + "\"id\":\"" + this.id + "\",\n" + "\"order_id\":\"" + this.order_id + "\",\n" + "\"exchange\":\"" + this.exchangeName + "\",\n" + "\"pair\":\"" + this.pair.toString() + "\",\n" + "\"type\":\"" + this.type.toUpperCase() + "\",\n" + "\"price\":" + this.price.getQuantity() + ",\n" + "\"amount\":" + this.amount.getQuantity() + ",\n" + "\"fee\":" + feeString + ",\n" + "\"timestamp\":" + this.date.getTime() + "\n" + "}";
    }
}

