/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.models;

import com.nubits.nubot.global.Constant;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.Currency;

public class Balance {
    private Amount PEGTotal;
    private Amount NBTTotal;
    private Amount PEGonOrder;
    private Amount NBTonOrder;
    private Amount PEGAvailable;
    private Amount NBTAvailable;

    public Balance() {
    }

    public Balance(Amount NBTTotal, Amount PEGTotal) {
        this.NBTTotal = NBTTotal;
        this.PEGTotal = PEGTotal;
        this.PEGonOrder = new Amount(0.0, Currency.createCurrency(PEGTotal.getCurrency().getCode()));
        this.NBTonOrder = new Amount(0.0, Constant.NBT);
        this.PEGAvailable = PEGTotal;
        this.NBTAvailable = NBTTotal;
    }

    public Balance(Amount PEGAvail, Amount NBTAvail, Amount PEGonOrder, Amount NBTonOrder) {
        this.PEGAvailable = PEGAvail;
        this.NBTAvailable = NBTAvail;
        this.PEGonOrder = PEGonOrder;
        this.NBTonOrder = NBTonOrder;
        this.PEGTotal = new Amount(this.PEGAvailable.getQuantity() + PEGonOrder.getQuantity(), Currency.createCurrency(PEGonOrder.getCurrency().getCode()));
        this.NBTTotal = new Amount(this.NBTAvailable.getQuantity() + NBTonOrder.getQuantity(), Constant.NBT);
    }

    public Amount getPEGBalance() {
        return this.PEGTotal;
    }

    private void setPegBalance(Amount PEGTotal) {
        this.PEGTotal = PEGTotal;
    }

    public Amount getNubitsBalance() {
        return this.NBTTotal;
    }

    private void setNubitsBalance(Amount NBTTotal) {
        this.NBTTotal = NBTTotal;
    }

    public Amount getPEGBalanceonOrder() {
        return this.PEGonOrder;
    }

    private void setPEGBalanceonOrder(Amount PEGonOrder) {
        this.PEGonOrder = PEGonOrder;
    }

    public Amount getNBTonOrder() {
        return this.NBTonOrder;
    }

    private void setNBTonOrder(Amount NBTonOrder) {
        this.NBTonOrder = NBTonOrder;
    }

    public Amount getPEGAvailableBalance() {
        return this.PEGAvailable;
    }

    private void setPEGAvailableBalance(Amount PEGAvailable) {
        this.PEGAvailable = PEGAvailable;
    }

    public Amount getNBTAvailable() {
        return this.NBTAvailable;
    }

    private void setNBTAvailableBalance(Amount NBTAvailable) {
        this.NBTAvailable = NBTAvailable;
    }

    public String toString() {
        return "Balance{PEGTotal=" + this.PEGTotal + ", PEGonOrder=" + this.PEGonOrder + ", PEGAvailable=" + this.PEGAvailable + ", NBTTotal=" + this.NBTTotal + ", NBTonOrder=" + this.NBTonOrder + ", NBTAvailable=" + this.NBTAvailable + '}';
    }

    public static Balance getSwapedBalance(Balance original) {
        return new Balance(original.NBTAvailable, original.getPEGAvailableBalance(), original.getNBTonOrder(), original.getPEGBalanceonOrder());
    }
}

