/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;

public class SymbolTable {
    public static final int DEFAULT_TABLE_SIZE = 256;
    public static final int MAX_BUCKET_LENTH = 8;
    public static final int MAX_SIZE = 2048;
    private final Entry[] buckets;
    private final String[] symbols;
    private final char[][] symbols_char;
    private final int indexMask;
    private int size = 0;

    public SymbolTable() {
        this(256);
        this.addSymbol("$ref", 0, 4, "$ref".hashCode());
        this.addSymbol(JSON.DEFAULT_TYPE_KEY, 0, 4, JSON.DEFAULT_TYPE_KEY.hashCode());
    }

    public SymbolTable(int tableSize) {
        this.indexMask = tableSize - 1;
        this.buckets = new Entry[tableSize];
        this.symbols = new String[tableSize];
        this.symbols_char = new char[tableSize][];
    }

    public String addSymbol(char[] buffer, int offset, int len) {
        int hash = SymbolTable.hash(buffer, offset, len);
        return this.addSymbol(buffer, offset, len, hash);
    }

    public String addSymbol(char[] buffer, int offset, int len, int hash) {
        Entry entry;
        int bucket = hash & this.indexMask;
        String sym = this.symbols[bucket];
        boolean match = true;
        if (sym != null) {
            if (sym.length() == len) {
                char[] characters = this.symbols_char[bucket];
                for (int i = 0; i < len; ++i) {
                    if (buffer[offset + i] == characters[i]) continue;
                    match = false;
                    break;
                }
                if (match) {
                    return sym;
                }
            } else {
                match = false;
            }
        }
        int entryIndex = 0;
        Entry entry2 = this.buckets[bucket];
        while (entry2 != null) {
            char[] characters = entry2.characters;
            if (len == characters.length && hash == entry2.hashCode) {
                boolean eq = true;
                for (int i = 0; i < len; ++i) {
                    if (buffer[offset + i] == characters[i]) continue;
                    eq = false;
                    break;
                }
                if (!eq) {
                    ++entryIndex;
                } else {
                    return entry2.symbol;
                }
            }
            entry2 = entry2.next;
        }
        if (entryIndex >= 8) {
            return new String(buffer, offset, len);
        }
        if (this.size >= 2048) {
            return new String(buffer, offset, len);
        }
        this.buckets[bucket] = entry = new Entry(buffer, offset, len, hash, this.buckets[bucket]);
        if (match) {
            this.symbols[bucket] = entry.symbol;
            this.symbols_char[bucket] = entry.characters;
        }
        ++this.size;
        return entry.symbol;
    }

    public String addSymbol(String buffer, int offset, int len, int hash) {
        Entry entry;
        int bucket = hash & this.indexMask;
        String sym = this.symbols[bucket];
        boolean match = true;
        if (sym != null) {
            if (sym.length() == len) {
                char[] characters = this.symbols_char[bucket];
                for (int i = 0; i < len; ++i) {
                    if (buffer.charAt(offset + i) == characters[i]) continue;
                    match = false;
                    break;
                }
                if (match) {
                    return sym;
                }
            } else {
                match = false;
            }
        }
        int entryIndex = 0;
        Entry entry2 = this.buckets[bucket];
        while (entry2 != null) {
            char[] characters = entry2.characters;
            if (len == characters.length && hash == entry2.hashCode) {
                boolean eq = true;
                for (int i = 0; i < len; ++i) {
                    if (buffer.charAt(offset + i) == characters[i]) continue;
                    eq = false;
                    break;
                }
                if (!eq) {
                    ++entryIndex;
                } else {
                    return entry2.symbol;
                }
            }
            entry2 = entry2.next;
        }
        if (entryIndex >= 8) {
            return buffer.substring(offset, offset + len);
        }
        if (this.size >= 2048) {
            return buffer.substring(offset, offset + len);
        }
        this.buckets[bucket] = entry = new Entry(buffer, offset, len, hash, this.buckets[bucket]);
        if (match) {
            this.symbols[bucket] = entry.symbol;
            this.symbols_char[bucket] = entry.characters;
        }
        ++this.size;
        return entry.symbol;
    }

    public int size() {
        return this.size;
    }

    public static final int hash(char[] buffer, int offset, int len) {
        int h = 0;
        int off = offset;
        for (int i = 0; i < len; ++i) {
            h = 31 * h + buffer[off++];
        }
        return h;
    }

    protected static final class Entry {
        public final String symbol;
        public final int hashCode;
        public final char[] characters;
        public final byte[] bytes;
        public Entry next;

        public Entry(char[] ch, int offset, int length, int hash, Entry next) {
            this.characters = new char[length];
            System.arraycopy(ch, offset, this.characters, 0, length);
            this.symbol = new String(this.characters).intern();
            this.next = next;
            this.hashCode = hash;
            this.bytes = null;
        }

        public Entry(String text, int offset, int length, int hash, Entry next) {
            this.symbol = text.substring(offset, offset + length).intern();
            this.characters = this.symbol.toCharArray();
            this.next = next;
            this.hashCode = hash;
            this.bytes = null;
        }
    }
}

