/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.utils.logging;

import com.nubits.nubot.utils.logging.LogFormatterCSV;
import com.nubits.nubot.utils.logging.LogFormatterHTML;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NuLogger {
    private static FileHandler fileCsv;
    private static Formatter formatterCsv;
    private static FileHandler fileHTML;
    private static Formatter formatterHTML;

    public static void setup(boolean verbose, String folder) throws IOException {
        Logger logger = Logger.getLogger("");
        if (verbose) {
            logger.setLevel(Level.FINE);
        } else {
            logger.setLevel(Level.INFO);
        }
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(Level.FINE);
        }
        String path = folder + "log";
        fileCsv = new FileHandler(path + ".csv");
        fileHTML = new FileHandler(path + ".html");
        formatterCsv = new LogFormatterCSV();
        fileCsv.setFormatter(formatterCsv);
        logger.addHandler(fileCsv);
        formatterHTML = new LogFormatterHTML();
        fileHTML.setFormatter(formatterHTML);
        logger.addHandler(fileHTML);
    }
}

