/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.utils.logging;

import com.nubits.nubot.utils.Utils;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

class LogFormatterHTML
extends Formatter {
    private static final String PATH_TO_ASSETS = "../../res/logs_assets/";

    LogFormatterHTML() {
    }

    @Override
    public String format(LogRecord rec) {
        if (rec.getLevel().intValue() >= Level.INFO.intValue()) {
            StringBuffer buf = new StringBuffer(1000);
            buf.append("<tr>");
            String CSSclass = " class='info mes'";
            if (rec.getLevel().intValue() == Level.WARNING.intValue()) {
                CSSclass = " class='trades mes'";
            } else if (rec.getLevel().intValue() == Level.SEVERE.intValue()) {
                CSSclass = " class='errors mes'";
            }
            String message = "<td" + CSSclass + "  rel='message'>" + this.formatMessage(rec);
            buf.append(message);
            buf.append("</td>\n");
            buf.append("<td class='clas' rel='class'>");
            buf.append(rec.getLoggerName());
            buf.append("</td>\n");
            buf.append("<td class='met' rel='method'>");
            buf.append(rec.getSourceMethodName());
            buf.append("</td>\n");
            buf.append("<td class='tim' rel='time'>");
            buf.append(Utils.calcDate(rec.getMillis()));
            buf.append("</td>\n");
            buf.append("</tr>\n");
            return buf.toString();
        }
        return "";
    }

    @Override
    public String getHead(Handler h) {
        return "<!DOCTYPE HTML>\n<html>\n<head>\n\t<title>NuBot Logs</title>\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"../../res/logs_assets/css/style.css\">\n\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n</head>\n<body>\n<section class=\"container\">\n\t<section class=\"title\">\n\t\t<h1>NuBot logs " + new Date() + "</h1>\t\n" + "\t</section>\n" + "\n" + "\t<section class=\"filter\">\n" + "\t\t<table>\t\n" + "\t\t\t<thead>\n" + "\t\t\t\t<tr class=\"first\">\n" + "\t\t\t\t\t<th scope=\"col\" class=\"tableHeader\">Filter</th>\n" + "\t\t\t\t</tr>\n" + "\t\t\t</thead>\n" + "\t\t\t\n" + "\t\t\t<tbody>\n" + "\t\t\t\t<tr class=\"first\">\n" + "\t\t\t\t\t<th class=\"filterBox\">\n" + "\t\t\t\t\t\tShow:<br>\n" + "\t\t\t\t\t\t<input class=\"css-checkbox lrg\" rel=\"info\" type=\"checkbox\" value=\"info\" id=\"chkb01\" checked=\"checked\"> \n" + "\t\t\t\t\t\t\t<label for=\"chkb01\" class=\"css-label lrg vlad\">Info</label>\n" + "\t\t\t\t\t\t<br/>\n" + "\t\t\t\t\t\t<input id=\"chkb02\" class=\"css-checkbox lrg\"rel=\"trades\" type=\"checkbox\" value=\"trades\" checked=\"checked\"> \n" + "\t\t\t\t\t\t\t<label for=\"chkb02\" class=\"css-label lrg vlad\">Warnings</label>\n" + "\t\t\t\t\t\t<br/>\n" + "\t\t\t\t\t\t<input id=\"chkb03\" class=\"css-checkbox lrg\"rel=\"errors\" type=\"checkbox\" value=\"errors\" checked=\"checked\"> \n" + "\t\t\t\t\t\t\t<label for=\"chkb03\" class=\"css-label lrg vlad\">Errors</label>\n" + "\t\t\t\t\t\t<br/>\n" + "\t\t\t\t\t</th>\n" + "\t\t\t\t</tr>\n" + "\t\t\t</tbody>\n" + "\t\t</table>\n" + "\t</section>\n" + "\t<table>\n" + "\t\t<!-- Table header -->\n" + "\t\n" + "\t\t<thead>\n" + "\t\t\t<tr class=\"first\">\n" + "\t\t\t\t<th scope=\"col\" class=\"tableHeader mes\">Message</th>\n" + "\t\t\t\t<th scope=\"col\" class=\"tableHeader cla\">Class</th>\n" + "\t\t\t\t<th scope=\"col\" class=\"tableHeader met\">Method</th>\n" + "\t\t\t\t<th scope=\"col\" class=\"tableHeader tim\">Time</th>\n" + "\t\t\t</tr>\n" + "\t\t</thead>\n" + "\t\n" + "\t\t<!-- Table body -->\t\t\n" + "\t\t<tbody>";
    }

    @Override
    public String getTail(Handler h) {
        return "</tbody>\n\t\t\t\n\t</table>\n</section>\n\t\n\t<script src=\"../../res/logs_assets/js/jquery-2.1.1.min.js\"></script>\n\t<script type=\"text/javascript\">\n\t\t$(\"input:checkbox\").click(function () {\n\t\t    $('tr').not('.first').css(\"display\",\"none\"); \n\t\t    $('input[type=checkbox]').each(function () {\n\t\t        if ($(this)[0].checked) {\n\t\t            showAll = false;\n\t\t            var status = $(this).attr('rel');\n\t\t            $('td.' + status).parent('tr').css(\"display\",\"table-row\"); \n\t\t        }\n\t\t    });\n\t\t    if(showAll){\n\t\t        $('tr').css(\"display\",\"table-row\");\n\t\t    }\n\t\t});\n\t</script>\n</body>\n</html>";
    }
}

