/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.utils;

import com.nubits.nubot.NTP.NTPClient;
import com.nubits.nubot.global.Constant;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.launch.NuBot;
import com.nubits.nubot.models.CurrencyPair;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;

public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());

    public static String encodeToFile(String originalString, String passphrase, String pathToOutput) {
        String encodedString = "";
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            digest.update(passphrase.getBytes());
            SecretKeySpec key = new SecretKeySpec(digest.digest(), 0, 16, "AES");
            Cipher aes = Cipher.getInstance("AES/ECB/PKCS5Padding");
            aes.init(1, key);
            byte[] ciphertext = aes.doFinal(originalString.getBytes());
            encodedString = new String(ciphertext);
            FileUtils.writeByteArrayToFile(new File(pathToOutput), ciphertext);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOG.severe(ex.toString());
        }
        return encodedString;
    }

    public static String decode(String pathToFile, String passphrase) {
        String clearString = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            digest.update(passphrase.getBytes());
            SecretKeySpec key = new SecretKeySpec(digest.digest(), 0, 16, "AES");
            Cipher aes = Cipher.getInstance("AES/ECB/PKCS5Padding");
            aes.init(2, key);
            byte[] ciphertextBytes = FileUtils.readFileToByteArray(new File(pathToFile));
            clearString = new String(aes.doFinal(ciphertextBytes));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOG.severe(ex.toString());
            return "-1";
        }
        return clearString;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_DOWN);
        return bd.doubleValue();
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    public static boolean isMacPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Mac");
    }

    public static String toHex(String arg) {
        return String.format("%040x", new BigInteger(1, arg.getBytes()));
    }

    public static String getTimestampString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public static long getTimestampLong() {
        Date timeStamp = new Date();
        return timeStamp.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHTML(String url, boolean removeNonLatinChars) throws IOException {
        String line = "";
        String all = "";
        URL myUrl = null;
        try (BufferedReader br = null;){
            myUrl = new URL(url);
            URLConnection con = myUrl.openConnection();
            con.setConnectTimeout(8000);
            con.setReadTimeout(8000);
            InputStream in = con.getInputStream();
            br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                all = all + line;
            }
        }
        if (removeNonLatinChars) {
            all = all.replaceAll("[^\\x00-\\x7F]", "");
        }
        return all;
    }

    public static void printSeparator() {
        LOG.fine("\n----------- -----------  -----------\n");
    }

    public static boolean isSupported(CurrencyPair pair) {
        return pair.equals(Constant.NBT_USD) || pair.equals(Constant.NBT_BTC) || pair.equals(Constant.BTC_NBT) || pair.equals(Constant.NBT_EUR) || pair.equals(Constant.NBT_CNY) || pair.equals(Constant.NBT_PPC);
    }

    public static boolean requiresSecondaryPegStrategy(CurrencyPair pair) {
        return !pair.equals(Constant.NBT_USD);
    }

    public static double getDouble(Object obj) {
        double toRet = -1.0;
        if (obj.getClass().equals(new Long(10L).getClass())) {
            Long l = new Long((Long)obj);
            toRet = l.doubleValue();
        } else {
            try {
                toRet = (Double)obj;
            }
            catch (ClassCastException e) {
                try {
                    toRet = Double.parseDouble((String)obj);
                }
                catch (ClassCastException ex) {
                    LOG.severe("cannot parse object : " + obj.toString());
                    return -1.0;
                }
            }
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String filename) {
        Global.settings = new Properties();
        InputStream input = null;
        try {
            input = NuBot.class.getClassLoader().getResourceAsStream(filename);
            if (input == null) {
                LOG.severe("Sorry, unable to find " + filename);
                System.exit(0);
            }
            Global.settings.load(input);
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOG.severe(e.toString());
                }
            }
        }
        return null;
    }

    public static long getOneDayInMillis() {
        return 86400000L;
    }

    public static int getSecondsToRemoteMinute() {
        Date remoteDate = new NTPClient().getTime();
        GregorianCalendar remoteCalendar = new GregorianCalendar();
        remoteCalendar.setTime(remoteDate);
        int remoteTimeInSeconds = remoteCalendar.get(13);
        int delay = 60 - remoteTimeInSeconds;
        return delay;
    }

    public static void exitWithMessage(String msg) {
        LOG.severe(msg);
        System.exit(0);
    }

    public static int randInt(int min, int max) {
        Random rand = new Random();
        int randomNum = rand.nextInt(max - min + 1) + min;
        return randomNum;
    }

    public static int getSecondsToNextwindow(int windowWidthSeconds) {
        Date remoteDate = new NTPClient().getTime();
        GregorianCalendar remoteCalendar = new GregorianCalendar();
        remoteCalendar.setTime(remoteDate);
        int remoteTimeInSeconds = remoteCalendar.get(13);
        int remoteTimeInMinutes = remoteCalendar.get(12);
        int minutesTillWindow = windowWidthSeconds - remoteTimeInMinutes % windowWidthSeconds;
        int delay = 60 * minutesTillWindow - remoteTimeInSeconds;
        return delay;
    }

    public static String calcDate(long millisecs) {
        String timezone = "UTC";
        SimpleDateFormat date_format = new SimpleDateFormat("MMM dd yyyy HH:mm:ss.SSS");
        date_format.setTimeZone(TimeZone.getTimeZone("timezone"));
        Date resultdate = new Date(millisecs);
        return date_format.format(resultdate) + " " + timezone;
    }
}

