/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.notifications.HipChatNotifications;
import com.nubits.nubot.notifications.jhipchat.messages.Message;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class FrozenBalancesManager {
    private static final Logger LOG = Logger.getLogger(FrozenBalancesManager.class.getName());
    private String pathToFrozenBalancesFiles;
    private FrozenAmount frozenAmount;
    private ArrayList<HistoryRow> history;
    private Amount amountAlreadyThere;
    private Currency toFreezeCurrency;

    public FrozenBalancesManager(String exchangName, CurrencyPair pair, String folder) {
        String fileName = pair.toString("_") + "-" + exchangName + "-frozen.json";
        this.pathToFrozenBalancesFiles = folder + fileName;
        this.toFreezeCurrency = Global.swappedPair ? pair.getOrderCurrency() : pair.getPaymentCurrency();
        this.amountAlreadyThere = new Amount(0.0, this.toFreezeCurrency);
        this.history = new ArrayList();
        if (new File(this.pathToFrozenBalancesFiles).exists()) {
            this.parseFrozenBalancesFile();
        } else {
            this.frozenAmount = new FrozenAmount(new Amount(0.0, this.toFreezeCurrency));
            this.updateFrozenFilesystem();
        }
    }

    public Amount removeFrozenAmount(Amount amount, FrozenAmount frozen) {
        if (frozen.getAmount().getQuantity() == 0.0) {
            return amount;
        }
        if (frozen.getAmount().getQuantity() < amount.getQuantity()) {
            Currency frozenCurrency;
            Currency currentPegCurrency = amount.getCurrency();
            if (currentPegCurrency.equals(frozenCurrency = frozen.getAmount().getCurrency())) {
                double updatedQuantity = amount.getQuantity() - frozen.getAmount().getQuantity();
                return new Amount(updatedQuantity, currentPegCurrency);
            }
            LOG.severe("Cannot compare the frozen currency (" + frozenCurrency.getCode() + ") with the peg currency  (" + currentPegCurrency + "). " + "Returning original balance without freezing value");
            return amount;
        }
        LOG.severe("The funds to freeze are greater than the amount found in balance. Please stop the bot and analyze the frozen balance log.");
        return amount;
    }

    public void tryKeepProceedsAside(Amount amountFoundInBalance, Amount initialFunds) {
        if (Global.options.getKeepProceeds() > 0.0) {
            if (initialFunds.getQuantity() < amountFoundInBalance.getQuantity()) {
                double percentageToSetApart = Utils.round(Global.options.getKeepProceeds() / 100.0, 4);
                if (percentageToSetApart != 0.0) {
                    double quantityToFreeze = percentageToSetApart * (amountFoundInBalance.getQuantity() - initialFunds.getQuantity());
                    DecimalFormat df = new DecimalFormat("#");
                    df.setMaximumFractionDigits(8);
                    Currency curerncyToFreeze = amountFoundInBalance.getCurrency();
                    Global.frozenBalances.updateFrozenBalance(new Amount(quantityToFreeze, curerncyToFreeze));
                    HipChatNotifications.sendMessage("" + df.format(quantityToFreeze) + " " + curerncyToFreeze.getCode().toUpperCase() + " have been put aside to pay dividends (" + percentageToSetApart * 100.0 + "% of  sale proceedings)" + ". Funds frozen to date = " + df.format(Global.frozenBalances.getFrozenAmount().getAmount().getQuantity()) + " " + curerncyToFreeze.getCode().toUpperCase(), Message.Color.PURPLE);
                }
            } else {
                LOG.info("Nothing to freeze. The funds initially set apart (" + initialFunds.toString() + ") " + "are greater than the amount found in balance(" + amountFoundInBalance.toString() + ").");
            }
        }
    }

    public void freezeNewFunds() {
        if (Global.options.getKeepProceeds() > 0.0) {
            ApiResponse balancesResponse = Global.exchange.getTrade().getAvailableBalance(this.toFreezeCurrency);
            if (balancesResponse.isPositive()) {
                Amount balance = (Amount)balancesResponse.getResponseObject();
                balance = this.removeFrozenAmount(balance, Global.frozenBalances.getFrozenAmount());
                double oneNBT = Utils.round(1.0 / Global.conversion, 8);
                if (balance.getQuantity() > oneNBT) {
                    this.tryKeepProceedsAside(balance, Global.frozenBalances.getAmountAlreadyThere());
                }
                this.setBalanceAlreadyThere(this.toFreezeCurrency);
            } else {
                LOG.severe("Cannot get the updated balance");
            }
        }
    }

    public void setBalanceAlreadyThere(Currency currency) {
        boolean success = true;
        if (Global.options.getKeepProceeds() > 0.0) {
            ApiResponse balancesResponse = Global.exchange.getTrade().getAvailableBalance(currency);
            Amount balance = null;
            if (balancesResponse.isPositive()) {
                balance = (Amount)balancesResponse.getResponseObject();
                if ((balance = this.removeFrozenAmount(balance, Global.frozenBalances.getFrozenAmount())).getQuantity() > this.getAmountAlreadyThere().getQuantity()) {
                    this.setAmountAlreadyThere(balance);
                } else {
                    LOG.fine("Did not update the balanceAlreadyThere, since its would be smaller(" + balance.toString() + ") than the former value(" + this.getAmountAlreadyThere().toString() + ") .");
                }
            } else {
                success = false;
            }
        }
        if (success) {
            LOG.info("Frozen funds already in balance (not proceeds) updated : " + Global.frozenBalances.getAmountAlreadyThere().getQuantity() + " " + Global.frozenBalances.getAmountAlreadyThere().getCurrency());
        } else {
            LOG.severe("An error occurred while trying to set the balance already there (not proceeds)");
        }
    }

    public void setInitialFrozenAmount(Amount newAmount, boolean writeToFile) {
        this.frozenAmount = new FrozenAmount(newAmount);
        DecimalFormat df = new DecimalFormat("#");
        df.setMaximumFractionDigits(8);
        if (Global.options != null && Global.options.getKeepProceeds() != 0.0) {
            LOG.info("Setting initial frozen amount to : " + df.format(this.frozenAmount.getAmount().getQuantity()) + " " + this.toFreezeCurrency.getCode());
        }
        if (writeToFile) {
            this.updateFrozenFilesystem();
        }
    }

    public void updateFrozenBalance(Amount toAdd) {
        double oldQuantity = this.frozenAmount.getAmount().getQuantity();
        double quantityToAdd = toAdd.getQuantity();
        Amount newAmount = new Amount(oldQuantity + quantityToAdd, this.toFreezeCurrency);
        this.frozenAmount = new FrozenAmount(newAmount);
        HistoryRow historyRow = new HistoryRow(new Date(), quantityToAdd, this.toFreezeCurrency.getCode());
        this.history.add(historyRow);
        this.updateFrozenFilesystem();
    }

    public FrozenAmount getFrozenAmount() {
        return this.frozenAmount;
    }

    public void reset() {
        this.frozenAmount = new FrozenAmount(new Amount(0.0, this.toFreezeCurrency));
        this.updateFrozenFilesystem();
    }

    private void parseFrozenBalancesFile() {
        JSONParser parser = new JSONParser();
        String FrozenBalancesManagerString = FileSystem.readFromFile(this.pathToFrozenBalancesFiles);
        try {
            JSONObject frozenBalancesJSON = (JSONObject)parser.parse(FrozenBalancesManagerString);
            double quantity = Double.parseDouble((String)frozenBalancesJSON.get("frozen-quantity-total"));
            Amount frozenAmount = new Amount(quantity, this.toFreezeCurrency);
            this.setInitialFrozenAmount(frozenAmount, false);
            JSONArray historyArr = (JSONArray)frozenBalancesJSON.get("history");
            for (int i = 0; i < historyArr.size(); ++i) {
                JSONObject tempHistoryRow = (JSONObject)historyArr.get(i);
                SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd kk:mm:ss z yyyy", Locale.ENGLISH);
                Date timestamp = df.parse((String)tempHistoryRow.get("timestamp"));
                double frozeQuantity = Double.parseDouble((String)tempHistoryRow.get("froze-quantity"));
                String currencyCode = (String)tempHistoryRow.get("currency-code");
                this.history.add(new HistoryRow(timestamp, frozeQuantity, currencyCode));
            }
        }
        catch (NumberFormatException | java.text.ParseException | ParseException e) {
            LOG.severe("Error while parsing the frozen balances file (" + this.pathToFrozenBalancesFiles + ")\n" + e.toString());
        }
    }

    private void updateFrozenFilesystem() {
        String toWrite = "";
        JSONObject toWriteJ = new JSONObject();
        DecimalFormat df = new DecimalFormat("#");
        df.setMaximumFractionDigits(10);
        toWriteJ.put("frozen-quantity-total", df.format(this.getFrozenAmount().getAmount().getQuantity()));
        toWriteJ.put("frozen-currency", this.getFrozenAmount().getAmount().getCurrency().getCode());
        JSONArray historyListJ = new JSONArray();
        for (int i = 0; i < this.history.size(); ++i) {
            JSONObject tempRow = new JSONObject();
            HistoryRow tempHistory = this.history.get(i);
            if (!(tempHistory.getFreezedQuantity() > 1.0E-8)) continue;
            tempRow.put("timestamp", tempHistory.getTimestamp().toString());
            tempRow.put("froze-quantity", df.format(tempHistory.getFreezedQuantity()));
            tempRow.put("currency-code", tempHistory.getCurrencyCode());
            historyListJ.add(tempRow);
        }
        toWriteJ.put("history", historyListJ);
        toWrite = toWrite + toWriteJ.toString();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(toWrite);
        String toWritePretty = gson.toJson(je);
        try {
            FileUtils.writeStringToFile(new File(this.pathToFrozenBalancesFiles), toWritePretty);
            LOG.info("Updated Froozen Balances file (" + this.pathToFrozenBalancesFiles + ") : " + df.format(this.getFrozenAmount().getAmount().getQuantity()) + " " + this.toFreezeCurrency.getCode());
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
    }

    public Amount getAmountAlreadyThere() {
        return this.amountAlreadyThere;
    }

    public void setAmountAlreadyThere(Amount amountAlreadyThere) {
        this.amountAlreadyThere = new Amount(Utils.round(amountAlreadyThere.getQuantity(), 8), amountAlreadyThere.getCurrency());
    }

    public String getCurrencyCode() {
        return this.toFreezeCurrency.getCode();
    }

    public class HistoryRow {
        private Date timestamp;
        private double frozeQuantity;
        private String currencyCode;

        public HistoryRow(Date timestamp, double frozeQuantity, String currencyCode) {
            this.timestamp = timestamp;
            this.frozeQuantity = frozeQuantity;
            this.currencyCode = currencyCode;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        public double getFreezedQuantity() {
            return this.frozeQuantity;
        }

        public void setFreezedQuantity(double frozeQuantity) {
            this.frozeQuantity = frozeQuantity;
        }

        public String getCurrencyCode() {
            return this.currencyCode;
        }

        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public String toString() {
            return "historyRow{timestamp=" + this.timestamp + ", frozeQuantity=" + this.frozeQuantity + ", currencyCode=" + this.currencyCode + '}';
        }
    }

    public class FrozenAmount {
        private Amount amount;

        public FrozenAmount(Amount amount) {
            this.amount = new Amount(Utils.round(amount.getQuantity(), 8), amount.getCurrency());
        }

        public Amount getAmount() {
            return this.amount;
        }

        public void setAmount(Amount amount) {
            this.amount = new Amount(Utils.round(amount.getQuantity(), 8), amount.getCurrency());
        }

        public String toString() {
            return this.amount.getQuantity() + " " + this.amount.getCurrency().getCode().toUpperCase();
        }
    }
}

