/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.trading.wrappers;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiError;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Balance;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.models.Trade;
import com.nubits.nubot.trading.ServiceInterface;
import com.nubits.nubot.trading.TradeInterface;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.trading.wrappers.BterWrapper;
import com.nubits.nubot.utils.ErrorManager;
import com.nubits.nubot.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.json.JSONException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CcexWrapper
implements TradeInterface {
    private ApiKeys keys;
    private Exchange exchange;
    private String checkConnectionUrl = "https://c-cex.com/";
    private static final Logger LOG = Logger.getLogger(CcexWrapper.class.getName());
    private final String API_BASE = "https://c-cex.com/t/r.html?";
    private String baseUrl;
    private ErrorManager errors = new ErrorManager();
    private final String TOKEN_ERR = "error";
    private final String TOKEN_BAD_RETURN = "No Connection With Exchange";

    public CcexWrapper(ApiKeys keys, Exchange exchange) {
        this.keys = keys;
        this.exchange = exchange;
        this.baseUrl = "https://c-cex.com/t/r.html?key=" + keys.getPrivateKey();
        this.setupErrors();
    }

    public CcexWrapper() {
        this.setupErrors();
    }

    public void initBaseUrl() {
        this.baseUrl = "https://c-cex.com/t/r.html?key=" + this.keys.getPrivateKey();
    }

    private void setupErrors() {
        this.errors.setExchangeName(this.exchange);
    }

    private ApiResponse getQuery(String url, HashMap<String, String> query_args, boolean isGet) {
        ApiResponse apiResponse = new ApiResponse();
        return apiResponse;
    }

    @Override
    public ApiResponse getAvailableBalances(CurrencyPair pair) {
        return this.getBalanceImpl(pair, null);
    }

    @Override
    public ApiResponse getAvailableBalance(Currency currency) {
        return this.getBalanceImpl(null, currency);
    }

    public ApiResponse getBalanceImpl(CurrencyPair pair, Currency currency) {
        ApiResponse apiResponse = new ApiResponse();
        Balance balance = new Balance();
        String url = this.baseUrl + "&a=getbalance";
        String queryResult = this.query(url, new HashMap<String, String>(), true);
        if (queryResult.equals("No Connection With Exchange")) {
            apiResponse.setError(this.errors.nullReturnError);
            return apiResponse;
        }
        if (queryResult.startsWith("Access denied")) {
            apiResponse.setError(this.errors.authenticationError);
            return apiResponse;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject httpAnswerJson = (JSONObject)parser.parse(queryResult);
            JSONArray balanceArray = (JSONArray)httpAnswerJson.get("return");
            if (currency != null) {
                String lookingFor = currency.getCode().toLowerCase();
                boolean found = false;
                for (int i = 0; i < balanceArray.size(); ++i) {
                    JSONObject tempElement = (JSONObject)balanceArray.get(i);
                    if (!tempElement.containsKey(lookingFor)) continue;
                    found = true;
                    double foundBalance = Utils.getDouble(tempElement.get(lookingFor));
                    apiResponse.setResponseObject(new Amount(foundBalance, currency));
                }
                if (!found) {
                    String errorMessage = "Cannot find a balance for currency " + lookingFor;
                    ApiError apiErr = this.errors.genericError;
                    apiErr.setDescription(errorMessage);
                    apiResponse.setError(apiErr);
                    return apiResponse;
                }
            } else {
                boolean foundNBTavail = false;
                boolean foundPEGavail = false;
                Amount NBTAvail = new Amount(0.0, pair.getOrderCurrency());
                Amount PEGAvail = new Amount(0.0, pair.getPaymentCurrency());
                Amount PEGonOrder = new Amount(0.0, pair.getPaymentCurrency());
                Amount NBTonOrder = new Amount(0.0, pair.getOrderCurrency());
                String NBTcode = pair.getOrderCurrency().getCode().toLowerCase();
                String PEGcode = pair.getPaymentCurrency().getCode().toLowerCase();
                for (int i = 0; i < balanceArray.size(); ++i) {
                    double tempLockedebalance;
                    double tempAvailablebalance;
                    JSONObject tempElement = (JSONObject)balanceArray.get(i);
                    if (tempElement.containsKey(NBTcode)) {
                        tempAvailablebalance = Utils.getDouble(tempElement.get(NBTcode));
                        tempLockedebalance = 0.0;
                        NBTAvail = new Amount(tempAvailablebalance, pair.getOrderCurrency());
                        NBTonOrder = new Amount(tempLockedebalance, pair.getOrderCurrency());
                        foundNBTavail = true;
                        continue;
                    }
                    if (!tempElement.containsKey(PEGcode)) continue;
                    tempAvailablebalance = Utils.getDouble(tempElement.get(PEGcode));
                    tempLockedebalance = 0.0;
                    PEGAvail = new Amount(tempAvailablebalance, pair.getPaymentCurrency());
                    PEGonOrder = new Amount(tempLockedebalance, pair.getPaymentCurrency());
                    foundPEGavail = true;
                }
                balance = new Balance(PEGAvail, NBTAvail, PEGonOrder, NBTonOrder);
                apiResponse.setResponseObject(balance);
                if (!foundNBTavail || !foundPEGavail) {
                    LOG.warning("Cannot find a balance for currency with code " + NBTcode + " or " + PEGcode + " in your balance. " + "NuBot assumes that balance is 0");
                }
            }
        }
        catch (ParseException ex) {
            LOG.severe("httpresponse: " + queryResult + " \n" + ex.toString());
            apiResponse.setError(this.errors.parseError);
            return apiResponse;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getLastPrice(CurrencyPair pair) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ApiResponse sell(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("SELL", pair, amount, rate);
    }

    @Override
    public ApiResponse buy(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("BUY", pair, amount, rate);
    }

    private ApiResponse enterOrder(String type, CurrencyPair pair, double amount, double rate) {
        ApiResponse apiResponse = new ApiResponse();
        String order_id = "";
        String typeCode = type.equals("BUY") ? "b" : "s";
        String url = this.baseUrl + "&a=makeorder";
        url = url + "&pair=" + pair.toString("-").toLowerCase();
        url = url + "&q=" + amount;
        url = url + "&t=" + typeCode;
        String queryResult = this.query(url = url + "&r=" + rate, new HashMap<String, String>(), true);
        if (queryResult.equals("No Connection With Exchange")) {
            apiResponse.setError(this.errors.nullReturnError);
            return apiResponse;
        }
        if (queryResult.startsWith("Access denied")) {
            apiResponse.setError(this.errors.authenticationError);
            return apiResponse;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject httpAnswerJson = (JSONObject)parser.parse(queryResult);
            String ret = (String)httpAnswerJson.get("return");
            if (ret.contains("not enough funds") || ret.contains(" ")) {
                ApiError apiErr = this.errors.apiReturnError;
                apiErr.setDescription(ret);
                LOG.severe("CCex API returned an error: " + ret);
                apiResponse.setError(apiErr);
                return apiResponse;
            }
            order_id = ret;
            apiResponse.setResponseObject(order_id);
        }
        catch (ParseException ex) {
            LOG.severe("httpresponse: " + queryResult + " \n" + ex.toString());
            apiResponse.setError(this.errors.parseError);
            return apiResponse;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getActiveOrders() {
        return this.getOrdersImpl(null);
    }

    @Override
    public ApiResponse getActiveOrders(CurrencyPair pair) {
        return this.getOrdersImpl(pair);
    }

    public ApiResponse getOrdersImpl(CurrencyPair pair) {
        String queryResult;
        ApiResponse apiResponse = new ApiResponse();
        ArrayList<Order> orderList = new ArrayList<Order>();
        String url = this.baseUrl + "&a=orderlist&self=1";
        if (pair != null) {
            url = url + "&pair=" + pair.toString("-").toLowerCase();
        }
        if ((queryResult = this.query(url, new HashMap<String, String>(), true)).equals("No Connection With Exchange")) {
            apiResponse.setError(this.errors.nullReturnError);
            return apiResponse;
        }
        if (queryResult.startsWith("Access denied")) {
            apiResponse.setError(this.errors.authenticationError);
            return apiResponse;
        }
        try {
            org.json.JSONObject httpAnswerJson = new org.json.JSONObject(queryResult);
            org.json.JSONObject dataJson = (org.json.JSONObject)httpAnswerJson.get("return");
            if (dataJson.length() == 0) {
                apiResponse.setResponseObject(orderList);
                return apiResponse;
            }
            String[] names = org.json.JSONObject.getNames(dataJson);
            for (int i = 0; i < names.length; ++i) {
                org.json.JSONObject tempJson = dataJson.getJSONObject(names[i]);
                Order tempOrder = this.parseOrder(tempJson);
                tempOrder.setId(names[i]);
                if (tempOrder.isCompleted()) continue;
                if (pair != null) {
                    if (!tempOrder.getPair().equals(pair)) continue;
                    orderList.add(tempOrder);
                    continue;
                }
                orderList.add(tempOrder);
            }
            apiResponse.setResponseObject(orderList);
        }
        catch (JSONException ex) {
            LOG.severe("httpresponse: " + queryResult + " \n" + ex.toString());
            apiResponse.setError(this.errors.parseError);
            return apiResponse;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getOrderDetail(String orderID) {
        ApiResponse apiResp = new ApiResponse();
        Object order = null;
        ApiResponse listApiResp = this.getActiveOrders();
        if (listApiResp.isPositive()) {
            ArrayList orderList = (ArrayList)listApiResp.getResponseObject();
            boolean found = false;
            for (int i = 0; i < orderList.size(); ++i) {
                Order tempOrder = (Order)orderList.get(i);
                if (!orderID.equals(tempOrder.getId())) continue;
                found = true;
                apiResp.setResponseObject(tempOrder);
                return apiResp;
            }
            if (!found) {
                ApiError apiErr = this.errors.apiReturnError;
                apiErr.setDescription("Cannot find the order with id " + orderID);
                apiResp.setError(apiErr);
                return apiResp;
            }
        } else {
            return listApiResp;
        }
        return apiResp;
    }

    @Override
    public ApiResponse cancelOrder(String orderID, CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String order_id = "";
        String url = this.baseUrl + "&a=cancelorder";
        String queryResult = this.query(url = url + "&id=" + orderID, new HashMap<String, String>(), true);
        if (queryResult.equals("No Connection With Exchange")) {
            apiResponse.setError(this.errors.nullReturnError);
            return apiResponse;
        }
        if (queryResult.startsWith("Access denied")) {
            apiResponse.setError(this.errors.authenticationError);
            return apiResponse;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject httpAnswerJson = (JSONObject)parser.parse(queryResult);
            if (httpAnswerJson.containsKey("error")) {
                ApiError apiErr = this.errors.apiReturnError;
                apiErr.setDescription((String)httpAnswerJson.get("error"));
                apiResponse.setError(apiErr);
                return apiResponse;
            }
            apiResponse.setResponseObject(true);
        }
        catch (ParseException ex) {
            LOG.severe("httpresponse: " + queryResult + " \n" + ex.toString());
            apiResponse.setError(this.errors.parseError);
            return apiResponse;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getTxFee() {
        double defaultFee = 0.2;
        if (Global.options != null) {
            return new ApiResponse(true, Global.options.getTxFee(), null);
        }
        return new ApiResponse(true, defaultFee, null);
    }

    @Override
    public ApiResponse getTxFee(CurrencyPair pair) {
        LOG.fine("CCex uses global TX fee, currency pair not supprted. \nnow calling getTxFee()");
        return this.getTxFee();
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair) {
        long now = System.currentTimeMillis();
        long yesterday = now - Utils.getOneDayInMillis();
        return this.getTradesImpl(pair, yesterday);
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair, long startTime) {
        return this.getTradesImpl(pair, startTime);
    }

    private ApiResponse getTradesImpl(CurrencyPair pair, long startTime) {
        ApiResponse apiResponse = new ApiResponse();
        ArrayList<Trade> tradeList = new ArrayList<Trade>();
        Date date = new Date(startTime);
        GregorianCalendar myCal = new GregorianCalendar();
        myCal.setTime(date);
        String formattedStartDate = Integer.toString(myCal.get(1)) + "-" + (myCal.get(2) + 1) + "-" + myCal.get(5);
        myCal.setTime(new Date());
        String formattedStopDate = Integer.toString(myCal.get(1)) + "-" + (myCal.get(2) + 1) + "-" + myCal.get(5);
        String url = this.baseUrl + "&a=tradehistory";
        url = url + "&d1=" + formattedStartDate;
        url = url + "&d2=" + formattedStopDate;
        url = url + "&pair=" + pair.toString("-").toLowerCase();
        String queryResult = this.query(url, new HashMap<String, String>(), true);
        if (queryResult.equals("No Connection With Exchange")) {
            apiResponse.setError(this.errors.nullReturnError);
            return apiResponse;
        }
        if (queryResult.startsWith("Access denied")) {
            apiResponse.setError(this.errors.authenticationError);
            return apiResponse;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONArray array;
            JSONObject httpAnswerJson = (JSONObject)parser.parse(queryResult);
            try {
                array = (JSONArray)httpAnswerJson.get("return");
            }
            catch (Exception e) {
                apiResponse.setResponseObject(tradeList);
                return apiResponse;
            }
            for (int i = 0; i < array.size(); ++i) {
                tradeList.add(this.parseTrade((JSONObject)array.get(i), pair));
            }
            apiResponse.setResponseObject(tradeList);
        }
        catch (ParseException ex) {
            LOG.severe("httpresponse: " + queryResult + " \n" + ex.toString());
            apiResponse.setError(this.errors.parseError);
            return apiResponse;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse isOrderActive(String id) {
        ApiResponse existResponse = new ApiResponse();
        ApiResponse orderDetailResponse = this.getOrderDetail(id);
        if (orderDetailResponse.isPositive()) {
            Order order = (Order)orderDetailResponse.getResponseObject();
            existResponse.setResponseObject(true);
        } else {
            ApiError err = orderDetailResponse.getError();
            if (err.getDescription().contains("Cannot find the order")) {
                existResponse.setResponseObject(false);
            } else {
                existResponse.setError(err);
            }
        }
        return existResponse;
    }

    @Override
    public ApiResponse clearOrders(CurrencyPair pair) {
        ApiResponse toReturn = new ApiResponse();
        boolean ok = true;
        ApiResponse activeOrdersResponse = this.getActiveOrders();
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            for (int i = 0; i < orderList.size(); ++i) {
                Order tempOrder = (Order)orderList.get(i);
                ApiResponse deleteOrderResponse = this.cancelOrder(tempOrder.getId(), pair);
                if (deleteOrderResponse.isPositive()) {
                    boolean deleted = (Boolean)deleteOrderResponse.getResponseObject();
                    if (deleted) {
                        LOG.warning("Order " + tempOrder.getId() + " deleted succesfully");
                    } else {
                        LOG.warning("Could not delete order " + tempOrder.getId() + "");
                        ok = false;
                    }
                } else {
                    LOG.severe(deleteOrderResponse.getError().toString());
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.severe(ex.toString());
                }
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
            toReturn.setError(activeOrdersResponse.getError());
            return toReturn;
        }
        toReturn.setResponseObject(ok);
        return toReturn;
    }

    @Override
    public ApiError getErrorByCode(int code) {
        return null;
    }

    @Override
    public String getUrlConnectionCheck() {
        return this.checkConnectionUrl;
    }

    @Override
    public String query(String url, HashMap<String, String> args, boolean isGet) {
        String queryResult;
        CcexService query = new CcexService(url);
        if (this.exchange.getLiveData().isConnected()) {
            queryResult = query.executeQuery(true, isGet);
        } else {
            LOG.severe("The bot will not execute the query, there is no connection to CCex");
            queryResult = "No Connection With Exchange";
        }
        return queryResult;
    }

    @Override
    public String query(String base, String method, HashMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String query(String url, TreeMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String query(String base, String method, TreeMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setKeys(ApiKeys keys) {
        this.keys = keys;
    }

    @Override
    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void setApiBaseUrl(String apiBaseUrl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Order parseOrder(org.json.JSONObject orderObject) {
        Order order = new Order();
        try {
            String c1 = orderObject.getString("c1");
            String c2 = orderObject.getString("c2");
            CurrencyPair cp = new CurrencyPair(Currency.createCurrency(c1), Currency.createCurrency(c2));
            order.setPair(cp);
            order.setType(orderObject.getString("type").toUpperCase());
            order.setAmount(new Amount(orderObject.getDouble("amount"), cp.getOrderCurrency()));
            order.setPrice(new Amount(orderObject.getDouble("price"), cp.getPaymentCurrency()));
            order.setCompleted(false);
            order.setInsertedDate(new Date());
        }
        catch (JSONException ex) {
            LOG.severe(ex.toString());
        }
        return order;
    }

    private Trade parseTrade(JSONObject tradeObj, CurrencyPair pair) {
        Trade trade = new Trade();
        trade.setOrder_id((String)tradeObj.get("id"));
        trade.setExchangeName("ccex");
        trade.setPair(pair);
        trade.setType(((String)tradeObj.get("type")).toUpperCase());
        trade.setAmount(new Amount(Utils.getDouble(tradeObj.get("amount")), pair.getPaymentCurrency()));
        trade.setPrice(new Amount(Utils.getDouble(tradeObj.get("rate")), pair.getOrderCurrency()));
        trade.setFee(new Amount(0.0, pair.getPaymentCurrency()));
        trade.setDate(this.parseDate((String)tradeObj.get("dt")));
        return trade;
    }

    private Date parseDate(String dateStr) {
        Date toRet = null;
        String datePattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat df = new SimpleDateFormat(datePattern, Locale.ENGLISH);
        try {
            toRet = df.parse(dateStr);
        }
        catch (java.text.ParseException ex) {
            LOG.severe(ex.toString());
            toRet = new Date();
        }
        return toRet;
    }

    private class CcexService
    implements ServiceInterface {
        protected ApiKeys keys;
        protected String url;

        private CcexService(String url) {
            this.url = url;
        }

        @Override
        public String executeQuery(boolean needAuth, boolean isGet) {
            String answer = "";
            Header[] headers = new Header[]{new BasicHeader("Content-type", "application/x-www-form-urlencoded")};
            try {
                URL queryUrl = new URL(this.url);
            }
            catch (MalformedURLException ex) {
                LOG.severe(ex.toString());
            }
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpEntityEnclosingRequestBase post = null;
            HttpGet get = null;
            HttpResponse response = null;
            try {
                get = new HttpGet(this.url);
                get.setHeaders(headers);
                response = client.execute(get);
            }
            catch (Exception e) {
                LOG.severe(e.toString());
                return null;
            }
            try {
                BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuffer buffer = new StringBuffer();
                String line = "";
                while ((line = rd.readLine()) != null) {
                    buffer.append(line);
                }
                answer = buffer.toString();
            }
            catch (IOException ex) {
                Logger.getLogger(BterWrapper.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            catch (IllegalStateException ex) {
                Logger.getLogger(BterWrapper.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            if (Global.options != null && Global.options.isVerbose()) {
                LOG.fine("\nSending request to URL : " + this.url + " ; get = " + isGet);
                if (post != null) {
                    System.out.println("Post parameters : " + post.getEntity());
                }
                LOG.fine("Response Code : " + response.getStatusLine().getStatusCode());
                LOG.fine("Response :" + response);
            }
            return answer;
        }

        @Override
        public String signRequest(String secret, String hash_data) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

