/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.trading.wrappers;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiError;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Balance;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.models.Trade;
import com.nubits.nubot.trading.ServiceInterface;
import com.nubits.nubot.trading.Ticker;
import com.nubits.nubot.trading.TradeInterface;
import com.nubits.nubot.trading.TradeUtils;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.utils.ErrorManager;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Hex;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BitcoinCoIDWrapper
implements TradeInterface {
    private static final Logger LOG = Logger.getLogger(BitcoinCoIDWrapper.class.getName());
    private ApiKeys keys;
    private Exchange exchange;
    private final String SIGN_HASH_FUNCTION = "HmacSHA512";
    private final String ENCODING = "UTF-8";
    private final String API_BASE_URL = "https://vip.bitcoin.co.id/tapi";
    private final String API_TICKER_URL = "https://vip.bitcoin.co.id/api/";
    private final String API_TICKER = "ticker";
    private final String API_GET_INFO = "getInfo";
    private final String API_TRADE = "trade";
    private final String API_OPEN_ORDERS = "openOrders";
    private final String API_CANCEL_ORDER = "cancelOrder";
    private final String API_TRADE_HISTORY = "tradeHistory";
    private ErrorManager errors = new ErrorManager();
    private final String TOKEN_ERR = "error";
    private final String TOKEN_BAD_RETURN = "No Connection With Exchange";
    private final String TOKEN_CODE = "success";

    public BitcoinCoIDWrapper() {
        this.setupErrors();
    }

    public BitcoinCoIDWrapper(ApiKeys keys, Exchange exchange) {
        this.keys = keys;
        this.exchange = exchange;
        this.setupErrors();
    }

    private void setupErrors() {
        this.errors.setExchangeName(this.exchange);
    }

    private ApiResponse getQuery(String url, String method, HashMap<String, String> query_args, boolean isGet) {
        ApiResponse apiResponse = new ApiResponse();
        String queryResult = this.query(url, method, query_args, isGet);
        if (queryResult == null) {
            apiResponse.setError(this.errors.nullReturnError);
            return apiResponse;
        }
        if (queryResult.equals("No Connection With Exchange")) {
            apiResponse.setError(this.errors.noConnectionError);
            return apiResponse;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject httpAnswerJson = (JSONObject)parser.parse(queryResult);
            int code = 0;
            try {
                code = Integer.parseInt(httpAnswerJson.get("success").toString());
            }
            catch (ClassCastException cce) {
                apiResponse.setError(this.errors.genericError);
            }
            if (code == 0) {
                String errorMessage = (String)httpAnswerJson.get("error");
                ApiError apiError = this.errors.apiReturnError;
                apiError.setDescription(errorMessage);
                apiResponse.setError(apiError);
            } else {
                apiResponse.setResponseObject(httpAnswerJson);
            }
        }
        catch (ClassCastException cce) {
            try {
                JSONArray httpAnswerJson = (JSONArray)parser.parse(queryResult);
                apiResponse.setResponseObject(httpAnswerJson);
            }
            catch (ParseException pe) {
                LOG.severe("httpResponse: " + queryResult + " \n" + pe.toString());
                apiResponse.setError(this.errors.parseError);
            }
        }
        catch (ParseException pe) {
            LOG.severe("httpResponse: " + queryResult + " \n" + pe.toString());
            apiResponse.setError(this.errors.parseError);
            return apiResponse;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getAvailableBalances(CurrencyPair pair) {
        return this.getBalanceImpl(null, pair);
    }

    @Override
    public ApiResponse getAvailableBalance(Currency currency) {
        return this.getBalanceImpl(currency, null);
    }

    private ApiResponse getBalanceImpl(Currency currency, CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://vip.bitcoin.co.id/tapi";
        String method = "getInfo";
        HashMap<String, String> query_args = new HashMap<String, String>();
        boolean isGet = false;
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject data = (JSONObject)httpAnswerJson.get("return");
            JSONObject balances = (JSONObject)data.get("balance");
            if (currency == null) {
                double pegAvail = Double.parseDouble(balances.get(pair.getPaymentCurrency().getCode().toLowerCase()).toString());
                Amount PEGAvail = new Amount(pegAvail, pair.getPaymentCurrency());
                double nbtAvail = Double.parseDouble(balances.get(pair.getOrderCurrency().getCode().toLowerCase()).toString());
                Amount NBTAvail = new Amount(nbtAvail, pair.getOrderCurrency());
                double pegOnOrder = 0.0;
                double nbtOnOrder = 0.0;
                ArrayList orders = (ArrayList)this.getActiveOrders(pair).getResponseObject();
                for (Order thisOrder : orders) {
                    if (thisOrder.getType().equals("SELL")) {
                        nbtOnOrder += thisOrder.getAmount().getQuantity();
                        continue;
                    }
                    pegOnOrder += thisOrder.getAmount().getQuantity();
                }
                Amount PEGonOrder = new Amount(pegOnOrder, pair.getPaymentCurrency());
                Amount NBTonOrder = new Amount(nbtOnOrder, pair.getOrderCurrency());
                Balance balance = new Balance(PEGAvail, NBTAvail, PEGonOrder, NBTonOrder);
                apiResponse.setResponseObject(balance);
            } else {
                double balance = Double.parseDouble(balances.get(currency.getCode().toLowerCase()).toString());
                Amount total = new Amount(balance, currency);
                apiResponse.setResponseObject(total);
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getLastPrice(CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://vip.bitcoin.co.id/api/" + pair.toString("_") + "/" + "ticker";
        HashMap<String, String> query_args = new HashMap<String, String>();
        boolean isGet = true;
        double last = -1.0;
        double ask = -1.0;
        double bid = -1.0;
        Ticker ticker = new Ticker();
        String queryResult = this.query(url, query_args, isGet);
        JSONParser parser = new JSONParser();
        JSONObject httpAnswerJson = null;
        try {
            httpAnswerJson = (JSONObject)parser.parse(queryResult);
        }
        catch (ParseException pe) {
            LOG.severe(pe.toString());
            ApiError error = this.errors.apiReturnError;
            error.setDescription("Error parsing ticker response");
            apiResponse.setError(error);
            return apiResponse;
        }
        JSONObject tick = (JSONObject)httpAnswerJson.get("ticker");
        last = Double.parseDouble(tick.get("last").toString());
        ask = Double.parseDouble(tick.get("sell").toString());
        bid = Double.parseDouble(tick.get("buy").toString());
        ticker.setLast(last);
        ticker.setAsk(ask);
        ticker.setBid(bid);
        apiResponse.setResponseObject(ticker);
        return apiResponse;
    }

    @Override
    public ApiResponse sell(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("SELL", pair, amount, rate);
    }

    @Override
    public ApiResponse buy(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("BUY", pair, amount, rate);
    }

    private ApiResponse enterOrder(String type, CurrencyPair pair, double amount, double price) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://vip.bitcoin.co.id/tapi";
        String method = "trade";
        HashMap<String, String> args = new HashMap<String, String>();
        boolean isGet = false;
        String order_id = null;
        args.put("pair", pair.toString("_"));
        args.put("type", type.toLowerCase());
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(8);
        args.put("price", nf.format(price));
        if (type.equals("SELL")) {
            args.put(pair.getPaymentCurrency().getCode().toLowerCase(), nf.format(amount * price));
            args.put(pair.getOrderCurrency().getCode().toLowerCase(), nf.format(amount));
        } else {
            args.put(pair.getPaymentCurrency().getCode().toLowerCase(), nf.format(amount * price));
        }
        ApiResponse response = this.getQuery(url, method, args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject data = (JSONObject)httpAnswerJson.get("return");
            order_id = data.get("order_id").toString();
            apiResponse.setResponseObject(order_id);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getActiveOrders() {
        return this.getActiveOrdersImpl(null);
    }

    @Override
    public ApiResponse getActiveOrders(CurrencyPair pair) {
        return this.getActiveOrdersImpl(pair);
    }

    private ApiResponse getActiveOrdersImpl(CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://vip.bitcoin.co.id/tapi";
        String method = "openOrders";
        ArrayList<Order> orderList = new ArrayList<Order>();
        HashMap<String, String> query_args = new HashMap<String, String>();
        boolean isGet = false;
        if (pair != null) {
            query_args.put("pair", pair.toString("_"));
        } else {
            pair = Global.options.getPair();
            query_args.put("pair", pair.toString("_"));
        }
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject data = (JSONObject)httpAnswerJson.get("return");
            JSONArray orders = (JSONArray)data.get("orders");
            if (orders != null) {
                for (JSONObject thisOrder : orders) {
                    orderList.add(this.parseOrder(thisOrder, pair));
                }
            }
            apiResponse.setResponseObject(orderList);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    private Order parseOrder(JSONObject in, CurrencyPair cp) {
        Amount amount;
        String cur;
        Order out = new Order();
        out.setId(in.get("order_id").toString());
        Date insertedDate = new Date(Long.parseLong(in.get("submit_time").toString()) * 1000L);
        out.setInsertedDate(insertedDate);
        out.setType(in.get("type").toString().equals("buy") ? "BUY" : "SELL");
        Amount price = new Amount(Double.parseDouble(in.get("price").toString()), Global.options.getPair().getPaymentCurrency());
        if (out.getType().equals("BUY")) {
            cur = Global.options.getPair().getPaymentCurrency().getCode().toLowerCase();
            amount = new Amount(Double.parseDouble(in.get("order_" + cur).toString()) / price.getQuantity(), Global.options.getPair().getOrderCurrency());
        } else {
            cur = Global.options.getPair().getOrderCurrency().getCode().toLowerCase();
            amount = new Amount(Double.parseDouble(in.get("order_" + cur).toString()), Global.options.getPair().getOrderCurrency());
        }
        out.setPair(cp);
        out.setAmount(amount);
        out.setPrice(price);
        out.setCompleted(amount.getQuantity() == Double.parseDouble(in.get("remain_" + cur).toString()));
        return out;
    }

    @Override
    public ApiResponse getOrderDetail(String orderID) {
        ApiResponse apiResponse = new ApiResponse();
        ArrayList activeOrders = (ArrayList)this.getActiveOrders().getResponseObject();
        boolean found = false;
        for (Order thisOrder : activeOrders) {
            if (!thisOrder.getId().equals(orderID)) continue;
            found = true;
            apiResponse.setResponseObject(thisOrder);
            break;
        }
        if (!found) {
            ApiError err = this.errors.apiReturnError;
            err.setDescription("Order " + orderID + " does not exists");
            apiResponse.setError(err);
        }
        return apiResponse;
    }

    @Override
    public ApiResponse cancelOrder(String orderID, CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://vip.bitcoin.co.id/tapi";
        String method = "cancelOrder";
        boolean isGet = false;
        HashMap<String, String> query_args = new HashMap<String, String>();
        query_args.put("pair", pair.toString("_"));
        query_args.put("order_id", orderID);
        Order currentOrder = (Order)this.getOrderDetail(orderID).getResponseObject();
        query_args.put("type", currentOrder.getType().toLowerCase());
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject data = (JSONObject)httpAnswerJson.get("return");
            if (data.get("order_id").toString().equals(orderID)) {
                apiResponse.setResponseObject(true);
            } else {
                apiResponse.setResponseObject(false);
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getTxFee() {
        double defaultFee = 0.0;
        return new ApiResponse(true, defaultFee, null);
    }

    @Override
    public ApiResponse getTxFee(CurrencyPair pair) {
        double defaultFee = 0.0;
        return new ApiResponse(true, defaultFee, null);
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair) {
        return this.getLastTradesImpl(pair, 0L);
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair, long startTime) {
        return this.getLastTradesImpl(pair, startTime);
    }

    private ApiResponse getLastTradesImpl(CurrencyPair pair, long startTime) {
        ApiResponse response;
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://vip.bitcoin.co.id/tapi";
        String method = "tradeHistory";
        boolean isGet = false;
        HashMap<String, String> query_args = new HashMap<String, String>();
        ArrayList<Trade> tradeList = new ArrayList<Trade>();
        query_args.put("pair", pair.toString("_"));
        if (startTime > 0L) {
            query_args.put("since", Objects.toString(startTime));
        }
        if ((response = this.getQuery(url, method, query_args, isGet)).isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject data = (JSONObject)httpAnswerJson.get("return");
            JSONArray trades = (JSONArray)data.get("trades");
            for (JSONObject thisTrade : trades) {
                tradeList.add(this.parseTrade(thisTrade, pair));
            }
            apiResponse.setResponseObject(tradeList);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    private Trade parseTrade(JSONObject in, CurrencyPair pair) {
        Trade out = new Trade();
        out.setId(in.get("trade_id").toString());
        out.setType(in.get("type").toString().equals("buy") ? "BUY" : "SELL");
        Date tradeDate = new Date(Long.parseLong(in.get("trade_time").toString()) * 1000L);
        out.setDate(tradeDate);
        out.setExchangeName(Global.exchange.getName());
        Amount fee = new Amount(Double.parseDouble(in.get("fee").toString()), pair.getPaymentCurrency());
        out.setFee(fee);
        Amount amount = new Amount(Double.parseDouble(in.get(pair.getOrderCurrency().getCode().toLowerCase()).toString()), pair.getOrderCurrency());
        out.setAmount(amount);
        Amount price = new Amount(Double.parseDouble(in.get("price").toString()), pair.getPaymentCurrency());
        out.setPrice(price);
        out.setPair(pair);
        return out;
    }

    @Override
    public ApiResponse isOrderActive(String id) {
        ApiResponse apiResponse = new ApiResponse();
        apiResponse = this.getOrderDetail(id);
        if (apiResponse.isPositive()) {
            Order order = (Order)apiResponse.getResponseObject();
            if (order.isCompleted()) {
                apiResponse.setResponseObject(true);
            } else {
                apiResponse.setResponseObject(false);
            }
        } else {
            apiResponse.setResponseObject(false);
        }
        return apiResponse;
    }

    @Override
    public ApiResponse clearOrders(CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setResponseObject(true);
        ApiResponse getOrders = this.getActiveOrders();
        if (getOrders.isPositive()) {
            ArrayList orders = (ArrayList)getOrders.getResponseObject();
            Iterator order = orders.iterator();
            while (order.hasNext()) {
                if (((Boolean)this.cancelOrder(((Order)order.next()).getId(), pair).getResponseObject()).booleanValue()) continue;
                apiResponse.setResponseObject(false);
            }
        } else {
            apiResponse = getOrders;
        }
        return apiResponse;
    }

    @Override
    public ApiError getErrorByCode(int code) {
        return null;
    }

    @Override
    public String getUrlConnectionCheck() {
        return "https://vip.bitcoin.co.id/tapi";
    }

    @Override
    public String query(String url, HashMap<String, String> args, boolean isGet) {
        String queryResult;
        BitcoinCoIdService query = new BitcoinCoIdService(url, args);
        if (this.exchange.getLiveData().isConnected()) {
            queryResult = query.executeQuery(false, isGet);
        } else {
            LOG.severe("The bot will not execute the query, there is no connection to BitcoinCoId");
            queryResult = "No Connection With Exchange";
        }
        return queryResult;
    }

    @Override
    public String query(String base, String method, HashMap<String, String> args, boolean isGet) {
        String queryResult;
        BitcoinCoIdService query = new BitcoinCoIdService(base, method, args, this.keys);
        if (this.exchange.getLiveData().isConnected()) {
            queryResult = query.executeQuery(true, isGet);
        } else {
            LOG.severe("The bot will not execute the query, there is no connection to BitcoinCoId");
            queryResult = "No Connection With Exchange";
        }
        return queryResult;
    }

    @Override
    public String query(String url, TreeMap<String, String> args, boolean isGet) {
        return null;
    }

    @Override
    public String query(String base, String method, TreeMap<String, String> args, boolean isGet) {
        return null;
    }

    @Override
    public void setKeys(ApiKeys keys) {
        this.keys = keys;
    }

    @Override
    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void setApiBaseUrl(String apiBaseUrl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class BitcoinCoIdService
    implements ServiceInterface {
        protected String url;
        protected HashMap args;
        protected ApiKeys keys;
        protected String method;

        public BitcoinCoIdService(String url, String method, HashMap<String, String> args, ApiKeys keys) {
            this.url = url;
            this.args = args;
            this.keys = keys;
            this.method = method;
        }

        private BitcoinCoIdService(String url, HashMap<String, String> args) {
            this.url = url;
            this.args = args;
        }

        @Override
        public String executeQuery(boolean needAuth, boolean isGet) {
            HttpsURLConnection connection = null;
            URL queryUrl = null;
            String post_data = "";
            boolean httpError = false;
            int response = 200;
            String answer = null;
            try {
                queryUrl = new URL(this.url);
            }
            catch (MalformedURLException mal) {
                LOG.severe(mal.toString());
                return null;
            }
            if (needAuth) {
                this.args.put("nonce", Objects.toString(System.currentTimeMillis()));
                this.args.put("method", this.method);
                post_data = TradeUtils.buildQueryString(this.args, "UTF-8");
            }
            try {
                connection = (HttpsURLConnection)queryUrl.openConnection();
                connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("User-Agent", Global.settings.getProperty("app_name"));
                if (needAuth) {
                    connection.setRequestProperty("Key", this.keys.getApiKey());
                    connection.setRequestProperty("Sign", this.signRequest(this.keys.getPrivateKey(), post_data));
                }
                connection.setDoOutput(true);
                connection.setDoInput(true);
                if (isGet) {
                    connection.setRequestMethod("GET");
                } else {
                    connection.setRequestMethod("POST");
                    DataOutputStream os = new DataOutputStream(connection.getOutputStream());
                    os.writeBytes(post_data);
                    os.flush();
                    os.close();
                }
            }
            catch (ProtocolException pe) {
                LOG.severe(pe.toString());
                return null;
            }
            catch (IOException io) {
                LOG.severe(io.toString());
                return null;
            }
            BufferedReader br = null;
            try {
                if (connection.getResponseCode() >= 400) {
                    httpError = true;
                    response = connection.getResponseCode();
                    br = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                } else {
                    answer = "";
                    br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                }
            }
            catch (IOException io) {
                LOG.severe(io.toString());
                return null;
            }
            if (httpError) {
                LOG.severe("Query to : " + this.url + " (method = " + this.method + " )" + "\nData : \" + post_data" + "\nHTTP Response : " + Objects.toString(response));
            }
            try {
                String output;
                while ((output = br.readLine()) != null) {
                    answer = answer + output;
                }
            }
            catch (IOException io) {
                LOG.severe(io.toString());
                return null;
            }
            connection.disconnect();
            connection = null;
            return answer;
        }

        @Override
        public String signRequest(String secret, String hash_data) {
            String sign = "";
            try {
                SecretKeySpec key = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA512");
                Mac mac = Mac.getInstance("HmacSHA512");
                mac.init(key);
                sign = Hex.encodeHexString(mac.doFinal(hash_data.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException uee) {
                LOG.severe("Unsupported encoding exception: " + uee.toString());
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.severe("No such algorithm exception: " + nsae.toString());
            }
            catch (InvalidKeyException ike) {
                LOG.severe("Invalid key exception: " + ike.toString());
            }
            return sign;
        }
    }
}

