/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.trading.wrappers;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiError;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Balance;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.models.Trade;
import com.nubits.nubot.trading.ServiceInterface;
import com.nubits.nubot.trading.TradeInterface;
import com.nubits.nubot.trading.TradeUtils;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.utils.ErrorManager;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AllCoinWrapper
implements TradeInterface {
    private static final Logger LOG = Logger.getLogger(AllCoinWrapper.class.getName());
    private ApiKeys keys;
    private Exchange exchange;
    private final int TIME_OUT = 15000;
    private String checkConnectionUrl = "https://www.allcoin.com/";
    private final String SIGN_HASH_FUNCTION = "MD5";
    private final String ENCODING = "UTF-8";
    private final String API_BASE_URL = "https://www.allcoin.com/api2/";
    private final String API_AUTH_URL = "https://www.allcoin.com/api2/auth_api/";
    private final String API_GET_INFO = "getinfo";
    private final String API_SELL_COIN = "sell_coin";
    private final String API_BUY_COIN = "buy_coin";
    private final String API_OPEN_ORDERS = "myorders";
    private final String API_CANCEL_ORDERS = "cancel_order";
    private final String API_TRADES = "mytrades";
    private final String TOKEN_BAD_RETURN = "No Connection With Exchange";
    private final String TOKEN_ERR = "error_info";
    private final String TOKEN_CODE = "code";
    private final String TOKEN_DATA = "data";
    private final String TOKEN_BAL_AVAIL = "balances_available";
    private final String TOKEN_BAL_HOLD = "balance_hold";
    private final String TOKEN_ORDER_ID = "order_id";
    ErrorManager errors = new ErrorManager();

    public AllCoinWrapper() {
        this.setupErrors();
    }

    public AllCoinWrapper(ApiKeys keys, Exchange exchange) {
        this.keys = keys;
        this.exchange = exchange;
        this.setupErrors();
    }

    private void setupErrors() {
        this.errors.setExchangeName(this.exchange);
    }

    private ApiResponse getQuery(String url, String method, TreeMap<String, String> query_args, boolean isGet) {
        ApiResponse apiResponse = new ApiResponse();
        String queryResult = this.query(url, method, query_args, isGet);
        if (queryResult == null) {
            apiResponse.setError(this.errors.nullReturnError);
            return apiResponse;
        }
        if (queryResult.equals("No Connection With Exchange")) {
            apiResponse.setError(this.errors.noConnectionError);
            return apiResponse;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject httpAnswerJson = (JSONObject)parser.parse(queryResult);
            int code = 0;
            try {
                code = Integer.parseInt(httpAnswerJson.get("code").toString());
            }
            catch (ClassCastException cce) {
                apiResponse.setError(this.errors.genericError);
            }
            if (code < 0) {
                String errorMessage = (String)httpAnswerJson.get("error_info");
                ApiError apiError = this.errors.apiReturnError;
                apiError.setDescription(errorMessage);
                apiResponse.setError(apiError);
            } else {
                apiResponse.setResponseObject(httpAnswerJson);
            }
        }
        catch (ClassCastException cce) {
            try {
                JSONArray httpAnswerJson = (JSONArray)parser.parse(queryResult);
                apiResponse.setResponseObject(httpAnswerJson);
            }
            catch (ParseException pe) {
                LOG.severe("httpResponse: " + queryResult + " \n" + pe.toString());
                apiResponse.setError(this.errors.parseError);
            }
        }
        catch (ParseException pe) {
            LOG.severe("httpResponse: " + queryResult + " \n" + pe.toString());
            apiResponse.setError(this.errors.parseError);
            return apiResponse;
        }
        return apiResponse;
    }

    @Override
    public ApiError getErrorByCode(int code) {
        return null;
    }

    @Override
    public ApiResponse sell(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("SELL", pair, amount, rate);
    }

    @Override
    public ApiResponse buy(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("BUY", pair, amount, rate);
    }

    private ApiResponse enterOrder(String type, CurrencyPair pair, double amount, double price) {
        ApiResponse apiResponse = new ApiResponse();
        boolean isGet = false;
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        query_args.put("num", String.valueOf(amount));
        query_args.put("price", String.valueOf(price));
        query_args.put("exchange", pair.getPaymentCurrency().getCode().toUpperCase());
        query_args.put("type", pair.getOrderCurrency().getCode().toUpperCase());
        String url = "https://www.allcoin.com/api2/auth_api/";
        String method = type == "BUY" ? "buy_coin" : "sell_coin";
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("data");
            if (dataJson.containsKey("order_id")) {
                String order_id = dataJson.get("order_id").toString();
                apiResponse.setResponseObject(order_id);
            } else {
                apiResponse.setError(this.errors.genericError);
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getAvailableBalances(CurrencyPair pair) {
        return this.getBalanceImpl(null, pair);
    }

    @Override
    public ApiResponse getAvailableBalance(Currency currency) {
        return this.getBalanceImpl(currency, null);
    }

    private ApiResponse getBalanceImpl(Currency currency, CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://www.allcoin.com/api2/auth_api/";
        String method = "getinfo";
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        boolean isGet = false;
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("data");
            JSONObject availableBal = (JSONObject)dataJson.get("balances_available");
            if (availableBal == null) {
                if (currency == null) {
                    Amount PEGAvail = new Amount(0.0, pair.getPaymentCurrency());
                    Amount NBTAvail = new Amount(0.0, pair.getOrderCurrency());
                    Amount PEGonOrder = new Amount(0.0, pair.getPaymentCurrency());
                    Amount NBTonOrder = new Amount(0.0, pair.getOrderCurrency());
                    Balance balance = new Balance(PEGAvail, NBTAvail, PEGonOrder, NBTonOrder);
                    apiResponse.setResponseObject(balance);
                } else {
                    Amount total = new Amount(0.0, currency);
                    apiResponse.setResponseObject(total);
                }
            } else if (currency == null) {
                String s;
                JSONObject holdBal = (JSONObject)dataJson.get("balance_hold");
                Amount PEGAvail = new Amount(0.0, pair.getPaymentCurrency());
                Amount NBTAvail = new Amount(0.0, pair.getOrderCurrency());
                Amount PEGonOrder = new Amount(0.0, pair.getPaymentCurrency());
                Amount NBTonOrder = new Amount(0.0, pair.getOrderCurrency());
                if (availableBal.containsKey(pair.getPaymentCurrency().getCode().toUpperCase())) {
                    s = availableBal.get(pair.getPaymentCurrency().getCode().toUpperCase()).toString();
                    PEGAvail.setQuantity(Double.parseDouble(s));
                }
                if (availableBal.containsKey(pair.getOrderCurrency().getCode().toUpperCase())) {
                    s = availableBal.get(pair.getOrderCurrency().getCode().toUpperCase()).toString();
                    NBTAvail.setQuantity(Double.parseDouble(s));
                }
                if (holdBal != null && holdBal.containsKey(pair.getPaymentCurrency().getCode().toUpperCase())) {
                    s = holdBal.get(pair.getPaymentCurrency().getCode().toUpperCase()).toString();
                    PEGonOrder.setQuantity(Double.parseDouble(s));
                }
                if (holdBal != null && holdBal.containsKey(pair.getOrderCurrency().getCode().toUpperCase())) {
                    s = holdBal.get(pair.getOrderCurrency().getCode().toUpperCase()).toString();
                    NBTonOrder.setQuantity(Double.parseDouble(s));
                }
                Balance balance = new Balance(PEGAvail, NBTAvail, PEGonOrder, NBTonOrder);
                apiResponse.setResponseObject(balance);
            } else {
                Amount total = new Amount(0.0, currency);
                if (availableBal.containsKey(currency.getCode().toUpperCase())) {
                    String s = availableBal.get(currency.getCode().toUpperCase()).toString();
                    total.setQuantity(Double.parseDouble(s));
                }
                apiResponse.setResponseObject(total);
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public String getUrlConnectionCheck() {
        return this.checkConnectionUrl;
    }

    @Override
    public ApiResponse getLastPrice(CurrencyPair pair) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String query(String url, HashMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String query(String base, String method, HashMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String query(String url, String method, TreeMap<String, String> args, boolean isGet) {
        String queryResult;
        AllCoinService query = new AllCoinService(url, method, args, this.keys);
        if (this.exchange.getLiveData().isConnected()) {
            queryResult = query.executeQuery(true, isGet);
        } else {
            LOG.severe("The bot will not execute the query, there is no connection to AllCoin");
            queryResult = "No Connection With Exchange";
        }
        return queryResult;
    }

    @Override
    public String query(String url, TreeMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setKeys(ApiKeys keys) {
        this.keys = keys;
    }

    @Override
    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void setApiBaseUrl(String apiBaseUrl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ApiResponse getActiveOrders() {
        return this.getActiveOrdersImpl(null);
    }

    @Override
    public ApiResponse getActiveOrders(CurrencyPair pair) {
        return this.getActiveOrdersImpl(pair);
    }

    public ApiResponse getActiveOrdersImpl(CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        boolean isGet = false;
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        ArrayList<Order> orderList = new ArrayList<Order>();
        String url = "https://www.allcoin.com/api2/auth_api/";
        String method = "myorders";
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONArray dataJson = (JSONArray)httpAnswerJson.get("data");
            if (dataJson == null) {
                ApiError apiError = this.errors.nullReturnError;
                apiResponse.setError(apiError);
            } else {
                Iterator data = dataJson.iterator();
                while (data.hasNext()) {
                    Order order = this.parseOrder((JSONObject)data.next());
                    if (pair != null && !order.getPair().equals(pair)) {
                        LOG.info("|" + order.getPair().toString() + "| = |" + pair.toString() + "|");
                        continue;
                    }
                    if (order.isCompleted()) continue;
                    orderList.add(order);
                }
            }
            apiResponse.setResponseObject(orderList);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    public Order parseOrder(JSONObject data) {
        String type;
        Order order = new Order();
        order.setId(data.get("order_id").toString());
        String pairString = data.get("type").toString() + "_" + data.get("exchange").toString();
        CurrencyPair thisPair = CurrencyPair.getCurrencyPairFromString(pairString, "_");
        order.setPair(thisPair);
        Amount thisAmount = new Amount(Double.parseDouble(data.get("num").toString()), thisPair.getOrderCurrency());
        order.setAmount(thisAmount);
        Amount thisPrice = new Amount(Double.parseDouble(data.get("price").toString()), thisPair.getPaymentCurrency());
        order.setPrice(thisPrice);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");
        Date date = null;
        try {
            date = sdf.parse(data.get("ctime").toString());
        }
        catch (java.text.ParseException pe) {
            LOG.severe(pe.toString());
        }
        if (date != null) {
            long ctime = date.getTime();
            Date insertDate = new Date(ctime);
            order.setInsertedDate(insertDate);
        }
        if ((type = data.get("order_type").toString()).equals("sell")) {
            order.setType("SELL");
        } else {
            order.setType("BUY");
        }
        double remainingOnOrder = Double.parseDouble(data.get("rest_total").toString());
        if (remainingOnOrder > 0.0) {
            order.setCompleted(false);
        } else {
            order.setCompleted(true);
        }
        return order;
    }

    @Override
    public ApiResponse getOrderDetail(String orderID) {
        ApiResponse apiResponse = new ApiResponse();
        ApiResponse activeOrders = this.getActiveOrders();
        if (activeOrders.isPositive()) {
            ArrayList orders = (ArrayList)activeOrders.getResponseObject();
            for (Order thisOrder : orders) {
                if (!thisOrder.getId().equals(orderID)) continue;
                apiResponse.setResponseObject(thisOrder);
            }
        } else {
            apiResponse = activeOrders;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse cancelOrder(String orderID, CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        boolean isGet = false;
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        ArrayList orderList = new ArrayList();
        String url = "https://www.allcoin.com/api2/auth_api/";
        String method = "cancel_order";
        query_args.put("order_id", orderID);
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            String data;
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            try {
                JSONObject dataJson = (JSONObject)httpAnswerJson.get("data");
                data = dataJson.get("order_id").toString();
            }
            catch (ClassCastException cce) {
                data = (String)httpAnswerJson.get("data");
            }
            if (data == null) {
                ApiError apiError = this.errors.nullReturnError;
                apiResponse.setError(apiError);
            } else if (data.equals(orderID)) {
                apiResponse.setResponseObject(true);
            } else {
                apiResponse.setResponseObject(false);
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getTxFee() {
        double defaultFee = 0.15;
        return new ApiResponse(true, defaultFee, null);
    }

    @Override
    public ApiResponse getTxFee(CurrencyPair pair) {
        LOG.warning("AllCoin uses global TX fee, currency pair not supported. \nnow calling getTxFee()");
        return this.getTxFee();
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair) {
        return this.getLastTradesImpl(pair, 0L);
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair, long startTime) {
        return this.getLastTradesImpl(pair, startTime);
    }

    public ApiResponse getLastTradesImpl(CurrencyPair pair, long startTime) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://www.allcoin.com/api2/auth_api/";
        String method = "mytrades";
        boolean isGet = false;
        ArrayList<Trade> tradeList = new ArrayList<Trade>();
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        query_args.put("page", "1");
        query_args.put("page_size", "20");
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONArray trades = (JSONArray)httpAnswerJson.get("data");
            if (trades != null) {
                Iterator trade = trades.iterator();
                while (trade.hasNext()) {
                    Trade thisTrade = this.parseTrade((JSONObject)trade.next());
                    if (!thisTrade.getPair().equals(pair) || thisTrade.getDate().getTime() < startTime) continue;
                    tradeList.add(thisTrade);
                }
            }
            apiResponse.setResponseObject(tradeList);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    public Trade parseTrade(JSONObject in) {
        Trade out = new Trade();
        String cur = in.get("type").toString();
        String com = in.get("exchange").toString();
        String cPair = cur + "_" + com;
        CurrencyPair pair = CurrencyPair.getCurrencyPairFromString(cPair, "_");
        out.setPair(pair);
        out.setId(in.get("trade_id").toString());
        out.setOrder_id(in.get("trade_id").toString());
        out.setType(in.get("trade_type").toString().equals("buy") ? "BUY" : "SELL");
        Amount price = new Amount(Double.parseDouble(in.get("price").toString()), pair.getPaymentCurrency());
        out.setPrice(price);
        Amount amount = new Amount(Double.parseDouble(in.get("num").toString()), pair.getOrderCurrency());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");
        Date date = null;
        try {
            date = sdf.parse(in.get("ctime").toString());
        }
        catch (java.text.ParseException pe) {
            LOG.severe(pe.toString());
        }
        if (date != null) {
            long ctime = date.getTime();
            Date insertDate = new Date(ctime);
            out.setDate(insertDate);
        }
        out.setExchangeName(this.exchange.getName());
        Amount fee = new Amount(Double.parseDouble(in.get("fee").toString()), pair.getPaymentCurrency());
        out.setFee(fee);
        return out;
    }

    @Override
    public ApiResponse isOrderActive(String id) {
        ApiResponse apiResponse = new ApiResponse();
        ApiResponse activeOrdersResponse = this.getActiveOrders();
        apiResponse.setResponseObject(false);
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            for (Order thisOrder : orderList) {
                if (!thisOrder.getId().equals(id)) continue;
                apiResponse.setResponseObject(true);
            }
        }
        return apiResponse;
    }

    @Override
    public ApiResponse clearOrders(CurrencyPair pair) {
        ApiResponse toReturn = new ApiResponse();
        boolean ok = true;
        ApiResponse activeOrdersResponse = this.getActiveOrders();
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            for (int i = 0; i < orderList.size(); ++i) {
                Order tempOrder = (Order)orderList.get(i);
                if (!tempOrder.getPair().equals(pair)) continue;
                ApiResponse deleteOrderResponse = this.cancelOrder(tempOrder.getId(), null);
                if (deleteOrderResponse.isPositive()) {
                    boolean deleted = (Boolean)deleteOrderResponse.getResponseObject();
                    if (deleted) {
                        LOG.warning("Order " + tempOrder.getId() + " deleted succesfully");
                    } else {
                        LOG.warning("Could not delete order " + tempOrder.getId() + "");
                        ok = false;
                    }
                } else {
                    LOG.severe(deleteOrderResponse.getError().toString());
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.severe(ex.toString());
                }
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
            toReturn.setError(activeOrdersResponse.getError());
            return toReturn;
        }
        toReturn.setResponseObject(ok);
        return toReturn;
    }

    private class AllCoinService
    implements ServiceInterface {
        protected String url;
        protected TreeMap args;
        protected ApiKeys keys;
        protected String method;

        public AllCoinService(String url, String method, TreeMap<String, String> args, ApiKeys keys) {
            this.url = url;
            this.args = args;
            this.keys = keys;
            this.method = method;
        }

        private AllCoinService(String url, TreeMap<String, String> args) {
            this.url = url;
            this.args = args;
        }

        @Override
        public String executeQuery(boolean needAuth, boolean isGet) {
            HttpsURLConnection connection = null;
            URL queryUrl = null;
            String post_data = "";
            boolean httpError = false;
            int response = 200;
            String answer = null;
            try {
                queryUrl = new URL(this.url);
            }
            catch (MalformedURLException mal) {
                LOG.severe(mal.toString());
                return null;
            }
            if (needAuth) {
                this.args.put("access_key", this.keys.getApiKey());
                this.args.put("secret_key", this.keys.getPrivateKey());
                this.args.put("created", Objects.toString(System.currentTimeMillis() / 1000L));
                this.args.put("method", this.method);
                this.args.put("sign", this.signRequest(this.keys.getPrivateKey(), TradeUtils.buildQueryString(this.args, "UTF-8")));
                post_data = TradeUtils.buildQueryString(this.args, "UTF-8");
            } else {
                post_data = TradeUtils.buildQueryString(this.args, "UTF-8");
                try {
                    queryUrl = new URL(queryUrl + "?" + post_data);
                }
                catch (MalformedURLException mal) {
                    LOG.severe(mal.toString());
                    return null;
                }
            }
            try {
                connection = (HttpsURLConnection)queryUrl.openConnection();
                connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("User-Agent", Global.settings.getProperty("app_name"));
                connection.setDoOutput(true);
                connection.setDoInput(true);
                if (isGet) {
                    connection.setRequestMethod("GET");
                } else {
                    connection.setRequestMethod("POST");
                    DataOutputStream os = new DataOutputStream(connection.getOutputStream());
                    os.writeBytes(post_data);
                    os.flush();
                    os.close();
                }
            }
            catch (ProtocolException pe) {
                LOG.severe(pe.toString());
                return null;
            }
            catch (IOException io) {
                LOG.severe(io.toString());
                return null;
            }
            BufferedReader br = null;
            try {
                if (connection.getResponseCode() >= 400) {
                    httpError = true;
                    response = connection.getResponseCode();
                    br = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                } else {
                    answer = "";
                    br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                }
            }
            catch (IOException io) {
                LOG.severe(io.toString());
                return null;
            }
            if (httpError) {
                LOG.severe("Query to : " + this.url + " (method = " + this.method + " )" + "\nData : \" + post_data" + "\nHTTP Response : " + Objects.toString(response));
            }
            try {
                String output;
                while ((output = br.readLine()) != null) {
                    answer = answer + output;
                }
            }
            catch (IOException io) {
                LOG.severe(io.toString());
                return null;
            }
            connection.disconnect();
            connection = null;
            return answer;
        }

        @Override
        public String signRequest(String secret, String hash_data) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] array = md.digest(hash_data.getBytes());
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < array.length; ++i) {
                    sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
                }
                return sb.toString();
            }
            catch (NoSuchAlgorithmException e) {
                LOG.severe(e.toString());
                return null;
            }
        }
    }
}

