/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tests;

import com.nubits.nubot.RPC.NuRPCClient;
import com.nubits.nubot.global.Constant;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.tasks.TaskManager;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import com.nubits.nubot.utils.logging.NuLogger;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;

public class TestRPC {
    private static final Logger LOG = Logger.getLogger(TestRPC.class.getName());
    private static String ipTest = "127.0.0.1";
    private static int portTest = 9091;
    private static boolean verbose = false;
    private static boolean useIdentifier = false;

    public static void main(String[] args) {
        String custodian = "bVcXrdTgrMSg6J2YqsLedCbi6Ubek9eTe5";
        String user = "desrever";
        String pass = "c140c140";
        double sell = 0.0;
        double buy = 0.0;
        if (args.length == 5) {
            LOG.info("Reading input parameters");
            user = args[0];
            pass = args[1];
            custodian = args[2];
            sell = Double.parseDouble(args[3]);
            buy = Double.parseDouble(args[4]);
        }
        Utils.loadProperties("settings.properties");
        TestRPC test = new TestRPC();
        test.setup("peatio", custodian, Constant.NBT_BTC, user, pass);
        test.testCheckNudTask();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(TestRPC.class.getName()).log(Level.SEVERE, null, ex);
        }
        test.testSendLiquidityInfo(buy, sell, 1);
        System.exit(0);
    }

    private void testSendLiquidityInfo(double amountBuy, double amountSell, int tier) {
        if (Global.rpcClient.isConnected()) {
            JSONObject responseObject = Global.rpcClient.submitLiquidityInfo("B", amountBuy, amountSell, tier);
            if (null == responseObject) {
                LOG.severe("Something went wrong while sending liquidityinfo");
            } else {
                LOG.info(responseObject.toJSONString());
                if (((Boolean)responseObject.get("submitted")).booleanValue()) {
                    LOG.info("Now calling getliquidityinfo");
                    JSONObject infoObject = Global.rpcClient.getLiquidityInfo("B");
                    LOG.info(infoObject.toJSONString());
                }
            }
        } else {
            LOG.severe("Nu Client offline. ");
        }
    }

    private void testGetInfo() {
        if (Global.rpcClient.isConnected()) {
            JSONObject responseObject = Global.rpcClient.getInfo();
            LOG.info(responseObject.toJSONString());
        } else {
            LOG.severe("Nu Client offline. ");
        }
    }

    private void testIsConnected() {
        String connectedString = "offline";
        if (Global.rpcClient.isConnected()) {
            connectedString = "online";
        }
        LOG.info("Nud is " + connectedString + " @ " + Global.rpcClient.getIp() + ":" + Global.rpcClient.getPort());
    }

    private void setup(String exchangeName, String custodianAddress, CurrencyPair pair, String user, String pass) {
        String folderName = "tests_" + System.currentTimeMillis() + "/";
        String logsFolder = Global.settings.getProperty("log_path") + folderName;
        FileSystem.mkdir(logsFolder);
        try {
            NuLogger.setup(verbose, logsFolder);
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
        System.setProperty("javax.net.ssl.trustStore", Global.settings.getProperty("keystore_path"));
        System.setProperty("javax.net.ssl.trustStorePassword", Global.settings.getProperty("keystore_pass"));
        Global.publicAddress = custodianAddress;
        Global.rpcClient = new NuRPCClient(ipTest, portTest, user, pass, verbose, useIdentifier, custodianAddress, pair, exchangeName);
    }

    private void testCheckNudTask() {
        Global.taskManager = new TaskManager();
        Global.taskManager.getCheckNudTask().start();
    }

    private void testGetLiquidityInfo() {
        if (Global.rpcClient.isConnected()) {
            JSONObject responseObject = Global.rpcClient.getLiquidityInfo("B");
            if (null == responseObject) {
                LOG.severe("Something went wrong while sending liquidityinfo");
            } else {
                LOG.info(responseObject.toJSONString());
            }
        } else {
            LOG.severe("Nu Client offline. ");
        }
    }

    private void testGetLiquidityInfo(String type, String address) {
        if (Global.rpcClient.isConnected()) {
            double response = Global.rpcClient.getLiquidityInfo("B", type, address);
            if (response == -1.0) {
                LOG.severe("Something went wrong while sending liquidityinfo");
            } else {
                LOG.info("Total " + type + " liquidity : " + response + " " + Constant.NBT.getCode());
            }
        } else {
            LOG.severe("Nu Client offline. ");
        }
    }
}

