/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tests;

import com.nubits.nubot.global.Constant;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.utils.FrozenBalancesManager;
import com.nubits.nubot.utils.Utils;
import java.util.logging.Logger;

public class TestFroozenAmounts {
    private static final Logger LOG = Logger.getLogger(TestFroozenAmounts.class.getName());

    public static void main(String[] args) {
        Utils.loadProperties("settings.properties");
        CurrencyPair pair = Constant.NBT_BTC;
        Currency currency = pair.getPaymentCurrency();
        String exchangeName = "bter";
        FrozenBalancesManager fbm = new FrozenBalancesManager(exchangeName, pair, Global.settings.getProperty("frozen_folder"));
        fbm.updateFrozenBalance(new Amount(9.1E-8, currency));
        fbm.updateFrozenBalance(new Amount(5032.0, currency));
        fbm.updateFrozenBalance(new Amount(202.0, currency));
        fbm.updateFrozenBalance(new Amount(30.3, currency));
        fbm.updateFrozenBalance(new Amount(34.3, currency));
        fbm.updateFrozenBalance(new Amount(330.1233, currency));
        fbm.updateFrozenBalance(new Amount(1130.13, currency));
        fbm.updateFrozenBalance(new Amount(303.32342, currency));
        fbm.updateFrozenBalance(new Amount(30.3, currency));
        fbm.updateFrozenBalance(new Amount(1.0, currency));
        LOG.info("Loaded Froozen balance : " + fbm.getFrozenAmount().getAmount().getQuantity());
        fbm.updateFrozenBalance(new Amount(231.2, currency));
        LOG.info("then Froozen balance : " + fbm.getFrozenAmount().getAmount().getQuantity());
    }
}

