/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tasks.strategy;

import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Balance;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.notifications.HipChatNotifications;
import com.nubits.nubot.notifications.MailNotifications;
import com.nubits.nubot.notifications.jhipchat.messages.Message;
import com.nubits.nubot.tasks.SubmitLiquidityinfoTask;
import com.nubits.nubot.trading.TradeUtils;
import com.nubits.nubot.utils.Utils;
import java.util.ArrayList;
import java.util.TimerTask;
import java.util.logging.Logger;

public class StrategyPrimaryPegTask
extends TimerTask {
    private static final Logger LOG = Logger.getLogger(StrategyPrimaryPegTask.class.getName());
    private boolean mightNeedInit = true;
    private int activeSellOrders;
    private int activeBuyOrders;
    private int totalActiveOrders;
    private boolean ordersAndBalancesOk;
    private boolean isFirstTime = true;
    private SubmitLiquidityinfoTask sendLiquidityTask;
    private boolean proceedsInBalance = false;
    private final int RESET_AFTER_CYCLES = 50;
    private final int MAX_RANDOM_WAIT_SECONDS = 5;
    private final int SHORT_WAIT_SECONDS = 5;
    private int cycles = 0;

    @Override
    public void run() {
        LOG.fine("Executing task : StrategyTask. DualSide :  " + Global.options.isDualSide());
        ++this.cycles;
        if (this.cycles != 50) {
            if (!this.isFirstTime) {
                this.recount();
                if (this.mightNeedInit) {
                    if (!this.ordersAndBalancesOk) {
                        if (this.totalActiveOrders != 0) {
                            ApiResponse deleteOrdersResponse = Global.exchange.getTrade().clearOrders(Global.options.getPair());
                            if (deleteOrdersResponse.isPositive()) {
                                boolean deleted = (Boolean)deleteOrdersResponse.getResponseObject();
                                if (deleted) {
                                    LOG.warning("Clear all orders request succesfully");
                                    boolean timedOut = false;
                                    long timeout = Global.options.getEmergencyTimeout() * 1000;
                                    long wait = 6000L;
                                    long count = 0L;
                                    do {
                                        try {
                                            Thread.sleep(wait);
                                            timedOut = (count += wait) > timeout;
                                        }
                                        catch (InterruptedException ex) {
                                            LOG.severe(ex.toString());
                                        }
                                    } while (!TradeUtils.tryCancelAllOrders(Global.options.getPair()) && !timedOut);
                                    if (timedOut) {
                                        String message = "There was a problem cancelling all existing orders";
                                        LOG.severe(message);
                                        HipChatNotifications.sendMessage(message, Message.Color.YELLOW);
                                        MailNotifications.send(Global.options.getMailRecipient(), "NuBot : Problem cancelling existing orders", message);
                                    }
                                    this.placeInitialWalls();
                                } else {
                                    String message = "Could not submit request to clear orders";
                                    LOG.severe(message);
                                    System.exit(0);
                                }
                            } else {
                                LOG.severe(deleteOrdersResponse.getError().toString());
                                String message = "Could not submit request to clear orders";
                                LOG.severe(message);
                                System.exit(0);
                            }
                        } else {
                            this.placeInitialWalls();
                        }
                    } else {
                        LOG.warning("No need to init new orders since current orders seems correct");
                    }
                    this.mightNeedInit = false;
                    this.recount();
                }
                if (!this.ordersAndBalancesOk) {
                    LOG.severe("Detected a number of active orders not in line with strategy. Will try to aggregate soon");
                    this.mightNeedInit = true;
                } else {
                    ApiResponse balancesResponse = Global.exchange.getTrade().getAvailableBalances(Global.options.getPair());
                    if (balancesResponse.isPositive()) {
                        Balance balance = (Balance)balancesResponse.getResponseObject();
                        Amount balanceNBT = balance.getNBTAvailable();
                        Amount balanceFIAT = Global.frozenBalances.removeFrozenAmount(balance.getPEGAvailableBalance(), Global.frozenBalances.getFrozenAmount());
                        LOG.fine("Updated Balance : " + balanceNBT.getQuantity() + " NBT\n " + balanceFIAT.getQuantity() + " USD");
                        this.sellSide(balanceNBT);
                        if (Global.isDualSide && this.proceedsInBalance) {
                            this.buySide();
                        }
                    } else {
                        LOG.severe(balancesResponse.getError().toString());
                    }
                }
            } else {
                LOG.info("Initializing strategy");
                this.recount();
                this.isFirstTime = false;
                boolean reinitiateSuccess = this.reInitiateOrders(true);
                if (!reinitiateSuccess) {
                    LOG.severe("There was a problem while trying to reinitiating orders on first execution. Trying again on next execution");
                    this.isFirstTime = true;
                } else {
                    LOG.info("Initial walls placed");
                }
                this.getSendLiquidityTask().setFirstOrdersPlaced(true);
            }
        } else {
            this.cycles = 0;
            this.cycles += Utils.randInt(0, 5);
            boolean cancelSells = TradeUtils.takeDownOrders("SELL", Global.options.getPair());
            if (cancelSells) {
                ApiResponse balancesResponse = Global.exchange.getTrade().getAvailableBalances(Global.options.getPair());
                if (balancesResponse.isPositive()) {
                    Balance balance = (Balance)balancesResponse.getResponseObject();
                    Amount balanceNBT = balance.getNBTAvailable();
                    Amount balanceFIAT = Global.frozenBalances.removeFrozenAmount(balance.getPEGAvailableBalance(), Global.frozenBalances.getFrozenAmount());
                    LOG.fine("Updated Balance : " + balanceNBT.getQuantity() + " NBT\n " + balanceFIAT.getQuantity() + " USD");
                    try {
                        Thread.sleep(Utils.randInt(0, 5) * 1000);
                    }
                    catch (InterruptedException ex) {
                        LOG.severe(ex.toString());
                    }
                    this.sellSide(balanceNBT);
                }
                LOG.severe(balancesResponse.getError().toString());
            }
            if (Global.isDualSide) {
                try {
                    Thread.sleep(Utils.randInt(0, 5) * 1000);
                }
                catch (InterruptedException ex) {
                    LOG.severe(ex.toString());
                }
                this.buySide();
            }
        }
    }

    private void placeInitialWalls() {
        ApiResponse txFeeNTBFIATResponse = Global.exchange.getTrade().getTxFee(Global.options.getPair());
        if (txFeeNTBFIATResponse.isPositive()) {
            double txFeeFIATNTB = (Double)txFeeNTBFIATResponse.getResponseObject();
            boolean buysOrdersOk = true;
            boolean sellsOrdersOk = this.initOrders("SELL", TradeUtils.getSellPrice(txFeeFIATNTB));
            if (Global.options.isDualSide()) {
                buysOrdersOk = this.initOrders("BUY", TradeUtils.getBuyPrice(txFeeFIATNTB));
            }
            this.mightNeedInit = !buysOrdersOk || !sellsOrdersOk;
        } else {
            LOG.severe("An error occurred while attempting to update tx fee.");
            this.mightNeedInit = true;
        }
    }

    private void sellSide(Amount balanceNBT) {
        if (balanceNBT.getQuantity() > 1.0) {
            String idToDelete = this.getSmallerWallID("SELL");
            if (!idToDelete.equals("-1")) {
                LOG.warning("Sellside : Taking down smaller order to aggregate it with new balance");
                if (TradeUtils.takeDownAndWait(idToDelete, Global.options.getEmergencyTimeout() * 1000, Global.options.getPair())) {
                    ApiResponse balancesResponse = Global.exchange.getTrade().getAvailableBalances(Global.options.getPair());
                    if (balancesResponse.isPositive()) {
                        Balance balance = (Balance)balancesResponse.getResponseObject();
                        balanceNBT = balance.getNBTAvailable();
                        Amount balanceFIAT = Global.frozenBalances.removeFrozenAmount(balance.getPEGAvailableBalance(), Global.frozenBalances.getFrozenAmount());
                        LOG.fine("Updated Balance : " + balanceNBT.getQuantity() + " " + balanceNBT.getCurrency().getCode() + "\n " + balanceFIAT.getQuantity() + " " + balanceFIAT.getCurrency().getCode());
                        ApiResponse txFeeNTBUSDResponse = Global.exchange.getTrade().getTxFee(Global.options.getPair());
                        if (txFeeNTBUSDResponse.isPositive()) {
                            double txFeeUSDNTB = (Double)txFeeNTBUSDResponse.getResponseObject();
                            LOG.fine("Updated Trasaction fee = " + txFeeUSDNTB + "%");
                            double sellPrice = TradeUtils.getSellPrice(txFeeUSDNTB);
                            if (Global.options.getMaxSellVolume() > 0.0 && balanceNBT.getQuantity() > Global.options.getMaxSellVolume()) {
                                balanceNBT.setQuantity(Global.options.getMaxSellVolume());
                            }
                            double amountToSell = balanceNBT.getQuantity();
                            if (Global.executeOrders) {
                                String orderString = "sell " + Utils.round(amountToSell, 2) + " " + Global.options.getPair().getOrderCurrency().getCode() + " @ " + sellPrice + " " + Global.options.getPair().getPaymentCurrency().getCode();
                                LOG.warning("Strategy : Submit order : " + orderString);
                                ApiResponse sellResponse = Global.exchange.getTrade().sell(Global.options.getPair(), amountToSell, sellPrice);
                                if (sellResponse.isPositive()) {
                                    HipChatNotifications.sendMessage("New sell wall is up on " + Global.options.getExchangeName() + " : " + orderString, Message.Color.YELLOW);
                                    String sellResponseString = (String)sellResponse.getResponseObject();
                                    LOG.warning("Strategy : Sell Response = " + sellResponseString);
                                } else {
                                    LOG.severe(sellResponse.getError().toString());
                                }
                            } else {
                                LOG.warning("Strategy : (Should) Submit order : sell" + amountToSell + " " + Global.options.getPair().getOrderCurrency().getCode() + " @ " + sellPrice + " " + Global.options.getPair().getPaymentCurrency().getCode());
                            }
                        } else {
                            LOG.severe(txFeeNTBUSDResponse.getError().toString());
                        }
                    } else {
                        LOG.severe(balancesResponse.getError().toString());
                    }
                } else {
                    String errMessagedeletingOrder = "could not delete order " + idToDelete;
                    LOG.severe(errMessagedeletingOrder);
                    HipChatNotifications.sendMessage(errMessagedeletingOrder, Message.Color.YELLOW);
                    MailNotifications.send(Global.options.getMailRecipient(), "NuBot : problem shifting walls", errMessagedeletingOrder);
                }
            } else {
                LOG.severe("Can't get smaller wall id.");
            }
        } else {
            LOG.fine("NBT balance < 1, no orders to execute");
        }
    }

    private void buySide() {
        boolean cancel = TradeUtils.takeDownOrders("BUY", Global.options.getPair());
        if (cancel) {
            Global.frozenBalances.freezeNewFunds();
            ApiResponse txFeeNTBFIATResponse = Global.exchange.getTrade().getTxFee(Global.options.getPair());
            if (txFeeNTBFIATResponse.isPositive()) {
                double txFeeFIATNTB = (Double)txFeeNTBFIATResponse.getResponseObject();
                this.initOrders("BUY", TradeUtils.getBuyPrice(txFeeFIATNTB));
            } else {
                LOG.severe("An error occurred while attempting to update tx fee.");
            }
        } else {
            LOG.severe("An error occurred while attempting to cancel buy orders.");
        }
    }

    private String getSmallerWallID(String type) {
        Order smallerOrder = new Order();
        smallerOrder.setId("-1");
        ApiResponse activeOrdersResponse = Global.exchange.getTrade().getActiveOrders(Global.options.getPair());
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            ArrayList<Order> orderListCategorized = TradeUtils.filterOrders(orderList, type);
            for (int i = 0; i < orderListCategorized.size(); ++i) {
                Order tempOrder = orderListCategorized.get(i);
                if (!tempOrder.getType().equalsIgnoreCase(type)) continue;
                if (i == 0) {
                    smallerOrder = tempOrder;
                    continue;
                }
                if (!(smallerOrder.getAmount().getQuantity() > tempOrder.getAmount().getQuantity())) continue;
                smallerOrder = tempOrder;
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
            return "-1";
        }
        return smallerOrder.getId();
    }

    private int countActiveOrders(String type) {
        int toRet = 0;
        ApiResponse activeOrdersResponse = Global.exchange.getTrade().getActiveOrders(Global.options.getPair());
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            for (int i = 0; i < orderList.size(); ++i) {
                Order tempOrder = (Order)orderList.get(i);
                if (!tempOrder.getType().equalsIgnoreCase(type)) continue;
                ++toRet;
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
            return -1;
        }
        return toRet;
    }

    private void recount() {
        ApiResponse balancesResponse = Global.exchange.getTrade().getAvailableBalances(Global.options.getPair());
        if (balancesResponse.isPositive()) {
            Balance balance = (Balance)balancesResponse.getResponseObject();
            double balanceNBT = balance.getNBTAvailable().getQuantity();
            double balanceFIAT = Global.frozenBalances.removeFrozenAmount(balance.getPEGAvailableBalance(), Global.frozenBalances.getFrozenAmount()).getQuantity();
            this.activeSellOrders = this.countActiveOrders("SELL");
            this.activeBuyOrders = this.countActiveOrders("BUY");
            this.totalActiveOrders = this.activeSellOrders + this.activeBuyOrders;
            this.ordersAndBalancesOk = false;
            if (Global.options.isDualSide()) {
                boolean bl = this.ordersAndBalancesOk = this.activeSellOrders == 2 && this.activeBuyOrders == 2 || this.activeSellOrders == 2 && this.activeBuyOrders == 0 && balanceFIAT < 1.0 || this.activeSellOrders == 0 && this.activeBuyOrders == 2 && balanceNBT < 1.0;
                if (balanceFIAT > 1.0 && !this.isFirstTime) {
                    LOG.warning("The " + balance.getPEGAvailableBalance().getCurrency().getCode() + " balance is not zero (" + balanceFIAT + " ). If the balance represent proceedings " + "from a sale the bot will notice.  On the other hand, If you keep seying this message repeatedly over and over, you should restart the bot. ");
                    this.proceedsInBalance = true;
                } else {
                    this.proceedsInBalance = false;
                }
            } else {
                this.ordersAndBalancesOk = this.activeSellOrders == 2 && this.activeBuyOrders == 0 && balanceNBT < 0.01;
            }
        } else {
            LOG.severe(balancesResponse.getError().toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean reInitiateOrders(boolean firstTime) {
        if (this.totalActiveOrders == 0) {
            if (firstTime) {
                Global.frozenBalances.setBalanceAlreadyThere(Global.options.getPair().getPaymentCurrency());
            }
            this.placeInitialWalls();
        } else {
            ApiResponse deleteOrdersResponse = Global.exchange.getTrade().clearOrders(Global.options.getPair());
            if (!deleteOrdersResponse.isPositive()) {
                LOG.severe(deleteOrdersResponse.getError().toString());
                String message = "Could not submit request to clear orders";
                LOG.severe(message);
                return false;
            }
            boolean deleted = (Boolean)deleteOrdersResponse.getResponseObject();
            if (!deleted) {
                String message = "Could not submit request to clear orders";
                LOG.severe(message);
                return false;
            }
            LOG.warning("Clear all orders request succesfully");
            if (firstTime) {
                Global.frozenBalances.setBalanceAlreadyThere(Global.options.getPair().getPaymentCurrency());
            }
            boolean timedOut = false;
            long timeout = Global.options.getEmergencyTimeout() * 1000;
            long wait = 5000L;
            long count = 0L;
            boolean areAllOrdersCanceled = false;
            do {
                try {
                    Thread.sleep(wait);
                    areAllOrdersCanceled = TradeUtils.tryCancelAllOrders(Global.options.getPair());
                    LOG.info("Are all orders canceled? " + areAllOrdersCanceled);
                    timedOut = (count += wait) > timeout;
                }
                catch (InterruptedException ex) {
                    LOG.severe(ex.toString());
                }
            } while (!areAllOrdersCanceled && !timedOut);
            if (timedOut) {
                String message = "There was a problem cancelling all existing orders";
                LOG.severe(message);
                HipChatNotifications.sendMessage(message, Message.Color.YELLOW);
                MailNotifications.send(Global.options.getMailRecipient(), "NuBot : Problem cancelling existing orders", message);
            }
            this.placeInitialWalls();
        }
        try {
            Thread.sleep(5L);
            return true;
        }
        catch (InterruptedException ex) {
            LOG.severe(ex.toString());
        }
        return true;
    }

    private boolean initOrders(String type, double price) {
        boolean success = true;
        Amount balance = null;
        Currency currency = type.equals("SELL") ? Global.options.getPair().getOrderCurrency() : Global.options.getPair().getPaymentCurrency();
        ApiResponse balancesResponse = Global.exchange.getTrade().getAvailableBalance(currency);
        if (balancesResponse.isPositive()) {
            double oneNBT = 1.0;
            if (type.equals("SELL")) {
                balance = (Amount)balancesResponse.getResponseObject();
            } else {
                balance = (Amount)balancesResponse.getResponseObject();
                balance = Global.frozenBalances.removeFrozenAmount(balance, Global.frozenBalances.getFrozenAmount());
                oneNBT = Utils.round(1.0 / Global.conversion, 8);
            }
            if (balance.getQuantity() > oneNBT) {
                ApiResponse txFeeNTBPEGResponse = Global.exchange.getTrade().getTxFee(Global.options.getPair());
                if (txFeeNTBPEGResponse.isPositive()) {
                    double txFeePEGNTB = (Double)txFeeNTBPEGResponse.getResponseObject();
                    LOG.fine("Updated Trasaction fee = " + txFeePEGNTB + "%");
                    double amount1 = Utils.round(balance.getQuantity() / 2.0, 8);
                    if (Global.options.getMaxSellVolume() > 0.0 && type.equals("SELL")) {
                        double d = amount1 = amount1 > Global.options.getMaxSellVolume() / 2.0 ? Global.options.getMaxSellVolume() / 2.0 : amount1;
                    }
                    if (type.equals("BUY") && !Global.swappedPair) {
                        amount1 = Utils.round(amount1 / price, 8);
                        if (Global.options.getMaxBuyVolume() > 0.0) {
                            amount1 = amount1 > Global.options.getMaxBuyVolume() / 2.0 ? Global.options.getMaxBuyVolume() / 2.0 : amount1;
                        }
                    }
                    double amount2 = balance.getQuantity() - amount1;
                    if (Global.options.getMaxSellVolume() > 0.0 && type.equals("SELL")) {
                        double d = amount2 = amount2 > Global.options.getMaxSellVolume() / 2.0 ? Global.options.getMaxSellVolume() / 2.0 : amount2;
                    }
                    if (type.equals("BUY") && !Global.swappedPair || type.equals("SELL") && Global.swappedPair) {
                        amount2 = Utils.round(amount2 - oneNBT * 0.9, 8);
                        amount2 = Utils.round(amount2 / price, 8);
                        if (Global.options.getMaxBuyVolume() > 0.0) {
                            double d = amount2 = amount2 > Global.options.getMaxBuyVolume() / 2.0 ? Global.options.getMaxBuyVolume() / 2.0 : amount2;
                        }
                    }
                    if (type.equals("BUY")) {
                        amount2 = Utils.round(amount2 / price, 8);
                    }
                    String orderString1 = type + " " + Utils.round(amount1, 2) + " " + Global.options.getPair().getOrderCurrency().getCode() + " @ " + price + " " + Global.options.getPair().getPaymentCurrency().getCode();
                    String orderString2 = type + " " + Utils.round(amount2, 2) + " " + Global.options.getPair().getOrderCurrency().getCode() + " @ " + price + " " + Global.options.getPair().getPaymentCurrency().getCode();
                    if (Global.options.isExecuteOrders()) {
                        LOG.warning("Strategy - Submit order : " + orderString1);
                        ApiResponse order1Response = type.equals("SELL") ? Global.exchange.getTrade().sell(Global.options.getPair(), amount1, price) : Global.exchange.getTrade().buy(Global.options.getPair(), amount1, price);
                        if (order1Response.isPositive()) {
                            HipChatNotifications.sendMessage("New " + type + " wall is up on " + Global.options.getExchangeName() + " : " + orderString1, Message.Color.YELLOW);
                            String response1String = (String)order1Response.getResponseObject();
                            LOG.warning("Strategy - " + type + " Response1 = " + response1String);
                        } else {
                            LOG.severe(order1Response.getError().toString());
                            success = false;
                        }
                        LOG.warning("Strategy - Submit order : " + orderString2);
                        ApiResponse order2Response = type.equals("SELL") ? Global.exchange.getTrade().sell(Global.options.getPair(), amount2, price) : Global.exchange.getTrade().buy(Global.options.getPair(), amount2, price);
                        if (order2Response.isPositive()) {
                            HipChatNotifications.sendMessage("New " + type + " wall is up on " + Global.options.getExchangeName() + " : " + orderString2, Message.Color.YELLOW);
                            String response2String = (String)order2Response.getResponseObject();
                            LOG.warning("Strategy : " + type + " Response2 = " + response2String);
                        } else {
                            LOG.severe(order2Response.getError().toString());
                            success = false;
                        }
                    } else {
                        LOG.warning("Should execute : " + orderString1 + "\n and " + orderString2);
                    }
                }
            } else {
                LOG.fine(type + " available balance < 1 NBT, no need to execute orders");
            }
        } else {
            LOG.severe(balancesResponse.getError().toString());
            success = false;
        }
        return success;
    }

    public SubmitLiquidityinfoTask getSendLiquidityTask() {
        return this.sendLiquidityTask;
    }

    public void setSendLiquidityTask(SubmitLiquidityinfoTask sendLiquidityTask) {
        this.sendLiquidityTask = sendLiquidityTask;
    }
}

