/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tasks.strategy;

import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.LastPrice;
import com.nubits.nubot.notifications.HipChatNotifications;
import com.nubits.nubot.notifications.MailNotifications;
import com.nubits.nubot.notifications.jhipchat.messages.Message;
import com.nubits.nubot.pricefeeds.PriceFeedManager;
import com.nubits.nubot.tasks.strategy.StrategySecondaryPegTask;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PriceMonitorTriggerTask
extends TimerTask {
    private int count;
    private final int MAX_ATTEMPTS = 5;
    private static final Logger LOG = Logger.getLogger(PriceMonitorTriggerTask.class.getName());
    private PriceFeedManager pfm = null;
    private StrategySecondaryPegTask strategy = null;
    private double distanceTreshold;
    private LastPrice lastPrice;
    private boolean isFirstTimeExecution = true;
    private LastPrice currentWallPEGPrice;
    private double wallchangeThreshold;
    private double sellPriceUSD;
    private double buyPriceUSD;
    private String outputPath;
    private String jsonFile;
    private String emailHistory = "";
    private String pegPriceDirection;
    private double sellPricePEG_old;
    private boolean wallsBeingShifted = false;
    private Long currentTime = null;
    private Queue<Double> queueMA = new LinkedList<Double>();
    private int MOVING_AVERAGE_SIZE = 30;
    private static final int REFRESH_OFFSET = 1000;
    private static final int PRICE_PERCENTAGE = 10;
    private static int SLEEP_COUNT = 0;

    @Override
    public void run() {
        if (SLEEP_COUNT > 0) {
            --SLEEP_COUNT;
            this.currentTime = System.currentTimeMillis();
            return;
        }
        this.currentTime = System.currentTimeMillis();
        LOG.fine("Executing task : PriceMonitorTriggerTask ");
        if (this.pfm == null || this.strategy == null) {
            LOG.severe("PriceMonitorTriggerTask task needs a PriceFeedManager and a Strategy to work. Please assign it before running it");
        } else {
            this.count = 1;
            this.executeUpdatePrice(this.count);
        }
    }

    private void executeUpdatePrice(int countTrials) {
        if (countTrials <= 5) {
            ArrayList<LastPrice> priceList = this.pfm.getLastPrices().getPrices();
            LOG.fine("CheckLastPrice received values from remote feeds. ");
            if (priceList.size() == this.pfm.getFeedList().size()) {
                if (this.sanityCheck(priceList, 0)) {
                    this.updateLastPrice(priceList.get(0));
                } else {
                    boolean foundSomeValidBackUp = false;
                    LastPrice goodPrice = null;
                    for (int l = 1; l < priceList.size(); ++l) {
                        if (!this.sanityCheck(priceList, l)) continue;
                        goodPrice = priceList.get(l);
                        foundSomeValidBackUp = true;
                        break;
                    }
                    if (foundSomeValidBackUp) {
                        this.updateLastPrice(goodPrice);
                    } else {
                        this.unableToUpdatePrice(priceList);
                    }
                }
            } else if (priceList.size() == 2) {
                if (this.closeEnough(priceList.get(0).getPrice().getQuantity(), priceList.get(1).getPrice().getQuantity())) {
                    this.updateLastPrice(priceList.get(0));
                } else {
                    this.unableToUpdatePrice(priceList);
                }
            } else if (priceList.size() > 2) {
                boolean foundSomeValidBackUp = false;
                LastPrice goodPrice = null;
                for (int l = 1; l < priceList.size(); ++l) {
                    if (!this.sanityCheck(priceList, l)) continue;
                    goodPrice = priceList.get(l);
                    foundSomeValidBackUp = true;
                    break;
                }
                if (foundSomeValidBackUp) {
                    this.updateLastPrice(goodPrice);
                } else {
                    this.unableToUpdatePrice(priceList);
                }
            } else {
                this.unableToUpdatePrice(priceList);
            }
        } else {
            LOG.severe("The price has failed updating more than 5 times in a row");
            this.sendErrorNotification();
            Global.exchange.getTrade().clearOrders(Global.options.getPair());
        }
    }

    private void initMA(double price) {
        for (int i = 0; i <= 30; ++i) {
            this.updateMovingAverageQueue(price);
        }
    }

    private void unableToUpdatePrice(ArrayList<LastPrice> priceList) {
        ++this.count;
        try {
            Thread.sleep(this.count * 60 * 1000);
        }
        catch (InterruptedException ex) {
            LOG.severe(ex.toString());
        }
        this.executeUpdatePrice(this.count);
    }

    private void sendErrorNotification() {
        if (Global.options != null) {
            String title = "Problems while updating " + this.pfm.getPair().getOrderCurrency().getCode() + " price. Cannot find a reliable feed.";
            String message = "NuBot timed out after 5 failed attempts to update " + this.pfm.getPair().getOrderCurrency().getCode() + "" + " price. Please restart the bot and get in touch with Nu Dev team";
            MailNotifications.send(Global.options.getMailRecipient(), title, message);
            HipChatNotifications.sendMessage(title + message, Message.Color.RED);
            LOG.severe(title + message);
        }
    }

    private boolean sanityCheck(ArrayList<LastPrice> priceList, int mainPriceIndex) {
        boolean[] ok = new boolean[priceList.size() - 1];
        double mainPrice = priceList.get(mainPriceIndex).getPrice().getQuantity();
        int f = 0;
        for (int i = 0; i < priceList.size(); ++i) {
            if (i == mainPriceIndex) continue;
            LastPrice tempPrice = priceList.get(i);
            double temp = tempPrice.getPrice().getQuantity();
            ok[f] = this.closeEnough(mainPrice, temp);
            ++f;
        }
        int countOk = 0;
        for (int j = 0; j < ok.length; ++j) {
            if (!ok[j]) continue;
            ++countOk;
        }
        boolean overallOk = false;
        if (ok.length % 2 == 0) {
            if (countOk >= ok.length / 2) {
                overallOk = true;
            }
        } else if (countOk > ok.length / 2) {
            overallOk = true;
        }
        return overallOk;
    }

    private boolean closeEnough(double mainPrice, double temp) {
        double distance = Math.abs(mainPrice - temp);
        double percentageDistance = Utils.round(distance * 100.0 / mainPrice, 4);
        return !(percentageDistance > this.distanceTreshold);
    }

    public double getMovingAverage() {
        double MA = 0.0;
        Iterator price = this.queueMA.iterator();
        while (price.hasNext()) {
            MA += ((Double)price.next()).doubleValue();
        }
        return MA /= (double)this.queueMA.size();
    }

    public void updateMovingAverageQueue(double price) {
        if (price == 0.0) {
            return;
        }
        this.queueMA.add(price);
        if (this.queueMA.size() > this.MOVING_AVERAGE_SIZE) {
            this.queueMA.remove();
        }
    }

    public void gracefulPause(LastPrice lp) {
        String subject;
        Message.Color notificationColor;
        String notification;
        String logMessage;
        double sleepTime = 0.0;
        if (!Global.exchange.getLiveData().isConnected()) {
            this.currentTime = System.currentTimeMillis();
            logMessage = "There has been a connection issue for " + Integer.parseInt(Global.settings.getProperty("refresh_time_seconds")) + " seconds\n" + "Consider restarting the bot if the connection issue persists";
            notification = "";
            notificationColor = Message.Color.YELLOW;
            subject = Global.exchange.getName() + " Bot is suffering a connection issue";
        } else {
            sleepTime = Integer.parseInt(Global.settings.getProperty("refresh_time_seconds")) * 3;
            logMessage = "The Fetched Exchange rate data has remained outside of the required price band for " + Integer.parseInt(Global.settings.getProperty("refresh_time_seconds")) + "seconds.\nThe bot will notify and restart in " + sleepTime + "seconds.";
            notification = "A large price difference was detected at " + Global.exchange.getName() + ".\nThe Last obtained price of " + Objects.toString(lp.getPrice().getQuantity()) + " was outside of " + Objects.toString(10) + "% of the moving average figure of " + Objects.toString(this.getMovingAverage()) + ".\nNuBot will remove the current orders and replace them in " + sleepTime + "seconds.";
            notificationColor = Message.Color.PURPLE;
            subject = Global.exchange.getName() + " Moving Average issue. Bot will replace orders in " + sleepTime + "seconds.";
        }
        LOG.severe(logMessage);
        LOG.severe("Notifying HipChat");
        HipChatNotifications.sendMessage(notification, notificationColor);
        LOG.severe("Sending Email");
        MailNotifications.send(Global.options.getMailRecipient(), subject, notification);
        if (sleepTime > 0.0) {
            LOG.severe("Cancelling Orders to avoid Arbitrage against the bot");
            Global.exchange.getTrade().clearOrders(Global.options.getPair());
            this.queueMA.clear();
            LOG.severe("Sleeping for " + sleepTime);
            SLEEP_COUNT = 3;
        }
        this.currentTime = System.currentTimeMillis();
    }

    public void updateLastPrice(LastPrice lp) {
        if (this.queueMA.size() < this.MOVING_AVERAGE_SIZE) {
            this.initMA(lp.getPrice().getQuantity());
        }
        if (!Global.options.isMultipleCustodians()) {
            double current = lp.getPrice().getQuantity();
            double MA = this.getMovingAverage();
            double percentageDiff = (MA - current) / ((MA + current) / 2.0) * 100.0;
            if (percentageDiff > 10.0 || percentageDiff < -10.0) {
                LOG.warning("Latest price " + Objects.toString(current) + " is " + Objects.toString(percentageDiff) + "% outside of the moving average of " + Objects.toString(MA) + "." + "\nShifting moving average and re-fetching exchange rate data.");
                this.updateMovingAverageQueue(current);
                this.executeUpdatePrice(1);
                return;
            }
            if ((System.currentTimeMillis() - (this.currentTime + 1000L)) / 1000L < (long)Integer.parseInt(Global.settings.getProperty("refresh_time_seconds"))) {
                this.updateMovingAverageQueue(current);
            } else {
                this.gracefulPause(lp);
                return;
            }
        }
        this.lastPrice = lp;
        LOG.fine("Price Updated." + lp.getSource() + ":1 " + lp.getCurrencyMeasured().getCode() + " = " + "" + lp.getPrice().getQuantity() + " " + lp.getPrice().getCurrency().getCode() + "\n");
        if (this.isFirstTimeExecution) {
            this.initStrategy(lp.getPrice().getQuantity());
            this.currentWallPEGPrice = lp;
            this.isFirstTimeExecution = false;
        } else {
            this.verifyPegPrices();
        }
    }

    public LastPrice getLastPriceFromFeeds() {
        return this.lastPrice;
    }

    private void verifyPegPrices() {
        LOG.fine("Executing tryMoveWalls");
        boolean needToShift = true;
        if (!Global.options.isMultipleCustodians()) {
            needToShift = this.needToMoveWalls(this.lastPrice);
        }
        if (needToShift && !this.isWallsBeingShifted()) {
            LOG.info("Walls needs to be shifted");
            this.currentWallPEGPrice = this.lastPrice;
            this.computeNewPrices();
        } else {
            LOG.fine("No need to move walls");
            this.currentTime = System.currentTimeMillis();
            if (this.isWallsBeingShifted() && needToShift) {
                LOG.warning("Wall shift is postponed: another process is already shifting existing walls. Will try again on next execution.");
            }
        }
    }

    private boolean needToMoveWalls(LastPrice last) {
        double currentWallPEGprice = this.currentWallPEGPrice.getPrice().getQuantity();
        double distance = Math.abs(last.getPrice().getQuantity() - currentWallPEGprice);
        double percentageDistance = Utils.round(distance * 100.0 / currentWallPEGprice, 4);
        LOG.fine("d=" + percentageDistance + "% (old : " + currentWallPEGprice + " new " + last.getPrice().getQuantity() + ")");
        return !(percentageDistance < this.wallchangeThreshold);
    }

    private void computeNewPrices() {
        double buyPricePEG_new;
        double sellPricePEG_new;
        double peg_price = this.lastPrice.getPrice().getQuantity();
        if (Global.swappedPair) {
            sellPricePEG_new = Utils.round(this.sellPriceUSD * Global.conversion, 8);
            buyPricePEG_new = Utils.round(this.buyPriceUSD * Global.conversion, 8);
        } else {
            sellPricePEG_new = Utils.round(this.sellPriceUSD / peg_price, 8);
            buyPricePEG_new = Utils.round(this.buyPriceUSD / peg_price, 8);
        }
        this.pegPriceDirection = sellPricePEG_new - this.sellPricePEG_old > 0.0 ? "up" : "down";
        LOG.info("Sell Price " + sellPricePEG_new + "  | " + "Buy Price  " + buyPricePEG_new);
        String source = this.currentWallPEGPrice.getSource();
        double price = this.currentWallPEGPrice.getPrice().getQuantity();
        String currency = this.currentWallPEGPrice.getPrice().getCurrency().getCode();
        String crypto = this.pfm.getPair().getOrderCurrency().getCode();
        this.strategy.notifyPriceChanged(sellPricePEG_new, buyPricePEG_new, price, this.pegPriceDirection);
        Global.conversion = price;
        this.sellPricePEG_old = sellPricePEG_new;
        Date currentDate = new Date();
        String row = currentDate + "," + source + "," + crypto + "," + price + "," + currency + "," + sellPricePEG_new + "," + buyPricePEG_new + ",";
        JSONArray backup_feeds = new JSONArray();
        JSONObject otherPricesAtThisTime = new JSONObject();
        ArrayList<LastPrice> priceList = this.pfm.getLastPrices().getPrices();
        for (int i = 0; i < priceList.size(); ++i) {
            LastPrice tempPrice = priceList.get(i);
            otherPricesAtThisTime.put("feed", tempPrice.getSource());
            otherPricesAtThisTime.put("price", tempPrice.getPrice().getQuantity());
        }
        LOG.warning(row);
        row = row + otherPricesAtThisTime.toString() + "\n";
        backup_feeds.add(otherPricesAtThisTime);
        FileSystem.writeToFile(row, this.outputPath, true);
        JSONObject wall_shift = new JSONObject();
        wall_shift.put("timestamp", currentDate.getTime());
        wall_shift.put("feed", source);
        wall_shift.put("crypto", crypto);
        wall_shift.put("price", price);
        wall_shift.put("currency", currency);
        wall_shift.put("sell_price", sellPricePEG_new);
        wall_shift.put("buy_price", buyPricePEG_new);
        wall_shift.put("backup_feed", backup_feeds);
        JSONParser parser = new JSONParser();
        JSONObject wall_shift_file = new JSONObject();
        JSONArray wall_shifts = new JSONArray();
        try {
            wall_shift_file = (JSONObject)parser.parse(FileSystem.readFromFile(this.jsonFile));
            wall_shifts = (JSONArray)wall_shift_file.get("wall_shifts");
        }
        catch (ParseException pe) {
            LOG.severe("Unable to parse order_history.json");
        }
        wall_shifts.add(wall_shift);
        wall_shift_file.put("wall_shifts", wall_shifts);
        FileSystem.writeToFile(wall_shift_file.toJSONString(), this.jsonFile, false);
        if (Global.options.isSendMails()) {
            String title = " production (" + Global.options.getExchangeName() + ") [" + this.pfm.getPair().toString() + "] price changed more than " + this.wallchangeThreshold + "%";
            String messageNow = row;
            this.emailHistory = this.emailHistory + messageNow;
            String tldr = this.pfm.getPair().toString() + " price changed more than " + this.wallchangeThreshold + "% since last notification: " + "now is " + price + " " + this.pfm.getPair().getPaymentCurrency().getCode().toUpperCase() + ".\n" + "Here are the prices the bot used in the new orders : \n" + "Sell at " + sellPricePEG_new + " " + this.pfm.getPair().getOrderCurrency().getCode().toUpperCase() + " " + "and buy at " + buyPricePEG_new + " " + this.pfm.getPair().getOrderCurrency().getCode().toUpperCase() + "\n" + "\n#########\n" + "Below you can see the history of price changes. You can copy paste to create a csv report." + "For each row the bot should have shifted the sell/buy walls.\n\n";
            MailNotifications.send(Global.options.getMailRecipient(), title, tldr + this.emailHistory);
        }
    }

    private void initStrategy(double peg_price) {
        Global.conversion = peg_price;
        ApiResponse txFeeNTBPEGResponse = Global.exchange.getTrade().getTxFee(Global.options.getPair());
        if (txFeeNTBPEGResponse.isPositive()) {
            double buyPricePEGInitial;
            double sellPricePEGInitial;
            double txfee = (Double)txFeeNTBPEGResponse.getResponseObject();
            this.sellPriceUSD = 1.0 + 0.01 * txfee;
            if (!Global.options.isDualSide()) {
                this.sellPriceUSD += Global.options.getPriceIncrement();
            }
            this.buyPriceUSD = 1.0 - 0.01 * txfee;
            double halfSpread = Utils.round(Global.options.getSecondaryPegOptions().getSpread() / 2.0, 6);
            double offset = Utils.round(halfSpread / 100.0, 6);
            this.sellPriceUSD += offset;
            this.buyPriceUSD -= offset;
            String message = "Computing USD prices with spread " + Global.options.getSecondaryPegOptions().getSpread() + "%  : sell @ " + this.sellPriceUSD;
            if (Global.isDualSide) {
                message = message + " buy @ " + this.buyPriceUSD;
            }
            LOG.info(message);
            if (Global.swappedPair) {
                sellPricePEGInitial = Utils.round(Global.conversion * this.sellPriceUSD, 8);
                buyPricePEGInitial = Utils.round(Global.conversion * this.buyPriceUSD, 8);
            } else {
                sellPricePEGInitial = Utils.round(this.sellPriceUSD / peg_price, 8);
                buyPricePEGInitial = Utils.round(this.buyPriceUSD / peg_price, 8);
            }
            this.sellPricePEG_old = sellPricePEGInitial;
            String message2 = "Converted price (using 1 " + Global.options.getPair().getPaymentCurrency().getCode() + " = " + peg_price + " USD)" + " : sell @ " + sellPricePEGInitial + " " + Global.options.getPair().getPaymentCurrency().getCode() + "";
            if (Global.isDualSide) {
                message2 = message2 + "; buy @ " + buyPricePEGInitial + " " + Global.options.getPair().getPaymentCurrency().getCode();
            }
            LOG.info(message2);
            if (!Global.swappedPair) {
                ((StrategySecondaryPegTask)Global.taskManager.getSecondaryPegTask().getTask()).setBuyPricePEG(buyPricePEGInitial);
                ((StrategySecondaryPegTask)Global.taskManager.getSecondaryPegTask().getTask()).setSellPricePEG(sellPricePEGInitial);
            } else {
                ((StrategySecondaryPegTask)Global.taskManager.getSecondaryPegTask().getTask()).setBuyPricePEG(sellPricePEGInitial);
                ((StrategySecondaryPegTask)Global.taskManager.getSecondaryPegTask().getTask()).setSellPricePEG(buyPricePEGInitial);
            }
            Global.taskManager.getSecondaryPegTask().start();
            String title = " production (" + Global.options.getExchangeName() + ") [" + this.pfm.getPair().toString() + "] price tracking started";
            String tldr = this.pfm.getPair().getOrderCurrency().getCode().toUpperCase() + " price trackin started at " + peg_price + " " + this.pfm.getPair().getPaymentCurrency().getCode().toUpperCase() + ".\n" + "Will send a new mail notification everytime the price of " + this.pfm.getPair().getOrderCurrency().getCode().toUpperCase() + " changes more than " + Global.options.getSecondaryPegOptions().getWallchangeThreshold() + "%.";
            MailNotifications.send(Global.options.getMailRecipient(), title, tldr);
        } else {
            LOG.severe("Cannot get txFee : " + txFeeNTBPEGResponse.getError().getDescription());
            System.exit(0);
        }
    }

    public double getWallchangeThreshold() {
        return this.wallchangeThreshold;
    }

    public void setWallchangeThreshold(double wallchangeThreshold) {
        this.wallchangeThreshold = wallchangeThreshold;
    }

    public double getSellPriceUSD() {
        return this.sellPriceUSD;
    }

    public void setSellPriceUSD(double sellPriceUSD) {
        this.sellPriceUSD = sellPriceUSD;
    }

    public double getBuyPriceUSD() {
        return this.buyPriceUSD;
    }

    public void setBuyPriceUSD(double buyPriceUSD) {
        this.buyPriceUSD = buyPriceUSD;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
        this.jsonFile = this.outputPath.replace(".csv", ".json");
        File json = new File(this.jsonFile);
        if (!json.exists()) {
            JSONObject history = new JSONObject();
            JSONArray wall_shifts = new JSONArray();
            history.put("wall_shifts", wall_shifts);
            FileSystem.writeToFile(history.toJSONString(), this.jsonFile, true);
        }
    }

    public void setStrategy(StrategySecondaryPegTask strategy) {
        this.strategy = strategy;
    }

    public boolean isWallsBeingShifted() {
        return this.wallsBeingShifted;
    }

    public void setWallsBeingShifted(boolean wallsBeingShifted) {
        this.currentTime = System.currentTimeMillis();
        this.wallsBeingShifted = wallsBeingShifted;
    }

    public PriceFeedManager getPfm() {
        return this.pfm;
    }

    public void setPriceFeedManager(PriceFeedManager pfm) {
        this.pfm = pfm;
    }

    public double getDistanceTreshold() {
        return this.distanceTreshold;
    }

    public void setDistanceTreshold(double distanceTreshold) {
        this.distanceTreshold = distanceTreshold;
    }
}

