/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tasks;

import com.nubits.nubot.global.Global;
import com.nubits.nubot.notifications.HipChatNotifications;
import com.nubits.nubot.notifications.jhipchat.messages.Message;
import com.nubits.nubot.tasks.BotTask;
import com.nubits.nubot.tasks.CheckConnectionTask;
import com.nubits.nubot.tasks.CheckNudTask;
import com.nubits.nubot.tasks.NuPriceMonitorTask;
import com.nubits.nubot.tasks.SubmitLiquidityinfoTask;
import com.nubits.nubot.tasks.strategy.PriceMonitorTriggerTask;
import com.nubits.nubot.tasks.strategy.StrategyPrimaryPegTask;
import com.nubits.nubot.tasks.strategy.StrategySecondaryPegTask;
import java.util.ArrayList;
import java.util.logging.Logger;

public class TaskManager {
    private static final Logger LOG = Logger.getLogger(TaskManager.class.getName());
    private static final String STRATEGY_FIAT = "Strategy Fiat Task";
    private static final String STRATEGY_CRYPTO = "Strategy Crypto Task";
    protected int interval;
    private BotTask checkConnectionTask;
    private BotTask strategyFiatTask;
    private BotTask sendLiquidityTask;
    private BotTask checkNudTask;
    private BotTask priceMonitorTask;
    private BotTask secondaryPegTask;
    private BotTask priceTriggerTask;
    private ArrayList<BotTask> taskList = new ArrayList();
    private boolean running = false;
    private boolean initialized = false;

    public TaskManager() {
        int sendLiquidityInterval = Integer.parseInt(Global.settings.getProperty("submit_liquidity_seconds"));
        int executeStrategyInterval = 41;
        int checkPriceInterval = 61;
        boolean verbose = false;
        if (Global.options != null) {
            sendLiquidityInterval = Global.options.getSendLiquidityInteval();
            executeStrategyInterval = Global.options.getExecuteStrategyInterval();
            verbose = Global.options.isVerbose();
        }
        this.checkConnectionTask = new BotTask(new CheckConnectionTask(), 127L, "checkConnection");
        this.taskList.add(this.checkConnectionTask);
        this.sendLiquidityTask = new BotTask(new SubmitLiquidityinfoTask(verbose), sendLiquidityInterval, "sendLiquidity");
        this.taskList.add(this.sendLiquidityTask);
        this.checkNudTask = new BotTask(new CheckNudTask(), 30L, "checkNud");
        this.taskList.add(this.checkNudTask);
        this.strategyFiatTask = new BotTask(new StrategyPrimaryPegTask(), executeStrategyInterval, STRATEGY_FIAT);
        this.taskList.add(this.strategyFiatTask);
        this.secondaryPegTask = new BotTask(new StrategySecondaryPegTask(), executeStrategyInterval, STRATEGY_CRYPTO);
        this.taskList.add(this.secondaryPegTask);
        this.priceTriggerTask = new BotTask(new PriceMonitorTriggerTask(), checkPriceInterval, "priceTriggerTask");
        this.taskList.add(this.secondaryPegTask);
        this.priceMonitorTask = new BotTask(new NuPriceMonitorTask(), checkPriceInterval, STRATEGY_CRYPTO);
        this.taskList.add(this.priceMonitorTask);
        this.initialized = true;
    }

    public void startAll() {
        for (int i = 0; i < this.taskList.size(); ++i) {
            BotTask task = this.taskList.get(i);
            task.start();
        }
    }

    public void stopAll() {
        LOG.fine("\nStopping all tasks : -- ");
        boolean sentNotification = false;
        for (int i = 0; i < this.taskList.size(); ++i) {
            BotTask bt = this.taskList.get(i);
            if ((bt.getName().equals(STRATEGY_FIAT) || bt.getName().equals(STRATEGY_CRYPTO)) && !sentNotification) {
                String additionalInfo = "";
                if (Global.options != null) {
                    additionalInfo = Global.options.getExchangeName() + " " + Global.options.getPair().toString("_");
                }
                HipChatNotifications.sendMessage("Bot shut-down ( " + additionalInfo + " )", Message.Color.RED);
                sentNotification = true;
            }
            LOG.fine("Shutting down " + bt.getName());
            try {
                bt.getTimer().cancel();
                bt.getTimer().purge();
                continue;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
    }

    public void printTasksStatus() {
        for (int i = 0; i < this.taskList.size(); ++i) {
            BotTask task = this.taskList.get(i);
            LOG.fine("Task name : " + task.getName() + "" + " running : " + task.isRunning());
        }
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean isRunning) {
        this.running = isRunning;
    }

    public BotTask getCheckConnectionTask() {
        return this.checkConnectionTask;
    }

    public void setCheckConnectionTask(BotTask checkConnectionTask) {
        this.checkConnectionTask = checkConnectionTask;
    }

    public BotTask getStrategyFiatTask() {
        return this.strategyFiatTask;
    }

    public void setStrategyFiatTask(BotTask strategyFiatTask) {
        this.strategyFiatTask = strategyFiatTask;
    }

    public BotTask getSendLiquidityTask() {
        return this.sendLiquidityTask;
    }

    public BotTask getSecondaryPegTask() {
        return this.secondaryPegTask;
    }

    public void setSecondaryPegTask(BotTask secondaryPegTask) {
        this.secondaryPegTask = secondaryPegTask;
    }

    public BotTask getPriceTriggerTask() {
        return this.priceTriggerTask;
    }

    public void setPriceTriggerTask(BotTask priceTriggerTask) {
        this.priceTriggerTask = priceTriggerTask;
    }

    public void setSendLiquidityTask(BotTask slt) {
        this.sendLiquidityTask = slt;
    }

    public ArrayList<BotTask> getTaskList() {
        return this.taskList;
    }

    public void setTaskList(ArrayList<BotTask> taskList) {
        this.taskList = taskList;
    }

    public BotTask getCheckNudTask() {
        return this.checkNudTask;
    }

    public void setCheckNudTask(BotTask checkNudTask) {
        this.checkNudTask = checkNudTask;
    }

    public BotTask getPriceMonitorTask() {
        return this.priceMonitorTask;
    }

    public void setPriceMonitorTask(BotTask priceMonitorTask) {
        this.priceMonitorTask = priceMonitorTask;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

