/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tasks;

import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.LastPrice;
import com.nubits.nubot.notifications.HipChatNotifications;
import com.nubits.nubot.notifications.MailNotifications;
import com.nubits.nubot.notifications.jhipchat.messages.Message;
import com.nubits.nubot.pricefeeds.PriceFeedManager;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Logger;

public class NuPriceMonitorTask
extends TimerTask {
    private static final Logger LOG = Logger.getLogger(NuPriceMonitorTask.class.getName());
    private PriceFeedManager pfm = null;
    private double distanceTreshold;
    private LastPrice lastPrice;
    private boolean isFirstTime = true;
    private LastPrice currentWallPEGPrice;
    private double wallchangeThreshold;
    private double sellPriceUSDsingleside;
    private double sellPriceUSDdoubleside;
    private double buyPriceUSD;
    private String outputPath;
    private String recipient;
    private boolean sendEmails;
    private boolean isFirstEmail = true;
    private String emailHistory = "";

    @Override
    public void run() {
        LOG.info("Executing task : CheckLastPriceTask ");
        if (this.pfm == null) {
            LOG.severe("CheckLastPrice task needs a PriceFeedManager to work. Please assign it before running it");
        } else {
            ArrayList<LastPrice> priceList = this.pfm.getLastPrices().getPrices();
            LOG.info("CheckLastPrice received values from remote feeds. ");
            LOG.info("Positive response from " + priceList.size() + "/" + this.pfm.getFeedList().size() + " feeds");
            for (int i = 0; i < priceList.size(); ++i) {
                LastPrice tempPrice = priceList.get(i);
                LOG.info(tempPrice.getSource() + ":1 " + tempPrice.getCurrencyMeasured().getCode() + " = " + tempPrice.getPrice().getQuantity() + " " + tempPrice.getPrice().getCurrency().getCode());
            }
            if (priceList.size() == this.pfm.getFeedList().size()) {
                if (this.sanityCheck(priceList, 0)) {
                    this.updateLastPrice(priceList.get(0));
                } else {
                    boolean foundSomeValiBackUp = false;
                    LastPrice goodPrice = null;
                    for (int l = 1; l < priceList.size(); ++l) {
                        if (!this.sanityCheck(priceList, l)) continue;
                        goodPrice = priceList.get(l);
                        foundSomeValiBackUp = true;
                        break;
                    }
                    if (foundSomeValiBackUp) {
                        this.updateLastPrice(goodPrice);
                    } else if (Global.options != null) {
                        String title = "Problems while updating " + this.pfm.getPair().getOrderCurrency().getCode() + " price. Cannot find a reliable feed.";
                        String message = "Positive response from " + priceList.size() + "/" + this.pfm.getFeedList().size() + " feeds\n";
                        for (int i = 0; i < priceList.size(); ++i) {
                            LastPrice tempPrice = priceList.get(i);
                            message = message + tempPrice.getSource() + ":1 " + tempPrice.getCurrencyMeasured().getCode() + " = " + tempPrice.getPrice().getQuantity() + " " + tempPrice.getPrice().getCurrency().getCode() + "\n";
                        }
                        MailNotifications.send(Global.options.getMailRecipient(), title, message);
                        HipChatNotifications.sendMessage(title + message, Message.Color.RED);
                        LOG.severe(title + message);
                    }
                }
            }
        }
    }

    private boolean sanityCheck(ArrayList<LastPrice> priceList, int mainPriceIndex) {
        boolean[] ok = new boolean[priceList.size() - 1];
        double mainPrice = priceList.get(mainPriceIndex).getPrice().getQuantity();
        int f = 0;
        for (int i = 0; i < priceList.size(); ++i) {
            if (i == mainPriceIndex) continue;
            LastPrice tempPrice = priceList.get(i);
            double temp = tempPrice.getPrice().getQuantity();
            ok[f] = this.closeEnough(mainPrice, temp);
            ++f;
        }
        int countOk = 0;
        for (int j = 0; j < ok.length; ++j) {
            if (!ok[j]) continue;
            ++countOk;
        }
        boolean overallOk = false;
        if (ok.length % 2 == 0) {
            if (countOk >= ok.length / 2) {
                overallOk = true;
            }
        } else if (countOk > ok.length / 2) {
            overallOk = true;
        }
        return overallOk;
    }

    private boolean closeEnough(double mainPrice, double temp) {
        double distance = Math.abs(mainPrice - temp);
        double percentageDistance = Utils.round(distance * 100.0 / mainPrice, 4);
        return !(percentageDistance > this.distanceTreshold);
    }

    public PriceFeedManager getPfm() {
        return this.pfm;
    }

    public void setPriceFeedManager(PriceFeedManager pfm) {
        this.pfm = pfm;
    }

    public double getDistanceTreshold() {
        return this.distanceTreshold;
    }

    public void setDistanceTreshold(double distanceTreshold) {
        this.distanceTreshold = distanceTreshold;
    }

    public void updateLastPrice(LastPrice lp) {
        this.lastPrice = lp;
        LOG.info("Price Updated." + lp.getSource() + ":1 " + lp.getCurrencyMeasured().getCode() + " = " + "" + lp.getPrice().getQuantity() + " " + lp.getPrice().getCurrency().getCode() + "\n");
        this.tryMoveWalls();
    }

    public LastPrice getLastPriceFromFeeds() {
        return this.lastPrice;
    }

    private void tryMoveWalls() {
        LOG.info("Executing tryMoveWalls");
        String notificationEmail = "";
        if (this.isFirstTime) {
            this.currentWallPEGPrice = this.lastPrice;
            this.computePrices();
            notificationEmail = "First time wall-setup with PEGprice = " + this.currentWallPEGPrice.getPrice().getQuantity();
            LOG.info(notificationEmail);
        } else if (this.needToMoveWalls(this.lastPrice)) {
            LOG.severe("We should move the walls now!");
            this.currentWallPEGPrice = this.lastPrice;
            this.computePrices();
        } else {
            LOG.info("No need to move walls");
        }
        this.isFirstTime = false;
    }

    private boolean needToMoveWalls(LastPrice last) {
        double currentWallPEGprice = this.currentWallPEGPrice.getPrice().getQuantity();
        double distance = Math.abs(last.getPrice().getQuantity() - currentWallPEGprice);
        double percentageDistance = Utils.round(distance * 100.0 / currentWallPEGprice, 4);
        LOG.info("d=" + percentageDistance + "% (old : " + currentWallPEGprice + " new " + last.getPrice().getQuantity() + ")");
        return !(percentageDistance < this.wallchangeThreshold);
    }

    private void computePrices() {
        double peg_price = this.lastPrice.getPrice().getQuantity();
        double sellPricePEG = Utils.round(this.sellPriceUSDsingleside / peg_price, 8);
        double sellPricePEGdual = Utils.round(this.sellPriceUSDdoubleside / peg_price, 8);
        double buyPricePEG = Utils.round(this.buyPriceUSD / peg_price, 8);
        LOG.info("Sell wall prices: \nSell Price (sell-side custodians) " + sellPricePEG + "\n" + "Sell Price (dual-side custodians) " + sellPricePEGdual + "\n" + "Buy Price  " + buyPricePEG);
        String source = this.currentWallPEGPrice.getSource();
        double price = this.currentWallPEGPrice.getPrice().getQuantity();
        String currency = this.currentWallPEGPrice.getPrice().getCurrency().getCode();
        String crypto = this.pfm.getPair().getOrderCurrency().getCode();
        String row = new Date() + "," + source + "," + crypto + "," + price + "," + currency + "," + sellPricePEG + "," + sellPricePEGdual + "," + buyPricePEG + ",";
        String otherPricesAtThisTime = "";
        ArrayList<LastPrice> priceList = this.pfm.getLastPrices().getPrices();
        for (int i = 0; i < priceList.size(); ++i) {
            LastPrice tempPrice = priceList.get(i);
            otherPricesAtThisTime = otherPricesAtThisTime + "{ feed : " + tempPrice.getSource() + " - price : " + tempPrice.getPrice().getQuantity() + "}  ";
        }
        row = row + otherPricesAtThisTime + "\n";
        if (this.sendEmails) {
            String title = "[" + this.pfm.getPair().toString() + "] price changed more than " + this.wallchangeThreshold + "%";
            if (this.isFirstEmail) {
                title = "[" + this.pfm.getPair().toString() + "] price tracking started";
            }
            String messageNow = "timestamp,source,crypto,price,currency,sellprice,sellpricedoubleside,buyprice,otherfeeds\n" + row;
            this.emailHistory = this.emailHistory + messageNow;
            String tldr = this.pfm.getPair().toString() + " price changed more than " + this.wallchangeThreshold + "% since last notification: " + "now is " + price + " " + this.pfm.getPair().getPaymentCurrency().getCode().toUpperCase() + ".\n" + "Here are the prices you should used in the new orders : \n" + "If you are a sell-side custodian, sell at " + sellPricePEG + " " + this.pfm.getPair().getOrderCurrency().getCode().toUpperCase() + "\n" + "If you area dual-side custodian, sell at " + sellPricePEGdual + " " + this.pfm.getPair().getOrderCurrency().getCode().toUpperCase() + " " + "and buy at " + buyPricePEG + " " + this.pfm.getPair().getOrderCurrency().getCode().toUpperCase() + "\n" + "\n#########\n" + "Below you can see the history of price changes. You can copy paste to create a csv report." + "For each row you should have shifted the sell/buy walls.\n\n";
            if (this.isFirstEmail) {
                tldr = this.pfm.getPair().getOrderCurrency().getCode().toUpperCase() + " price is now " + price + " " + this.pfm.getPair().getPaymentCurrency().getCode() + "" + "(" + source + ").\n" + "Here are the prices you should used in the first order : \n" + "If you are a sell-side custodian, sell at " + sellPricePEG + " " + this.pfm.getPair().getOrderCurrency().getCode().toUpperCase() + "\n" + "If you area dual-side custodian, sell at " + sellPricePEGdual + " " + this.pfm.getPair().getOrderCurrency().getCode().toUpperCase() + " " + "and buy at " + buyPricePEG + " " + this.pfm.getPair().getOrderCurrency().getCode().toUpperCase() + ".\nDetails.csv below \n\n\n";
            }
            MailNotifications.send(this.recipient, title, tldr + this.emailHistory);
            this.isFirstEmail = false;
        }
        FileSystem.writeToFile(row, this.outputPath, true);
    }

    public double getWallchangeThreshold() {
        return this.wallchangeThreshold;
    }

    public void setWallchangeThreshold(double wallchangeThreshold) {
        this.wallchangeThreshold = wallchangeThreshold;
    }

    public double getSellPriceUSDsingleside() {
        return this.sellPriceUSDsingleside;
    }

    public void setSellPriceUSDsingleside(double sellPriceUSDsingleside) {
        this.sellPriceUSDsingleside = sellPriceUSDsingleside;
    }

    public double getSellPriceUSDdoubleside() {
        return this.sellPriceUSDdoubleside;
    }

    public void setSellPriceUSDdoubleside(double sellPriceUSDdoubleside) {
        this.sellPriceUSDdoubleside = sellPriceUSDdoubleside;
    }

    public double getBuyPriceUSD() {
        return this.buyPriceUSD;
    }

    public void setBuyPriceUSD(double buyPriceUSD) {
        this.buyPriceUSD = buyPriceUSD;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setSendEmails(boolean sendEmails) {
        this.sendEmails = sendEmails;
    }
}

