/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tasks;

import com.nubits.nubot.global.Global;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.TimerTask;
import java.util.logging.Logger;

public class CheckConnectionTask
extends TimerTask {
    private static final Logger LOG = Logger.getLogger(CheckConnectionTask.class.getName());

    @Override
    public void run() {
        String url = Global.exchange.getLiveData().getUrlConnectionCheck();
        Global.exchange.getLiveData().setConnected(this.isConnectedTo(url));
        LOG.fine("Checking connection to " + url + " -  Connected : " + Global.exchange.getLiveData().isConnected());
    }

    private boolean isConnectedTo(String url) {
        boolean connected = false;
        HttpURLConnection connection = null;
        URL query = null;
        try {
            query = new URL(url);
        }
        catch (MalformedURLException ex) {
            LOG.severe(ex.toString());
        }
        try {
            connection = (HttpURLConnection)query.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.getOutputStream();
            connected = true;
        }
        catch (NoRouteToHostException | UnknownHostException ex) {
            connected = false;
            LOG.severe(ex.toString());
        }
        catch (IOException ex) {
            connected = false;
            LOG.severe(ex.toString());
        }
        return connected;
    }
}

