/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.pricefeeds;

import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.LastPrice;
import com.nubits.nubot.pricefeeds.AbstractPriceFeed;
import com.nubits.nubot.utils.Utils;
import java.io.IOException;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class YahooPriceFeed
extends AbstractPriceFeed {
    private static final Logger LOG = Logger.getLogger(YahooPriceFeed.class.getName());

    public YahooPriceFeed() {
        this.name = "yahoo";
        this.refreshMinTime = 28800000L;
    }

    @Override
    public LastPrice getLastPrice(CurrencyPair pair) {
        long now = System.currentTimeMillis();
        long diff = now - this.lastRequest;
        if (diff >= this.refreshMinTime) {
            String htmlString;
            String url = this.getUrl(pair);
            try {
                htmlString = Utils.getHTML(url, true);
            }
            catch (IOException ex) {
                LOG.severe(ex.toString());
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
            JSONParser parser = new JSONParser();
            try {
                JSONObject httpAnswerJson = (JSONObject)parser.parse(htmlString);
                JSONObject query = (JSONObject)httpAnswerJson.get("query");
                JSONObject results = (JSONObject)query.get("results");
                JSONObject rate = (JSONObject)results.get("rate");
                double last = Utils.getDouble((String)rate.get("Rate"));
                this.lastRequest = System.currentTimeMillis();
                this.lastPrice = new LastPrice(false, this.name, pair.getOrderCurrency(), new Amount(last, pair.getPaymentCurrency()));
                return this.lastPrice;
            }
            catch (Exception ex) {
                LOG.severe(ex.toString());
                this.lastRequest = System.currentTimeMillis();
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
        }
        LOG.fine("Wait " + (this.refreshMinTime - (System.currentTimeMillis() - this.lastRequest)) + " ms " + "before making a new request. Now returning the last saved price\n\n");
        return this.lastPrice;
    }

    private String getUrl(CurrencyPair pair) {
        String pairString = pair.toString().toUpperCase();
        return "https://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20yahoo.finance.xchange%20where%20pair%20in%20(%22" + pairString + "%22)&format=json" + "&diagnostics=false&env=store%3A%2F%2Fdatatables.org%2Falltableswithkeys" + "&callback=";
    }
}

