/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.pricefeeds;

import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.LastPrice;
import com.nubits.nubot.pricefeeds.AbstractPriceFeed;
import com.nubits.nubot.utils.Utils;
import java.io.IOException;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OpenexchangeratesPriceFeed
extends AbstractPriceFeed {
    private static final Logger LOG = Logger.getLogger(OpenexchangeratesPriceFeed.class.getName());

    public OpenexchangeratesPriceFeed() {
        this.name = "openexchangerates";
        this.refreshMinTime = 28800000L;
    }

    @Override
    public LastPrice getLastPrice(CurrencyPair pair) {
        long now = System.currentTimeMillis();
        long diff = now - this.lastRequest;
        if (diff >= this.refreshMinTime) {
            String htmlString;
            String url = this.getUrl(pair);
            try {
                htmlString = Utils.getHTML(url, true);
            }
            catch (IOException ex) {
                LOG.severe(ex.toString());
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
            JSONParser parser = new JSONParser();
            boolean found = false;
            try {
                JSONObject httpAnswerJson = (JSONObject)parser.parse(htmlString);
                String lookingfor = pair.getOrderCurrency().getCode().toUpperCase();
                JSONObject rates = (JSONObject)httpAnswerJson.get("rates");
                this.lastRequest = System.currentTimeMillis();
                if (rates.containsKey(lookingfor)) {
                    double last = (Double)rates.get(lookingfor);
                    last = Utils.round(1.0 / last, 8);
                    this.lastPrice = new LastPrice(false, this.name, pair.getOrderCurrency(), new Amount(last, pair.getPaymentCurrency()));
                    return this.lastPrice;
                }
                LOG.warning("Cannot find currency :" + lookingfor + " on feed :" + this.name);
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
            catch (ParseException ex) {
                LOG.severe(ex.toString());
                this.lastRequest = System.currentTimeMillis();
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
        }
        LOG.fine("Wait " + (this.refreshMinTime - (System.currentTimeMillis() - this.lastRequest)) + " ms " + "before making a new request. Now returning the last saved price\n\n");
        return this.lastPrice;
    }

    private String getUrl(CurrencyPair pair) {
        String key = "534ac9e195c944c1a8924fa73b159313";
        return "https://openexchangerates.org/api/latest.json?app_id=" + key;
    }
}

