/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.pricefeeds;

import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.LastPrice;
import com.nubits.nubot.pricefeeds.AbstractPriceFeed;
import com.nubits.nubot.utils.Utils;
import java.io.IOException;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class BitstampPriceFeed
extends AbstractPriceFeed {
    private static final Logger LOG = Logger.getLogger(BitstampPriceFeed.class.getName());

    public BitstampPriceFeed() {
        this.name = "bitstamp";
        this.refreshMinTime = 58000L;
    }

    @Override
    public LastPrice getLastPrice(CurrencyPair pair) {
        long now = System.currentTimeMillis();
        long diff = now - this.lastRequest;
        if (diff >= this.refreshMinTime) {
            String htmlString;
            String url = "https://www.bitstamp.net/api/ticker/";
            try {
                htmlString = Utils.getHTML(url, true);
            }
            catch (IOException ex) {
                LOG.severe(ex.toString());
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
            JSONParser parser = new JSONParser();
            try {
                JSONObject httpAnswerJson = (JSONObject)parser.parse(htmlString);
                double last = Double.valueOf((String)httpAnswerJson.get("last"));
                last = Utils.round(last, 8);
                this.lastRequest = System.currentTimeMillis();
                this.lastPrice = new LastPrice(false, this.name, pair.getOrderCurrency(), new Amount(last, pair.getPaymentCurrency()));
                return this.lastPrice;
            }
            catch (Exception ex) {
                LOG.severe(ex.toString());
                this.lastRequest = System.currentTimeMillis();
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
        }
        LOG.fine("Wait " + (this.refreshMinTime - (System.currentTimeMillis() - this.lastRequest)) + " ms " + "before making a new request. Now returning the last saved price\n\n");
        return this.lastPrice;
    }
}

