/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.notifications.jhipchat.messages;

import com.nubits.nubot.notifications.jhipchat.HipChat;
import com.nubits.nubot.notifications.jhipchat.Room;
import com.nubits.nubot.notifications.jhipchat.UserId;
import com.nubits.nubot.notifications.jhipchat.UtilParser;
import com.nubits.nubot.notifications.jhipchat.messages.HistoryMessage;
import com.nubits.nubot.notifications.jhipchat.messages.UploadReference;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class MessageParser {
    public static List<HistoryMessage> parseRoomHistory(Room origin, InputStream input) throws JsonParseException, JsonMappingException, IOException {
        JsonParser jp = HipChat.JSON_FACTORY.createJsonParser(input);
        ObjectMapper mapper = new ObjectMapper();
        List<HistoryMessage> messages = null;
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String tag = jp.getText();
            if (!"messages".equals(tag)) continue;
            jp.nextToken();
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                HistoryMessage msg = MessageParser.parseHistoryMessage(origin, mapper, jp);
                if (messages == null) {
                    messages = new ArrayList<HistoryMessage>();
                }
                messages.add(msg);
            }
        }
        if (messages == null) {
            messages = Collections.emptyList();
        }
        return messages;
    }

    private static HistoryMessage parseHistoryMessage(Room origin, ObjectMapper mapper, JsonParser jp) throws JsonParseException, IOException {
        HistoryMessage result = null;
        String dateString = null;
        String fromName = null;
        Object fromUserId = null;
        String message = null;
        String fileName = null;
        Integer fileSize = null;
        String fileUrl = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String tag = jp.getText();
            jp.nextToken();
            if ("date".equals(tag)) {
                dateString = UtilParser.parseString(jp);
                continue;
            }
            if ("message".equals(tag)) {
                message = UtilParser.parseString(jp);
                continue;
            }
            if ("from".equals(tag)) {
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    tag = jp.getText();
                    jp.nextToken();
                    if ("user_id".equals(tag)) {
                        fromUserId = UtilParser.parseString(jp);
                        continue;
                    }
                    if ("name".equals(tag)) {
                        fromName = UtilParser.parseString(jp);
                        continue;
                    }
                    jp.skipChildren();
                }
                continue;
            }
            if (!"file".equals(tag)) continue;
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                tag = jp.getText();
                jp.nextToken();
                if ("size".equals(tag)) {
                    fileSize = jp.getIntValue();
                    continue;
                }
                if ("name".equals(tag)) {
                    fileName = UtilParser.parseString(jp);
                    continue;
                }
                if ("url".equals(tag)) {
                    fileUrl = UtilParser.parseString(jp);
                    continue;
                }
                jp.skipChildren();
            }
        }
        UserId from = UserId.create(fromUserId.toString(), fromName);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        Date date = null;
        try {
            date = sdf.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        UploadReference ref = null;
        if (fileName != null && fileName.length() > 0) {
            UploadReference.create(fileName, fileSize, fileUrl);
        }
        result = HistoryMessage.create(origin, from, message, date, ref);
        return result;
    }
}

