/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.notifications.jhipchat;

import com.nubits.nubot.notifications.jhipchat.HipChat;
import com.nubits.nubot.notifications.jhipchat.Room;
import com.nubits.nubot.notifications.jhipchat.UserId;
import com.nubits.nubot.notifications.jhipchat.UtilParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class RoomParser {
    public static List<Room> parseRoomList(HipChat origin, InputStream input) throws JsonParseException, JsonMappingException, IOException {
        JsonParser jp = HipChat.JSON_FACTORY.createJsonParser(input);
        ObjectMapper mapper = new ObjectMapper();
        List<Room> rooms = null;
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String tag = jp.getText();
            if (!"rooms".equals(tag)) continue;
            jp.nextToken();
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                Room r = RoomParser.parseRoom(origin, mapper, jp);
                if (rooms == null) {
                    rooms = new ArrayList<Room>();
                }
                rooms.add(r);
            }
        }
        if (rooms == null) {
            rooms = Collections.emptyList();
        }
        return rooms;
    }

    public static Room parseRoom(HipChat origin, InputStream input) throws JsonParseException, JsonMappingException, IOException {
        JsonParser jp = HipChat.JSON_FACTORY.createJsonParser(input);
        ObjectMapper mapper = new ObjectMapper();
        Room room = null;
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String tag = jp.getText();
            if (!"room".equals(tag)) continue;
            jp.nextToken();
            room = RoomParser.parseRoom(origin, mapper, jp);
        }
        return room;
    }

    private static Room parseRoom(HipChat origin, ObjectMapper mapper, JsonParser jp) throws JsonParseException, JsonMappingException, IOException {
        Room result = null;
        String roomId = null;
        String name = null;
        String topic = null;
        Integer lastActive = null;
        Integer created = null;
        String ownerId = null;
        Boolean isArchived = null;
        Boolean isPrivate = null;
        String xmppJId = null;
        String guestAccessUrl = null;
        ArrayList<UserId> participants = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String tag = jp.getText();
            jp.nextToken();
            if ("room_id".equals(tag)) {
                roomId = UtilParser.parseString(jp);
                continue;
            }
            if ("name".equals(tag)) {
                name = UtilParser.parseString(jp);
                continue;
            }
            if ("topic".equals(tag)) {
                topic = UtilParser.parseString(jp);
                continue;
            }
            if ("last_active".equals(tag)) {
                lastActive = jp.getIntValue();
                continue;
            }
            if ("created".equals(tag)) {
                created = jp.getIntValue();
                continue;
            }
            if ("owner_user_id".equals(tag)) {
                ownerId = UtilParser.parseString(jp);
                continue;
            }
            if ("is_archived".equals(tag)) {
                isArchived = jp.getBooleanValue();
                continue;
            }
            if ("is_private".equals(tag)) {
                isPrivate = jp.getBooleanValue();
                continue;
            }
            if ("xmpp_jid".equals(tag)) {
                xmppJId = UtilParser.parseString(jp);
                continue;
            }
            if ("guest_access_url".equals(tag)) {
                guestAccessUrl = UtilParser.parseString(jp);
                continue;
            }
            if (!"participants".equals(tag)) continue;
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                Object userId = null;
                String userName = null;
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    tag = jp.getText();
                    jp.nextToken();
                    if ("user_id".equals(tag)) {
                        userId = UtilParser.parseString(jp);
                        continue;
                    }
                    if (!"name".equals(tag)) continue;
                    userName = UtilParser.parseString(jp);
                }
                if (participants == null) {
                    participants = new ArrayList<UserId>();
                }
                participants.add(UserId.create(userId.toString(), userName));
            }
        }
        result = Room.create(roomId.toString(), origin, name, topic, lastActive.intValue(), created.intValue(), ownerId.toString(), isArchived, isPrivate, xmppJId, participants, guestAccessUrl);
        return result;
    }
}

