/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.notifications.jhipchat;

import com.nubits.nubot.notifications.jhipchat.Room;
import com.nubits.nubot.notifications.jhipchat.RoomParser;
import com.nubits.nubot.notifications.jhipchat.User;
import com.nubits.nubot.notifications.jhipchat.UserId;
import com.nubits.nubot.notifications.jhipchat.UserParser;
import com.nubits.nubot.notifications.jhipchat.UtilParser;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonFactory;

public class HipChat {
    public static JsonFactory JSON_FACTORY = new JsonFactory();
    private String authToken = null;

    public HipChat(String authToken) {
        this.authToken = authToken;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<Room> listRooms() {
        List<Room> results;
        block7: {
            String query = String.format("?format=%s&auth_token=%s", "json", this.authToken);
            InputStream input = null;
            results = null;
            HttpURLConnection connection = null;
            try {
                URL requestUrl = new URL("https://api.hipchat.com/v1/rooms/list" + query);
                connection = (HttpURLConnection)requestUrl.openConnection();
                connection.setDoInput(true);
                input = connection.getInputStream();
                results = RoomParser.parseRoomList(this, input);
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Room createRoom(String name, String ownerId, boolean isPrivate, String topic, boolean allowGuests) throws IOException {
        String query = String.format("?format=%s&auth_token=%s", "json", this.authToken);
        StringBuilder params = new StringBuilder();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Cannot create room with null or empty name");
        }
        params.append("name=");
        params.append(name);
        if (ownerId != null && ownerId.length() != 0) {
            params.append("&owner_user_id=");
            params.append(ownerId);
        }
        if (isPrivate) {
            params.append("&privacy=private");
        } else {
            params.append("&privacy=public");
        }
        if (topic != null && topic.length() != 0) {
            params.append("&topic=");
            params.append(topic);
        }
        if (allowGuests) {
            params.append("&guest_access=1");
        }
        String paramsToSend = params.toString();
        BufferedOutputStream output = null;
        InputStream input = null;
        Room result = null;
        HttpURLConnection connection = null;
        try {
            URL requestUrl = new URL("https://api.hipchat.com/v1/rooms/create" + query);
            connection = (HttpURLConnection)requestUrl.openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", Integer.toString(paramsToSend.getBytes().length));
            connection.setRequestProperty("Content-Language", "en-US");
            output = new BufferedOutputStream(connection.getOutputStream());
            IOUtils.write(paramsToSend, (OutputStream)output);
            IOUtils.closeQuietly(output);
            input = connection.getInputStream();
            result = RoomParser.parseRoom(this, input);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            connection.disconnect();
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        connection.disconnect();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean deleteRoom(String room_id) {
        boolean result;
        block8: {
            String query = String.format("?format=%s&auth_token=%s", "json", this.authToken);
            StringBuilder params = new StringBuilder();
            if (room_id == null || room_id.length() == 0) {
                throw new IllegalArgumentException("Cannot delete room with null or empty id");
            }
            params.append("room_id=");
            params.append(room_id);
            String paramsToSend = params.toString();
            BufferedOutputStream output = null;
            InputStream input = null;
            HttpURLConnection connection = null;
            result = false;
            try {
                URL requestUrl = new URL("https://api.hipchat.com/v1/rooms/delete" + query);
                connection = (HttpURLConnection)requestUrl.openConnection();
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", Integer.toString(paramsToSend.getBytes().length));
                connection.setRequestProperty("Content-Language", "en-US");
                output = new BufferedOutputStream(connection.getOutputStream());
                IOUtils.write(paramsToSend, (OutputStream)output);
                IOUtils.closeQuietly(output);
                input = connection.getInputStream();
                result = UtilParser.parseDeleteResult(input);
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Room getRoom(String roomId) {
        Room result;
        block7: {
            String query = String.format("?room_id=%s&format=%s&auth_token=%s", roomId, "json", this.authToken);
            InputStream input = null;
            result = null;
            HttpURLConnection connection = null;
            try {
                URL requestUrl = new URL("https://api.hipchat.com/v1/rooms/show" + query);
                connection = (HttpURLConnection)requestUrl.openConnection();
                connection.setDoInput(true);
                input = connection.getInputStream();
                result = RoomParser.parseRoom(this, input);
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
        }
        return result;
    }

    public User createUser(String email, String name, String title, boolean isGroupAdmin, String password, String timeZoneId) {
        TimeZone tz = TimeZone.getTimeZone(timeZoneId);
        return this.createUser(email, name, title, isGroupAdmin, password, tz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public User createUser(String email, String name, String title, boolean isGroupAdmin, String password, TimeZone timeZone) {
        User result;
        block15: {
            String query = String.format("?format=%s&auth_token=%s", "json", this.authToken);
            StringBuilder params = new StringBuilder();
            if (email == null || "".equals(email)) {
                throw new IllegalArgumentException("createUser: email cannot be null or empty");
            }
            params.append("email=");
            params.append(email);
            if (name == null || "".equals(name)) {
                throw new IllegalArgumentException("createUser: name cannot be null or empty");
            }
            if (!name.contains(" ")) {
                throw new IllegalArgumentException("createUser: name must contain a space separating first and last name");
            }
            params.append("&name=");
            params.append(name);
            if (title == null || "".equals(title)) {
                throw new IllegalArgumentException("createUser: title cannot be null or empty");
            }
            params.append("&title=");
            params.append(title);
            if (isGroupAdmin) {
                params.append("&is_group_admin=1");
            } else {
                params.append("&is_group_admin=0");
            }
            if (password != null && !"".equals(password)) {
                params.append("&password=");
                params.append(password);
            }
            if (timeZone != null) {
                String tz = timeZone.getID();
                params.append("&timezone=");
                params.append(tz);
            }
            String paramsToSend = params.toString();
            BufferedOutputStream output = null;
            InputStream input = null;
            HttpURLConnection connection = null;
            result = null;
            try {
                URL requestUrl = new URL("https://api.hipchat.com/v1/users/create" + query);
                connection = (HttpURLConnection)requestUrl.openConnection();
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", Integer.toString(paramsToSend.getBytes().length));
                connection.setRequestProperty("Content-Language", "en-US");
                output = new BufferedOutputStream(connection.getOutputStream());
                IOUtils.write(paramsToSend, (OutputStream)output);
                IOUtils.closeQuietly(output);
                input = connection.getInputStream();
                result = UserParser.parseUser(this, input);
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block15;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
        }
        return result;
    }

    public void updateUser(User user) {
        this.updateUser(user, user.getEmail(), user.getName(), user.getTitle(), user.isGroupAdmin, user.password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public User updateUser(UserId id, String email, String name, String title, boolean isGroupAdmin, String password, TimeZone timeZone) {
        User result;
        block16: {
            String query = String.format("?format=%s&auth_token=%s", "json", this.authToken);
            StringBuilder params = new StringBuilder();
            if (id == null) {
                throw new IllegalArgumentException("updateUser: id cannot be null");
            }
            params.append("user_id=");
            params.append(id.getId());
            if (email != null) {
                params.append("&email=");
                params.append(email);
            }
            if (name != null) {
                if (!name.contains(" ")) {
                    throw new IllegalArgumentException("updateUser: name must contain a space separating first and last name");
                }
                params.append("&name=");
                params.append(name);
            }
            if (title != null) {
                params.append("&title=");
                params.append(title);
            }
            if (isGroupAdmin) {
                params.append("&is_group_admin=1");
            } else {
                params.append("&is_group_admin=0");
            }
            if (password != null) {
                params.append("&password=");
                params.append(password);
            }
            if (timeZone != null) {
                String tz = timeZone.getID();
                params.append("&timezone=");
                params.append(tz);
            }
            String paramsToSend = params.toString();
            BufferedOutputStream output = null;
            InputStream input = null;
            HttpURLConnection connection = null;
            result = null;
            try {
                URL requestUrl = new URL("https://api.hipchat.com/v1/users/update" + query);
                connection = (HttpURLConnection)requestUrl.openConnection();
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", Integer.toString(paramsToSend.getBytes().length));
                connection.setRequestProperty("Content-Language", "en-US");
                output = new BufferedOutputStream(connection.getOutputStream());
                IOUtils.write(paramsToSend, (OutputStream)output);
                IOUtils.closeQuietly(output);
                input = connection.getInputStream();
                result = UserParser.parseUser(this, input);
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block16;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean deleteUser(UserId id) {
        boolean result;
        block8: {
            String query = String.format("?format=%s&auth_token=%s", "json", this.authToken);
            StringBuilder params = new StringBuilder();
            if (id == null) {
                throw new IllegalArgumentException("Cannot delete user with null or empty id");
            }
            params.append("user_id=");
            params.append(id.getId());
            String paramsToSend = params.toString();
            BufferedOutputStream output = null;
            InputStream input = null;
            HttpURLConnection connection = null;
            result = false;
            try {
                URL requestUrl = new URL("https://api.hipchat.com/v1/users/delete" + query);
                connection = (HttpURLConnection)requestUrl.openConnection();
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", Integer.toString(paramsToSend.getBytes().length));
                connection.setRequestProperty("Content-Language", "en-US");
                output = new BufferedOutputStream(connection.getOutputStream());
                IOUtils.write(paramsToSend, (OutputStream)output);
                IOUtils.closeQuietly(output);
                input = connection.getInputStream();
                result = UtilParser.parseDeleteResult(input);
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<User> listUsers() {
        List<User> results;
        block7: {
            String query = String.format("?format=%s&auth_token=%s", "json", this.authToken);
            InputStream input = null;
            results = null;
            HttpURLConnection connection = null;
            try {
                URL requestUrl = new URL("https://api.hipchat.com/v1/users/list" + query);
                connection = (HttpURLConnection)requestUrl.openConnection();
                connection.setDoInput(true);
                input = connection.getInputStream();
                results = UserParser.parseUserList(this, input);
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public User getUser(UserId id) {
        User result;
        block7: {
            String query = String.format("?user_id=%s&format=%s&auth_token=%s", id.getId(), "json", this.authToken);
            InputStream input = null;
            result = null;
            HttpURLConnection connection = null;
            try {
                URL requestUrl = new URL("https://api.hipchat.com/v1/users/show" + query);
                connection = (HttpURLConnection)requestUrl.openConnection();
                connection.setDoInput(true);
                input = connection.getInputStream();
                result = UserParser.parseUser(this, input);
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(input);
                connection.disconnect();
            }
        }
        return result;
    }
}

