/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.models;

import com.nubits.nubot.models.Currency;
import java.util.ArrayList;
import java.util.Objects;

public class CurrencyPair {
    private Currency orderCurrency;
    private Currency paymentCurrency;

    public CurrencyPair(Currency orderCurrency, Currency paymentCurrency) {
        this.orderCurrency = orderCurrency;
        this.paymentCurrency = paymentCurrency;
    }

    public static CurrencyPair getCurrencyPairFromString(String pairString, String sep) {
        String paymentCurrencyCode;
        String orderCurrencyCode;
        if (!sep.equals("")) {
            orderCurrencyCode = pairString.substring(0, pairString.indexOf(sep));
            paymentCurrencyCode = pairString.substring(pairString.indexOf(sep) + 1);
        } else {
            orderCurrencyCode = pairString.substring(0, 3);
            paymentCurrencyCode = pairString.substring(3);
        }
        Currency orderC = Currency.createCurrency(orderCurrencyCode);
        Currency paymentC = Currency.createCurrency(paymentCurrencyCode);
        return new CurrencyPair(orderC, paymentC);
    }

    public String toString(String sep) {
        return this.orderCurrency.getCode().toLowerCase() + sep + this.paymentCurrency.getCode().toLowerCase();
    }

    public String toString() {
        return this.orderCurrency.getCode().toLowerCase() + "" + this.paymentCurrency.getCode().toLowerCase();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CurrencyPair other = (CurrencyPair)obj;
        return Objects.equals(this.toString(), other.toString());
    }

    public Currency getOrderCurrency() {
        return this.orderCurrency;
    }

    public void setOrderCurrency(Currency currency1) {
        this.orderCurrency = currency1;
    }

    public Currency getPaymentCurrency() {
        return this.paymentCurrency;
    }

    public void setPaymentCurrency(Currency currency2) {
        this.paymentCurrency = currency2;
    }

    public boolean equals(CurrencyPair other) {
        String code1This = this.getOrderCurrency().getCode().toLowerCase();
        String code1Other = other.getOrderCurrency().getCode().toLowerCase();
        String code2This = this.getPaymentCurrency().getCode().toLowerCase();
        String code2Other = other.getPaymentCurrency().getCode().toLowerCase();
        return code1This.equals(code1Other) && code2This.equals(code2Other);
    }

    public static CurrencyPair swap(CurrencyPair regular) {
        return new CurrencyPair(regular.paymentCurrency, regular.orderCurrency);
    }

    public static boolean isFiat(String currencyCode) {
        boolean fiat = false;
        ArrayList<String> knownFiatList = new ArrayList<String>();
        knownFiatList.add("usd");
        knownFiatList.add("eur");
        knownFiatList.add("cny");
        knownFiatList.add("rur");
        knownFiatList.add("gbp");
        for (int i = 0; i < knownFiatList.size(); ++i) {
            if (!currencyCode.equalsIgnoreCase((String)knownFiatList.get(i))) continue;
            return true;
        }
        return fiat;
    }
}

