/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.launch;

import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.pricefeeds.PriceFeedManager;
import com.nubits.nubot.tasks.NuPriceMonitorTask;
import com.nubits.nubot.tasks.TaskManager;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import com.nubits.nubot.utils.logging.NuLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.simple.parser.JSONParser;

public class NuPriceMonitor {
    private static final Logger LOG = Logger.getLogger(NuPriceMonitor.class.getName());
    private static final String USAGE_STRING = "java  -jar NuPriceMonitor <path/to/options.json>";
    public static final String HEADER = "timestamp,source,crypto,price,currency,sellprice,sellpricedoubleside,buyprice,otherfeeds\n";
    private static Thread mainThread;
    int refreshTime;
    double tx_fee;
    double increment;
    double wallchangeTreshold;
    double priceOffset;
    double distanceTreshold;
    boolean emails;
    String recipient;
    String outputPath;
    String mainFeed;
    CurrencyPair pair;
    ArrayList<String> backupFeedNames;
    private String optionsPath;

    public static void main(String[] args) {
        mainThread = Thread.currentThread();
        Utils.loadProperties("settings.properties");
        String folderName = "NuPriceMonitor_" + System.currentTimeMillis() + "/";
        String logsFolder = Global.settings.getProperty("log_path") + folderName;
        FileSystem.mkdir(logsFolder);
        try {
            NuLogger.setup(false, logsFolder);
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
        NuPriceMonitor app = new NuPriceMonitor();
        if (app.readParams(args)) {
            NuPriceMonitor.createShutDownHook();
            app.init();
            LOG.fine("Launching NuCheckPrice ");
            app.exec();
        } else {
            System.exit(0);
        }
    }

    private void exec() {
        if (this.readOptions()) {
            this.init();
            PriceFeedManager pfm = new PriceFeedManager(this.mainFeed, this.backupFeedNames, this.pair);
            ((NuPriceMonitorTask)Global.taskManager.getPriceMonitorTask().getTask()).setPriceFeedManager(pfm);
            ((NuPriceMonitorTask)Global.taskManager.getPriceMonitorTask().getTask()).setDistanceTreshold(this.distanceTreshold);
            ((NuPriceMonitorTask)Global.taskManager.getPriceMonitorTask().getTask()).setWallchangeThreshold(this.wallchangeTreshold);
            ((NuPriceMonitorTask)Global.taskManager.getPriceMonitorTask().getTask()).setSendEmails(this.emails);
            ((NuPriceMonitorTask)Global.taskManager.getPriceMonitorTask().getTask()).setRecipient(this.recipient);
            double sellPriceUSDdoubleside = 1.0 + 0.01 * this.tx_fee;
            double sellPriceUSDsellside = sellPriceUSDdoubleside + this.increment;
            double buyPriceUSD = 1.0 - 0.01 * this.tx_fee;
            sellPriceUSDdoubleside += sellPriceUSDdoubleside / 100.0 * this.priceOffset;
            sellPriceUSDsellside += sellPriceUSDsellside / 100.0 * this.priceOffset;
            buyPriceUSD -= buyPriceUSD / 100.0 * this.priceOffset;
            LOG.fine("Computing USD pegs with offset " + this.priceOffset + "% (sell-side custodian) : sell @ " + sellPriceUSDsellside);
            LOG.fine("Computing USD pegs with offset " + this.priceOffset + "% (dual-side custodian) : sell @ " + sellPriceUSDdoubleside + " buy @ " + buyPriceUSD);
            ((NuPriceMonitorTask)Global.taskManager.getPriceMonitorTask().getTask()).setSellPriceUSDdoubleside(sellPriceUSDdoubleside);
            ((NuPriceMonitorTask)Global.taskManager.getPriceMonitorTask().getTask()).setSellPriceUSDsingleside(sellPriceUSDsellside);
            ((NuPriceMonitorTask)Global.taskManager.getPriceMonitorTask().getTask()).setBuyPriceUSD(buyPriceUSD);
            ((NuPriceMonitorTask)Global.taskManager.getPriceMonitorTask().getTask()).setOutputPath(this.outputPath);
            FileSystem.writeToFile(HEADER, this.outputPath, false);
            Global.taskManager.getPriceMonitorTask().setInterval(this.refreshTime);
            Global.taskManager.getPriceMonitorTask().start(2);
        } else {
            LOG.severe("Problem while reading options from " + this.optionsPath);
            System.exit(0);
        }
    }

    private boolean readOptions() {
        boolean ok = false;
        Object options = null;
        JSONParser parser = new JSONParser();
        String optionsString = FileSystem.readFromFile(this.optionsPath);
        try {
            JSONObject jsonString = new JSONObject(optionsString);
            JSONObject optionsJSON = (JSONObject)jsonString.get("options");
            String cp = (String)optionsJSON.get("pair");
            this.pair = CurrencyPair.getCurrencyPairFromString(cp, "_");
            this.outputPath = (String)optionsJSON.get("output-path");
            this.mainFeed = (String)optionsJSON.get("main-feed");
            this.backupFeedNames = new ArrayList();
            JSONObject dataJson = (JSONObject)optionsJSON.get("backup-feeds");
            String[] names = JSONObject.getNames(dataJson);
            if (names.length < 2) {
                LOG.severe("The bot requires at least two backup data feeds to run");
                System.exit(0);
            }
            for (int i = 0; i < names.length; ++i) {
                try {
                    JSONObject tempJson = dataJson.getJSONObject(names[i]);
                    this.backupFeedNames.add((String)tempJson.get("name"));
                    continue;
                }
                catch (JSONException ex) {
                    LOG.severe(ex.toString());
                    System.exit(0);
                }
            }
            this.tx_fee = new Double(optionsJSON.get("tx-fee").toString());
            this.increment = new Double(optionsJSON.get("increment").toString());
            this.wallchangeTreshold = new Double(optionsJSON.get("wallchange-treshold").toString());
            this.priceOffset = new Double(optionsJSON.get("price-offset").toString());
            this.distanceTreshold = new Double(optionsJSON.get("price-distance-threshold").toString());
            this.refreshTime = new Integer(optionsJSON.get("refresh-time").toString());
            this.emails = (Boolean)optionsJSON.get("emails");
            this.recipient = (String)optionsJSON.get("recipient");
            ok = true;
        }
        catch (NumberFormatException | JSONException ex) {
            LOG.severe(ex.toString());
        }
        return ok;
    }

    private boolean readParams(String[] args) {
        boolean ok = false;
        if (args.length != 1) {
            LOG.severe("wrong argument number : call it with \njava  -jar NuPriceMonitor <path/to/options.json>");
            System.exit(0);
        }
        this.optionsPath = args[0];
        ok = true;
        return ok;
    }

    private static void createShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.fine("Exiting...");
                mainThread.interrupt();
                Global.taskManager.stopAll();
                Thread.currentThread().interrupt();
            }
        }));
    }

    private void init() {
        System.setProperty("javax.net.ssl.trustStore", Global.settings.getProperty("keystore_path"));
        System.setProperty("javax.net.ssl.trustStorePassword", Global.settings.getProperty("keystore_pass"));
        Global.taskManager = new TaskManager();
    }
}

