/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.launch;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.exchanges.ExchangeLiveData;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.Trade;
import com.nubits.nubot.tasks.TaskManager;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.trading.wrappers.AllCoinWrapper;
import com.nubits.nubot.trading.wrappers.BitSparkWrapper;
import com.nubits.nubot.trading.wrappers.BtceWrapper;
import com.nubits.nubot.trading.wrappers.BterWrapper;
import com.nubits.nubot.trading.wrappers.CcedkWrapper;
import com.nubits.nubot.trading.wrappers.CcexWrapper;
import com.nubits.nubot.trading.wrappers.ExcoinWrapper;
import com.nubits.nubot.trading.wrappers.PeatioWrapper;
import com.nubits.nubot.trading.wrappers.PoloniexWrapper;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import com.nubits.nubot.utils.logging.NuLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class NuLastTrades {
    private static final Logger LOG = Logger.getLogger(NuLastTrades.class.getName());
    private final String USAGE_STRING = "java -jar NuLastTrades <exchange-name> <apikey> <apisecret> <currency_pair> [<date_from>]";
    private final String HEADER = "id,order_id,pair,type,price,amount,date";
    private String output;
    private String api;
    private String secret;
    private String exchangename;
    private long dateFrom;
    private CurrencyPair pair;
    private ApiKeys keys;

    public static void main(String[] args) {
        Utils.loadProperties("settings.properties");
        NuLastTrades app = new NuLastTrades();
        String folderName = "NuLastTrades_" + System.currentTimeMillis() + "/";
        String logsFolder = Global.settings.getProperty("log_path") + folderName;
        FileSystem.mkdir(logsFolder);
        if (app.readParams(args)) {
            try {
                NuLogger.setup(false, logsFolder);
            }
            catch (IOException ex) {
                LOG.severe(ex.toString());
            }
            LOG.info("Launching NuLastTrades on " + app.exchangename);
            app.prepareForExecution();
            app.execute();
            LOG.info("Done");
            System.exit(0);
        } else {
            System.exit(0);
        }
    }

    private void prepareForExecution() {
        this.keys = new ApiKeys(this.secret, this.api);
        Global.exchange = new Exchange(this.exchangename);
        ExchangeLiveData liveData = new ExchangeLiveData();
        Global.exchange.setLiveData(liveData);
        if (this.exchangename.equals("btce")) {
            Global.exchange.setTrade(new BtceWrapper(this.keys, Global.exchange));
        } else if (this.exchangename.equals("peatio")) {
            Global.exchange.setTrade(new PeatioWrapper(this.keys, Global.exchange, "http://178.62.186.229/"));
        } else if (this.exchangename.equals("ccedk")) {
            Global.exchange.setTrade(new CcedkWrapper(this.keys, Global.exchange));
        } else if (this.exchangename.equals("bter")) {
            Global.exchange.setTrade(new BterWrapper(this.keys, Global.exchange));
        } else if (this.exchangename.equals("allcoin")) {
            Global.exchange.setTrade(new AllCoinWrapper(this.keys, Global.exchange));
        } else if (this.exchangename.equals("bitspark")) {
            Global.exchange.setTrade(new BitSparkWrapper(this.keys, Global.exchange));
        } else if (this.exchangename.equals("poloniex")) {
            Global.exchange.setTrade(new PoloniexWrapper(this.keys, Global.exchange));
        } else if (this.exchangename.equals("ccex")) {
            Global.exchange.setTrade(new CcexWrapper(this.keys, Global.exchange));
        } else if (this.exchangename.equals("excoin")) {
            Global.exchange.setTrade(new ExcoinWrapper(this.keys, Global.exchange));
        } else {
            LOG.severe("Exchange " + this.exchangename + " not supported");
            System.exit(0);
        }
        Global.exchange.getLiveData().setUrlConnectionCheck(Global.exchange.getTrade().getUrlConnectionCheck());
        Global.taskManager = new TaskManager();
        Global.taskManager.getCheckConnectionTask().start();
        LOG.fine("Exchange setup complete. Now checking connection ...");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            LOG.severe(ex.toString());
        }
    }

    private boolean readParams(String[] args) {
        boolean ok = false;
        if (args.length != 4 && args.length != 5) {
            LOG.severe("wrong argument number : call it with \njava -jar NuLastTrades <exchange-name> <apikey> <apisecret> <currency_pair> [<date_from>]");
            System.exit(0);
        }
        this.exchangename = args[0];
        this.api = args[1];
        this.secret = args[2];
        this.pair = CurrencyPair.getCurrencyPairFromString(args[3], "_");
        if (args.length == 5) {
            this.dateFrom = Long.parseLong(args[4]);
        }
        this.output = "last_trades_" + this.exchangename + "_" + this.pair.toString() + ".json";
        ok = true;
        return ok;
    }

    private void execute() {
        ApiResponse activeOrdersResponse = Global.exchange.getTrade().getLastTrades(this.pair, this.dateFrom);
        if (activeOrdersResponse.isPositive()) {
            ArrayList tradeList = (ArrayList)activeOrdersResponse.getResponseObject();
            FileSystem.writeToFile("{\n", this.output, false);
            LOG.info("Last trades : " + tradeList.size());
            for (int i = 0; i < tradeList.size(); ++i) {
                Trade tempTrade = (Trade)tradeList.get(i);
                LOG.info(tempTrade.toString());
                String comma = ",\n";
                if (i == tradeList.size() - 1) {
                    comma = "";
                }
                FileSystem.writeToFile(tempTrade.toJSONString() + comma, this.output, true);
            }
            FileSystem.writeToFile("}", this.output, true);
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
        }
    }
}

