/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.launch;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.exchanges.ExchangeLiveData;
import com.nubits.nubot.global.Constant;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.ApiError;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.tasks.TaskManager;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.trading.wrappers.PeatioWrapper;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import com.nubits.nubot.utils.logging.NuLogger;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class NuExecuteOrders {
    private static final Logger LOG = Logger.getLogger(NuExecuteOrders.class.getName());
    private String api;
    private String secret;
    private String pathToOrders;
    private String exchangename;
    private ArrayList<CsvLine> orderList;
    private ApiKeys keys;
    private static Thread mainThread;
    private static final String USAGE_STRING = "java -jar OrderBot <apikey> <secretkey> <exchange-name> <path/to/orders.csv>";

    public static void main(String[] args) {
        Utils.loadProperties("settings.properties");
        mainThread = Thread.currentThread();
        String folderName = "NuExecuteOrders_" + System.currentTimeMillis() + "/";
        String logsFolder = Global.settings.getProperty("log_path") + folderName;
        FileSystem.mkdir(logsFolder);
        try {
            NuLogger.setup(true, logsFolder);
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
        NuExecuteOrders app = new NuExecuteOrders();
        if (app.readParams(args)) {
            NuExecuteOrders.createShutDownHook();
            LOG.fine("Launching NuOrderExecutor ");
            app.orderList = app.readOrdersFromFile();
            app.prepareForExecution();
            app.executeOrders();
            LOG.fine("Done");
            System.exit(0);
        } else {
            System.exit(0);
        }
    }

    private void executeOrders() {
        Utils.printSeparator();
        for (int i = 0; i < this.orderList.size(); ++i) {
            ApiResponse respose = this.orderList.get(i).execute();
            if (respose.isPositive()) {
                String resposeString = (String)respose.getResponseObject();
                LOG.warning("Orders submitted . Response = " + resposeString);
                Utils.printSeparator();
                continue;
            }
            LOG.severe(respose.getError().toString());
        }
    }

    private void prepareForExecution() {
        this.keys = new ApiKeys(this.secret, this.api);
        Global.exchange = new Exchange(this.exchangename);
        ExchangeLiveData liveData = new ExchangeLiveData();
        Global.exchange.setLiveData(liveData);
        String apibase = "";
        if (this.exchangename.equalsIgnoreCase("peatio")) {
            apibase = "http://178.62.186.229/";
        } else {
            LOG.severe("Exchange name not accepted : " + this.exchangename);
            System.exit(0);
        }
        Global.exchange.setTrade(new PeatioWrapper(this.keys, Global.exchange, apibase));
        Global.exchange.getLiveData().setUrlConnectionCheck(Global.exchange.getTrade().getUrlConnectionCheck());
        Global.taskManager = new TaskManager();
        Global.taskManager.getCheckConnectionTask().start();
        LOG.fine("Exchange setup complete. Now checking connection ...");
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException ex) {
            LOG.severe(ex.toString());
        }
    }

    private boolean readParams(String[] args) {
        boolean ok = false;
        if (args.length != 4) {
            LOG.severe("wrong argument number : call it with \njava -jar OrderBot <apikey> <secretkey> <exchange-name> <path/to/orders.csv>");
            System.exit(0);
        }
        this.api = args[0];
        this.secret = args[1];
        this.exchangename = args[2];
        this.pathToOrders = args[3];
        ok = true;
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<CsvLine> readOrdersFromFile() {
        BufferedReader br = null;
        String line = "";
        String cvsSplitBy = ",";
        ArrayList<CsvLine> list = new ArrayList<CsvLine>();
        try {
            br = new BufferedReader(new FileReader(this.pathToOrders));
            while ((line = br.readLine()) != null) {
                String[] order = line.split(cvsSplitBy);
                CsvLine csvline = new CsvLine(order[0], Double.valueOf(order[1]), Double.valueOf(order[2]), Long.valueOf(order[3]));
                list.add(csvline);
                LOG.fine("Order " + list.size() + " loaded from file : " + csvline.toString());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    private static void createShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.fine("Exiting...");
                mainThread.interrupt();
                Global.taskManager.stopAll();
                Thread.currentThread().interrupt();
            }
        }));
    }

    protected class CsvLine {
        private String type;
        private double amount;
        private double price;
        private long delay;

        public CsvLine(String type, double amount, double price, long delay) {
            this.type = type;
            this.amount = amount;
            this.price = price;
            this.delay = delay;
        }

        public ApiResponse execute() {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException ex) {
                LOG.severe(ex.toString());
            }
            LOG.warning("\nExecuting " + this.toString());
            switch (this.type) {
                case "sell": {
                    return Global.exchange.getTrade().sell(Constant.BTC_CNY, this.amount, this.price);
                }
                case "buy": {
                    return Global.exchange.getTrade().buy(Constant.BTC_CNY, this.amount, this.price);
                }
            }
            return new ApiResponse(false, null, new ApiError(2311, "Unrecognized order type (" + this.getType() + "). " + "it can either be buy or sell"));
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public double getAmount() {
            return this.amount;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public double getPrice() {
            return this.price;
        }

        public void setPrice(double price) {
            this.price = price;
        }

        public long getDelay() {
            return this.delay;
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }

        public String toString() {
            return "amount " + this.amount + " " + "delay " + this.delay + " " + "price " + this.price + " " + "type " + this.type;
        }
    }
}

