/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.launch;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.exchanges.ExchangeLiveData;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.tasks.TaskManager;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.trading.wrappers.PeatioWrapper;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import com.nubits.nubot.utils.logging.NuLogger;
import java.io.IOException;
import java.util.logging.Logger;

public class NuCancelOrders {
    private static final Logger LOG = Logger.getLogger(NuCancelOrders.class.getName());
    private String api;
    private String secret;
    private String exchangename;
    private CurrencyPair pair;
    private ApiKeys keys;
    public static final String USAGE_STRING = "java -jar NuCancelOrders <apikey> <secretkey> <exchange-name> <pair>";

    public static void main(String[] args) {
        Utils.loadProperties("settings.properties");
        NuCancelOrders app = new NuCancelOrders();
        String folderName = "NuCancelOrders_" + System.currentTimeMillis() + "/";
        String logsFolder = Global.settings.getProperty("log_path") + folderName;
        FileSystem.mkdir(logsFolder);
        if (app.readParams(args)) {
            try {
                NuLogger.setup(false, logsFolder);
            }
            catch (IOException ex) {
                LOG.severe(ex.toString());
            }
            LOG.fine("Launching CancellAllOrders ");
            app.prepareForExecution();
            app.cancelAllOrders(app.pair);
            LOG.fine("Done");
            System.exit(0);
        } else {
            System.exit(0);
        }
    }

    private void cancelAllOrders(CurrencyPair pair) {
        ApiResponse deleteOrdersResponse = Global.exchange.getTrade().clearOrders(pair);
        if (deleteOrdersResponse.isPositive()) {
            boolean deleted = (Boolean)deleteOrdersResponse.getResponseObject();
            if (deleted) {
                LOG.fine("Clear request succesfully");
            } else {
                LOG.fine("Could not submit request to clear orders");
            }
        } else {
            LOG.severe(deleteOrdersResponse.getError().toString());
        }
        System.exit(0);
    }

    private void prepareForExecution() {
        this.keys = new ApiKeys(this.secret, this.api);
        Global.exchange = new Exchange(this.exchangename);
        String apibase = "";
        if (this.exchangename.equalsIgnoreCase("peatio")) {
            apibase = "http://178.62.186.229/";
        } else {
            LOG.severe("Exchange name not accepted : " + this.exchangename);
            System.exit(0);
        }
        ExchangeLiveData liveData = new ExchangeLiveData();
        Global.exchange.setLiveData(liveData);
        Global.exchange.setTrade(new PeatioWrapper(this.keys, Global.exchange, apibase));
        Global.exchange.getLiveData().setUrlConnectionCheck(Global.exchange.getTrade().getUrlConnectionCheck());
        Global.taskManager = new TaskManager();
        Global.taskManager.getCheckConnectionTask().start();
        LOG.fine("Exchange setup complete. Now checking connection ...");
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException ex) {
            LOG.severe(ex.toString());
        }
    }

    private boolean readParams(String[] args) {
        boolean ok = false;
        if (args.length != 4) {
            LOG.severe("wrong argument number : call it with \njava -jar NuCancelOrders <apikey> <secretkey> <exchange-name> <pair>");
            System.exit(0);
        }
        this.api = args[0];
        this.secret = args[1];
        this.exchangename = args[2];
        this.pair = CurrencyPair.getCurrencyPairFromString(args[3], "_");
        ok = true;
        return ok;
    }
}

