/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.exchanges;

import com.nubits.nubot.exchanges.ExchangeLiveData;
import com.nubits.nubot.trading.TradeInterface;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.trading.wrappers.AllCoinWrapper;
import com.nubits.nubot.trading.wrappers.BitSparkWrapper;
import com.nubits.nubot.trading.wrappers.BitcoinCoIDWrapper;
import com.nubits.nubot.trading.wrappers.BtceWrapper;
import com.nubits.nubot.trading.wrappers.BterWrapper;
import com.nubits.nubot.trading.wrappers.CcedkWrapper;
import com.nubits.nubot.trading.wrappers.CcexWrapper;
import com.nubits.nubot.trading.wrappers.ExcoinWrapper;
import com.nubits.nubot.trading.wrappers.PeatioWrapper;
import com.nubits.nubot.trading.wrappers.PoloniexWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Exchange {
    private static final Logger LOG = Logger.getLogger(Exchange.class.getName());
    private String name;
    private ExchangeLiveData exchangeLiveData;
    private ApiKeys keys;
    private TradeInterface trade;
    private static HashMap<String, TradeInterface> supportedExchanges = new HashMap();

    public static boolean isSupported(String name) {
        supportedExchanges.put("btce", new BtceWrapper());
        supportedExchanges.put("peatio", new PeatioWrapper());
        supportedExchanges.put("bter", new BterWrapper());
        supportedExchanges.put("ccedk", new CcedkWrapper());
        supportedExchanges.put("poloniex", new PoloniexWrapper());
        supportedExchanges.put("ccex", new CcexWrapper());
        supportedExchanges.put("allcoin", new AllCoinWrapper());
        supportedExchanges.put("bitspark", new BitSparkWrapper());
        supportedExchanges.put("excoin", new ExcoinWrapper());
        supportedExchanges.put("bitcoincoid", new BitcoinCoIDWrapper());
        for (Map.Entry<String, TradeInterface> pairs : supportedExchanges.entrySet()) {
            if (!name.equalsIgnoreCase(pairs.getKey())) continue;
            return true;
        }
        return false;
    }

    public Exchange(String name) {
        if (Exchange.isSupported(name)) {
            this.name = name;
            this.exchangeLiveData = new ExchangeLiveData();
        } else {
            LOG.severe("Nubot doesn't support exchange named : " + name);
            Exchange.listSupportedExchanges();
            System.exit(0);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExchangeLiveData getLiveData() {
        return this.exchangeLiveData;
    }

    public void setLiveData(ExchangeLiveData exchangeLiveData) {
        this.exchangeLiveData = exchangeLiveData;
    }

    public ApiKeys getKeys() {
        return this.keys;
    }

    public void setKeys(ApiKeys keys) {
        this.keys = keys;
    }

    public TradeInterface getTrade() {
        return this.trade;
    }

    public void setTrade(TradeInterface trade) {
        this.trade = trade;
    }

    public ExchangeLiveData getExchangeLiveData() {
        return this.exchangeLiveData;
    }

    public void setExchangeLiveData(ExchangeLiveData exchangeLiveData) {
        this.exchangeLiveData = exchangeLiveData;
    }

    private static void listSupportedExchanges() {
        String infoString = "Accepted values for exchange name :";
        for (Map.Entry<String, TradeInterface> pairs : supportedExchanges.entrySet()) {
            infoString = infoString + pairs.getKey() + " ; ";
        }
        LOG.info(infoString);
    }

    public static TradeInterface getTradeInterface(String name) {
        TradeInterface ti = null;
        if (supportedExchanges.containsKey(name)) {
            return supportedExchanges.get(name);
        }
        LOG.severe("Cannot find the trading interface for " + name);
        System.exit(0);
        return ti;
    }
}

