/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.RPC;

import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.CurrencyPair;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NuRPCClient {
    private static final Logger LOG = Logger.getLogger(NuRPCClient.class.getName());
    public static final String USDchar = "B";
    private static final String COMMAND_GET_INFO = "getinfo";
    private static final String COMMAND_LIQUIDITYINFO = "liquidityinfo";
    private static final String COMMAND_GETLIQUIDITYINFO = "getliquidityinfo";
    private String ip;
    private int port;
    private String rpcUsername;
    private String rpcPassword;
    private boolean connected;
    private boolean verbose;
    private boolean useIdentifier;
    private String identifier;
    private String custodianPublicAddress;
    private String exchangeName;
    private CurrencyPair pair;

    public NuRPCClient(String ip, int port, String rpcUser, String rpcPass, boolean verbose, boolean useIdentifier, String custodianPublicAddress, CurrencyPair pair, String exchangeName) {
        this.ip = ip;
        this.port = port;
        this.rpcPassword = rpcPass;
        this.rpcUsername = rpcUser;
        this.verbose = verbose;
        this.useIdentifier = useIdentifier;
        this.custodianPublicAddress = custodianPublicAddress;
        this.pair = pair;
        this.exchangeName = exchangeName;
        if (useIdentifier) {
            this.identifier = this.generateIdentifier();
        }
    }

    public JSONObject submitLiquidityInfo(String currencyChar, double buyamount, double sellamount, int tier) {
        List<Serializable> params = this.useIdentifier ? Arrays.asList(currencyChar, buyamount, sellamount, this.custodianPublicAddress, this.identifier + "_tier_" + tier) : Arrays.asList(currencyChar, buyamount, sellamount, this.custodianPublicAddress);
        LOG.fine("RPC parameters " + params.toString());
        JSONObject json = this.invokeRPC(UUID.randomUUID().toString(), COMMAND_LIQUIDITYINFO, params);
        if (json != null) {
            if (json.get("null") == null) {
                LOG.fine("RPC : Liquidity info submitted correctly.");
                JSONObject jo = new JSONObject();
                jo.put("submitted", true);
                return jo;
            }
            if ((JSONObject)json.get("result") != null) {
                return (JSONObject)json.get("result");
            }
            return (JSONObject)json.get("error");
        }
        return new JSONObject();
    }

    public JSONObject getLiquidityInfo(String currency) {
        List<String> params = Arrays.asList(currency);
        JSONObject json = this.invokeRPC(UUID.randomUUID().toString(), COMMAND_GETLIQUIDITYINFO, params);
        if (json != null) {
            if ((JSONObject)json.get("result") != null) {
                return (JSONObject)json.get("result");
            }
            return (JSONObject)json.get("error");
        }
        return new JSONObject();
    }

    public double getLiquidityInfo(String currency, String type, String address) {
        Object toReturn = null;
        List<String> params = Arrays.asList(currency);
        JSONObject json = this.invokeRPC(UUID.randomUUID().toString(), COMMAND_GETLIQUIDITYINFO, params);
        if (json != null) {
            if ((JSONObject)json.get("result") != null) {
                JSONObject result = (JSONObject)json.get("result");
                JSONObject total = (JSONObject)result.get(address);
                double toRet = -1.0;
                if (type.equalsIgnoreCase("SELL")) {
                    toRet = (Double)total.get("sell");
                } else if (type.equalsIgnoreCase("BUY")) {
                    toRet = (Double)total.get("buy");
                } else {
                    LOG.severe("The type can be either buy or sell");
                }
                return toRet;
            }
            LOG.severe(((JSONObject)json.get("error")).toString());
            return 0.0;
        }
        LOG.severe("getliquidityinfo returned null");
        return -1.0;
    }

    public JSONObject getInfo() {
        JSONObject json = this.invokeRPC(UUID.randomUUID().toString(), COMMAND_GET_INFO, null);
        if (json != null) {
            return (JSONObject)json.get("result");
        }
        return new JSONObject();
    }

    public void checkConnection() {
        long lockedUntil;
        boolean conn = false;
        JSONObject responseObject = Global.rpcClient.getInfo();
        if (responseObject.get("blocks") != null) {
            conn = true;
        }
        boolean locked = false;
        if (responseObject.containsKey("unlocked_until") && (lockedUntil = ((Long)responseObject.get("unlocked_until")).longValue()) == 0L) {
            LOG.warning("Nu client is locked and will not be able to submit liquidity info.\nUse walletpassphrase <yourpassphrase> 9999999 to unlock it");
        }
        this.setConnected(conn);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRpcUsername() {
        return this.rpcUsername;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setRpcUsername(String rpcUsername) {
        this.rpcUsername = rpcUsername;
    }

    public String getRpcPassword() {
        return this.rpcPassword;
    }

    public void setRpcPassword(String rpcPassword) {
        this.rpcPassword = rpcPassword;
    }

    private void setConnected(boolean connected) {
        this.connected = connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject invokeRPC(String id, String method, List params) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        JSONObject json = new JSONObject();
        json.put("id", id);
        json.put("method", method);
        if (null != params) {
            JSONArray array = new JSONArray();
            array.addAll(params);
            json.put("params", params);
        }
        JSONObject responseJsonObj = null;
        try {
            httpclient.getCredentialsProvider().setCredentials(new AuthScope(this.ip, this.port), new UsernamePasswordCredentials(this.rpcUsername, this.rpcPassword));
            StringEntity myEntity = new StringEntity(json.toJSONString());
            if (this.verbose) {
                LOG.fine("RPC : " + json.toString());
            }
            HttpPost httppost = new HttpPost("http://" + this.ip + ":" + this.port);
            httppost.setEntity(myEntity);
            if (this.verbose) {
                LOG.fine("RPC executing request :" + httppost.getRequestLine());
            }
            CloseableHttpResponse response = httpclient.execute(httppost);
            HttpEntity entity = response.getEntity();
            if (this.verbose) {
                LOG.fine("RPC----------------------------------------");
                LOG.fine("" + response.getStatusLine());
                if (entity != null) {
                    LOG.fine("RPC : Response content length: " + entity.getContentLength());
                }
            }
            JSONParser parser = new JSONParser();
            String entityString = EntityUtils.toString(entity);
            LOG.fine("Entity = " + entityString);
            responseJsonObj = (JSONObject)parser.parse(entityString);
        }
        catch (ClientProtocolException e) {
            LOG.severe(e.toString());
        }
        catch (IOException e) {
            LOG.severe(e.toString());
        }
        catch (ParseException ex) {
            Logger.getLogger(NuRPCClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return responseJsonObj;
    }

    private String generateIdentifier() {
        String id = Global.sessionId + "_" + this.exchangeName + "_" + this.pair.toString().toUpperCase();
        return id;
    }
}

