/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.NTP;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import org.apache.commons.net.time.TimeUDPClient;

public final class NTPClient {
    private static final Logger LOG = Logger.getLogger(NTPClient.class.getName());
    private ArrayList<String> hostnames;
    private static final int TIMEOUT = 10000;

    private void initHosts() {
        this.hostnames = new ArrayList();
        this.hostnames.add("ntp.xs4all.nl");
        this.hostnames.add("nist1-pa.ustiming.org");
        this.hostnames.add("nist-time-server.eoni.com");
        this.hostnames.add("time.nist.gov");
        this.hostnames.add("utcnist.colorado.edu");
        this.hostnames.add("nist.time.nosc.us");
    }

    public Date getTime(String host) {
        try {
            return this.getTimeImpl(host);
        }
        catch (IOException ex) {
            LOG.severe("Cannot read the date from the time server " + host + "\n" + ex.toString());
            return new Date();
        }
    }

    public Date getTime() {
        this.initHosts();
        boolean found = false;
        for (int i = 0; i < this.hostnames.size(); ++i) {
            try {
                return this.getTimeImpl(this.hostnames.get(i));
            }
            catch (IOException ex) {
                LOG.warning("Problem with timeserver " + this.hostnames.get(i) + "" + "\n" + ex.toString());
                if (i == this.hostnames.size() - 1) continue;
                LOG.info("Trying next server");
                continue;
            }
        }
        if (!found) {
            LOG.severe("Cannot update time after querying " + this.hostnames.size() + " timeservers. ");
            System.exit(0);
        }
        return new Date();
    }

    private Date getTimeImpl(String host) throws IOException {
        TimeUDPClient client = new TimeUDPClient();
        client.setDefaultTimeout(10000);
        client.open();
        Date toRet = client.getDate(InetAddress.getByName(host));
        client.close();
        return toRet;
    }
}

