/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.trading.wrappers;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiError;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Balance;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.models.Trade;
import com.nubits.nubot.trading.ServiceInterface;
import com.nubits.nubot.trading.Ticker;
import com.nubits.nubot.trading.TradeInterface;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.utils.ErrorManager;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Hex;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ExcoinWrapper
implements TradeInterface {
    private static final Logger LOG = Logger.getLogger(ExcoinWrapper.class.getName());
    private ApiKeys keys;
    private Exchange exchange;
    private final String SIGN_HASH_FUNCTION = "HmacSHA256";
    private final String ENCODING = "UTF-8";
    private final int EXPIRE_TIMESTAMP = 900;
    private String apiBaseUrl;
    private String checkConnectionUrl;
    private final String API_BASE_URL = "https://api.exco.in/v1";
    private final String API_ACCOUNT = "account";
    private final String API_EXCHANGE = "exchange";
    private final String API_SUMMARY = "summary";
    private final String API_TRADES = "trades";
    private final String API_ORDERS = "orders";
    private final String API_TRADE = "issue";
    private final String API_ORDER = "order";
    private final String API_CANCEL = "cancel";
    private final String API_TIMESTAMP = "timestamp";
    private final int API_MAX_TRADES = 750;
    private ErrorManager errors = new ErrorManager();
    private final String TOKEN_ERR = "error";
    private final String TOKEN_BAD_RETURN = "No Connection With Exchange";

    public ExcoinWrapper() {
        this.setupErrors();
    }

    public ExcoinWrapper(ApiKeys keys, Exchange exchange) {
        this.keys = keys;
        this.exchange = exchange;
        this.setupErrors();
    }

    private void setupErrors() {
        this.errors.setExchangeName(this.exchange);
    }

    private ApiResponse getQuery(String url) {
        ApiResponse apiResponse = new ApiResponse();
        HashMap<String, String> query_args = new HashMap<String, String>();
        boolean isGet = true;
        String queryResult = this.query(url, query_args, isGet);
        if (queryResult == null) {
            apiResponse.setError(this.errors.nullReturnError);
            return apiResponse;
        }
        if (queryResult.equals("No Connection With Exchange")) {
            apiResponse.setError(this.errors.noConnectionError);
            return apiResponse;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject httpAnswerJson = (JSONObject)parser.parse(queryResult);
            if (httpAnswerJson.containsKey("error")) {
                String errorMessage = httpAnswerJson.get("error").toString();
                ApiError apiErr = this.errors.apiReturnError;
                apiErr.setDescription(errorMessage);
                LOG.severe("Exco.in API returned an error: " + errorMessage);
                apiResponse.setError(apiErr);
            } else {
                apiResponse.setResponseObject(httpAnswerJson);
            }
        }
        catch (ClassCastException cce) {
            try {
                JSONArray httpAnswerJson = (JSONArray)parser.parse(queryResult);
                apiResponse.setResponseObject(httpAnswerJson);
            }
            catch (ParseException pe) {
                LOG.severe("httpResponse: " + queryResult + " \n" + pe.toString());
                apiResponse.setError(this.errors.parseError);
            }
            catch (ClassCastException ccex) {
                LOG.severe("httpResponse: " + queryResult + " \n" + ccex.toString());
                apiResponse.setError(this.errors.genericError);
            }
        }
        catch (ParseException pe) {
            LOG.severe("httpResponse: " + queryResult + " \n" + pe.toString());
            apiResponse.setError(this.errors.parseError);
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getAvailableBalances(CurrencyPair pair) {
        return this.getBalanceImpl(pair, null);
    }

    @Override
    public ApiResponse getAvailableBalance(Currency currency) {
        return this.getBalanceImpl(null, currency);
    }

    private ApiResponse getBalanceImpl(CurrencyPair pair, Currency currency) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://api.exco.in/v1/account/summary";
        ApiResponse response = this.getQuery(url);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONArray activeWallets = (JSONArray)httpAnswerJson.get("active_wallets");
            if (currency == null) {
                Amount PEGAvail = new Amount(0.0, pair.getPaymentCurrency());
                Amount NBTAvail = new Amount(0.0, pair.getOrderCurrency());
                Amount PEGonOrder = new Amount(0.0, pair.getPaymentCurrency());
                Amount NBTonOrder = new Amount(0.0, pair.getOrderCurrency());
                for (JSONObject thisWallet : activeWallets) {
                    String thisCurrency = thisWallet.get("currency").toString();
                    if (thisCurrency.equals(pair.getPaymentCurrency().getCode().toUpperCase())) {
                        PEGAvail.setQuantity(Double.parseDouble(thisWallet.get("available_balance").toString()));
                        PEGonOrder.setQuantity(Double.parseDouble(thisWallet.get("order_balance").toString()));
                    }
                    if (!thisCurrency.equals(pair.getOrderCurrency().getCode().toUpperCase())) continue;
                    NBTAvail.setQuantity(Double.parseDouble(thisWallet.get("available_balance").toString()));
                    NBTonOrder.setQuantity(Double.parseDouble(thisWallet.get("order_balance").toString()));
                }
                Balance balance = new Balance(PEGAvail, NBTAvail, PEGonOrder, NBTonOrder);
                balance = Balance.getSwapedBalance(balance);
                apiResponse.setResponseObject(balance);
            } else {
                Amount total = new Amount(0.0, currency);
                for (JSONObject thisWallet : activeWallets) {
                    String thisCurrency = thisWallet.get("currency").toString();
                    if (!thisCurrency.equals(currency.getCode().toUpperCase())) continue;
                    total.setQuantity(Double.parseDouble(thisWallet.get("available_balance").toString()));
                }
                apiResponse.setResponseObject(total);
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getLastPrice(CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String curs = pair.getPaymentCurrency().getCode().toUpperCase() + "/" + pair.getOrderCurrency().getCode().toUpperCase();
        String url = "https://api.exco.in/v1/exchange/" + curs + "/" + "summary";
        double last = -1.0;
        double ask = -1.0;
        double bid = -1.0;
        Ticker ticker = new Ticker();
        ApiResponse response = this.getQuery(url);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            last = Double.parseDouble(httpAnswerJson.get("last_price").toString());
            ask = Double.parseDouble(httpAnswerJson.get("lowest_ask").toString());
            bid = Double.parseDouble(httpAnswerJson.get("top_bid").toString());
            ticker.setLast(last);
            ticker.setAsk(ask);
            ticker.setBid(bid);
            apiResponse.setResponseObject(ticker);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse sell(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("SELL", pair, amount, rate);
    }

    @Override
    public ApiResponse buy(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("BUY", pair, amount *= rate, rate);
    }

    public ApiResponse enterOrder(String type, CurrencyPair pair, double amount, double rate) {
        ApiResponse apiResponse = new ApiResponse();
        DecimalFormat nf = new DecimalFormat("0");
        nf.setMinimumFractionDigits(8);
        String curs = pair.getPaymentCurrency().getCode().toUpperCase() + "/" + pair.getOrderCurrency().getCode().toUpperCase();
        String details = curs + "/" + (type.equals("BUY") ? "bid" : "ask") + "/" + nf.format(amount) + "/" + nf.format(rate);
        String url = "https://api.exco.in/v1/account/orders/issue/" + details;
        ApiResponse response = this.getQuery(url);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            String order_id = httpAnswerJson.get("id").toString();
            apiResponse.setResponseObject(order_id);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getActiveOrders() {
        return this.getActiveOrdersImpl(null);
    }

    @Override
    public ApiResponse getActiveOrders(CurrencyPair pair) {
        return this.getActiveOrdersImpl(pair);
    }

    public ApiResponse getActiveOrdersImpl(CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://api.exco.in/v1/account/orders";
        ArrayList<Order> orderList = new ArrayList<Order>();
        ApiResponse response = this.getQuery(url);
        if (response.isPositive()) {
            JSONArray httpAnswerJson = (JSONArray)response.getResponseObject();
            for (JSONObject thisExchange : httpAnswerJson) {
                String commodity = thisExchange.get("commodity").toString();
                String currency = thisExchange.get("currency").toString();
                if (pair != null && !currency.equals(pair.getPaymentCurrency().getCode().toUpperCase()) && !commodity.equals(pair.getOrderCurrency().getCode().toUpperCase())) continue;
                JSONArray _orders = (JSONArray)thisExchange.get("orders");
                for (JSONObject thisTyp : _orders) {
                    String type = thisTyp.get("type").toString();
                    JSONArray orders = (JSONArray)thisTyp.get("orders");
                    for (JSONObject orderJson : orders) {
                        CurrencyPair returnedPair = CurrencyPair.getCurrencyPairFromString(commodity + "_" + currency, "_");
                        Order out = this.parseOrder(orderJson, returnedPair, type);
                        orderList.add(out);
                    }
                }
            }
            apiResponse.setResponseObject(orderList);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getOrderDetail(String orderID) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://api.exco.in/v1/account/order/" + orderID;
        String[] splitOrderId = orderID.split("-");
        String pairString = splitOrderId[1] + "_" + splitOrderId[0];
        CurrencyPair pair = CurrencyPair.getCurrencyPairFromString(pairString, "_");
        ApiResponse response = this.getQuery(url);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            Order out = this.parseOrder(httpAnswerJson, pair, null);
            apiResponse.setResponseObject(out);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    public Order parseOrder(JSONObject in, CurrencyPair pair, String type) {
        Order out = new Order();
        out.setId(in.get("id").toString());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        Date date = null;
        try {
            date = sdf.parse(in.get("timestamp").toString());
        }
        catch (java.text.ParseException pe) {
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
            try {
                date = sdf.parse(in.get("timestamp").toString());
            }
            catch (java.text.ParseException pe1) {
                LOG.severe(pe1.toString());
            }
        }
        if (date != null) {
            long timeStamp = date.getTime();
            Date insertDate = new Date(timeStamp);
            out.setInsertedDate(insertDate);
        }
        Amount price = new Amount(Double.parseDouble(in.get("price").toString()), pair.getPaymentCurrency());
        out.setPrice(price);
        Amount amount = new Amount(Double.parseDouble(in.get("commodity_amount").toString()), pair.getOrderCurrency());
        out.setAmount(amount);
        if (type == null) {
            type = in.get("type").toString();
        }
        out.setType(type.equals("BID") ? "BUY" : "SELL");
        out.setPair(pair);
        return out;
    }

    @Override
    public ApiResponse cancelOrder(String orderID, CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://api.exco.in/v1/account/order/" + orderID + "/" + "cancel";
        ApiResponse response = this.getQuery(url);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            String returnedOrderId = httpAnswerJson.get("id").toString();
            if (returnedOrderId.equals(orderID)) {
                apiResponse.setResponseObject(true);
            } else {
                apiResponse.setResponseObject(false);
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getTxFee() {
        double defaultFee = 0.15;
        if (Global.options != null) {
            defaultFee = Global.options.getTxFee();
        }
        return new ApiResponse(true, defaultFee, null);
    }

    @Override
    public ApiResponse getTxFee(CurrencyPair pair) {
        LOG.fine("Excoin uses global TX fee, currency pair not supported. \nnow calling getTxFee()");
        return this.getTxFee();
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair) {
        return this.getLastTradesImpl(pair, 0L);
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair, long startTime) {
        return this.getLastTradesImpl(pair, startTime);
    }

    public ApiResponse getLastTradesImpl(CurrencyPair pair, long startTime) {
        String url;
        ApiResponse apiResponse = new ApiResponse();
        ArrayList<Trade> tradeList = new ArrayList<Trade>();
        if (startTime == 0L) {
            LOG.info("A maximum of 750 trades can be returned from the API");
            url = "https://api.exco.in/v1/account/trades/750";
        } else {
            url = "https://api.exco.in/v1/account/trades/timestamp/" + startTime;
        }
        ApiResponse response = this.getQuery(url);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONArray trades = (JSONArray)httpAnswerJson.get("trades");
            Iterator trade = trades.iterator();
            while (trade.hasNext()) {
                tradeList.add(this.parseTrade((JSONObject)trade.next()));
            }
            apiResponse.setResponseObject(tradeList);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    public Trade parseTrade(JSONObject in) {
        Trade out = new Trade();
        String commodity = in.get("commodity").toString();
        String currency = in.get("currency").toString();
        CurrencyPair pair = CurrencyPair.getCurrencyPairFromString(commodity + "_" + currency, "_");
        out.setPair(pair);
        String type = in.get("type").toString();
        out.setType(type.equals("BUY") ? "BUY" : "SELL");
        Amount price = new Amount(Double.parseDouble(in.get("price").toString()), pair.getPaymentCurrency());
        out.setPrice(price);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss z");
        Date date = null;
        try {
            date = sdf.parse(in.get("timestamp").toString());
        }
        catch (java.text.ParseException pe) {
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
            try {
                date = sdf.parse(in.get("timestamp").toString());
            }
            catch (java.text.ParseException pe1) {
                LOG.severe(pe1.toString());
            }
        }
        if (date != null) {
            long timeStamp = date.getTime();
            Date insertDate = new Date(timeStamp);
            out.setDate(insertDate);
        }
        out.setExchangeName(this.exchange.getName());
        Amount amount = type.equals("BUY") ? new Amount(Double.parseDouble(in.get("received").toString()), pair.getOrderCurrency()) : new Amount(Double.parseDouble(in.get("sent").toString()), pair.getOrderCurrency());
        out.setAmount(amount);
        Amount fee = new Amount(Double.parseDouble(in.get("fee").toString()), pair.getPaymentCurrency());
        out.setFee(fee);
        String hash_data = in.get("timestamp").toString() + in.get("commodity").toString() + in.get("currency").toString();
        String id = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(hash_data.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            id = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.severe(e.toString());
        }
        out.setId(id);
        out.setOrder_id(id);
        return out;
    }

    @Override
    public ApiResponse isOrderActive(String id) {
        ApiResponse apiResponse = new ApiResponse();
        ApiResponse activeOrdersResponse = this.getActiveOrders();
        apiResponse.setResponseObject(false);
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            for (Order thisOrder : orderList) {
                if (!thisOrder.getId().equals(id)) continue;
                apiResponse.setResponseObject(true);
            }
        }
        return apiResponse;
    }

    @Override
    public ApiResponse clearOrders(CurrencyPair pair) {
        ApiResponse toReturn = new ApiResponse();
        boolean ok = true;
        ApiResponse activeOrdersResponse = this.getActiveOrders();
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            for (int i = 0; i < orderList.size(); ++i) {
                Order tempOrder = (Order)orderList.get(i);
                if (!tempOrder.getPair().equals(pair)) continue;
                ApiResponse deleteOrderResponse = this.cancelOrder(tempOrder.getId(), null);
                if (deleteOrderResponse.isPositive()) {
                    boolean deleted = (Boolean)deleteOrderResponse.getResponseObject();
                    if (deleted) {
                        LOG.warning("Order " + tempOrder.getId() + " deleted succesfully");
                    } else {
                        LOG.warning("Could not delete order " + tempOrder.getId() + "");
                        ok = false;
                    }
                } else {
                    LOG.severe(deleteOrderResponse.getError().toString());
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.severe(ex.toString());
                }
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
            toReturn.setError(activeOrdersResponse.getError());
            return toReturn;
        }
        toReturn.setResponseObject(ok);
        return toReturn;
    }

    @Override
    public ApiError getErrorByCode(int code) {
        return null;
    }

    @Override
    public String getUrlConnectionCheck() {
        return "https://api.exco.in/v1";
    }

    @Override
    public String query(String url, HashMap<String, String> args, boolean isGet) {
        String queryResult;
        ExcoinService query = new ExcoinService(url, this.keys);
        if (this.exchange.getLiveData().isConnected()) {
            queryResult = query.executeQuery(true, isGet);
        } else {
            LOG.severe("The bot will not execute the query, there is no connection to Excoin");
            queryResult = "No Connection With Exchange";
        }
        return queryResult;
    }

    @Override
    public String query(String base, String method, HashMap<String, String> args, boolean isGet) {
        return null;
    }

    @Override
    public String query(String url, TreeMap<String, String> args, boolean isGet) {
        return null;
    }

    @Override
    public String query(String base, String method, TreeMap<String, String> args, boolean isGet) {
        return null;
    }

    @Override
    public void setKeys(ApiKeys keys) {
        this.keys = keys;
    }

    @Override
    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void setApiBaseUrl(String apiBaseUrl) {
    }

    private class ExcoinService
    implements ServiceInterface {
        protected String url;
        protected ApiKeys keys;

        public ExcoinService(String url, ApiKeys keys) {
            this.url = url + "?expire=" + this.getExpireTimeStamp();
            this.keys = keys;
        }

        public String getExpireTimeStamp() {
            Long timeStamp = System.currentTimeMillis() / 1000L + 900L;
            return timeStamp.toString();
        }

        @Override
        public String executeQuery(boolean needAuth, boolean isGet) {
            HttpsURLConnection connection = null;
            boolean httpError = false;
            int response = 200;
            String answer = null;
            URL queryUrl = null;
            String post_data = "";
            try {
                queryUrl = new URL(this.url);
            }
            catch (MalformedURLException mal) {
                LOG.severe(mal.toString());
            }
            try {
                connection = (HttpsURLConnection)queryUrl.openConnection();
                connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("User-Agent", Global.settings.getProperty("app_name"));
                connection.setRequestProperty("Accept", "*/*");
                if (needAuth) {
                    connection.setRequestProperty("Api-Key", this.keys.getApiKey());
                    connection.setRequestProperty("Api-Signature", this.signRequest(this.keys.getPrivateKey(), this.url));
                }
                connection.setRequestProperty("Connection", "close");
                connection.setRequestProperty("Host", "exco.in");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                if (isGet) {
                    connection.setRequestMethod("GET");
                } else {
                    connection.setRequestMethod("POST");
                    DataOutputStream os = new DataOutputStream(connection.getOutputStream());
                    os.writeBytes(post_data);
                    os.flush();
                    os.close();
                }
            }
            catch (ProtocolException pe) {
                LOG.severe(pe.toString());
                return answer;
            }
            catch (IOException io) {
                LOG.severe(io.toString());
                return answer;
            }
            BufferedReader br = null;
            try {
                if (connection.getResponseCode() >= 400) {
                    httpError = true;
                    response = connection.getResponseCode();
                    answer = "";
                    br = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                } else {
                    answer = "";
                    br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                }
            }
            catch (IOException io) {
                LOG.severe(io.toString());
                return answer;
            }
            if (httpError) {
                LOG.severe("Query to : " + queryUrl + "\nHTTP Response : " + Objects.toString(response));
            }
            try {
                String output;
                while ((output = br.readLine()) != null) {
                    answer = answer + output;
                }
            }
            catch (IOException io) {
                LOG.severe(io.toString());
                return null;
            }
            connection.disconnect();
            connection = null;
            return answer;
        }

        @Override
        public String signRequest(String secret, String hash_data) {
            String sign = "";
            try {
                SecretKeySpec key = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256");
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(key);
                sign = Hex.encodeHexString(mac.doFinal(hash_data.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException uee) {
                LOG.severe("Unsupported encoding exception: " + uee.toString());
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.severe("No such algorithm exception: " + nsae.toString());
            }
            catch (InvalidKeyException ike) {
                LOG.severe("Invalid key exception: " + ike.toString());
            }
            return sign;
        }
    }
}

