/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tests;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.exchanges.ExchangeLiveData;
import com.nubits.nubot.global.Constant;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Balance;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.models.Trade;
import com.nubits.nubot.options.OptionsJSON;
import com.nubits.nubot.tasks.TaskManager;
import com.nubits.nubot.trading.Ticker;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.trading.wrappers.AllCoinWrapper;
import com.nubits.nubot.trading.wrappers.BitSparkWrapper;
import com.nubits.nubot.trading.wrappers.BitcoinCoIDWrapper;
import com.nubits.nubot.trading.wrappers.BtceWrapper;
import com.nubits.nubot.trading.wrappers.BterWrapper;
import com.nubits.nubot.trading.wrappers.CcedkWrapper;
import com.nubits.nubot.trading.wrappers.CcexWrapper;
import com.nubits.nubot.trading.wrappers.ExcoinWrapper;
import com.nubits.nubot.trading.wrappers.PeatioWrapper;
import com.nubits.nubot.trading.wrappers.PoloniexWrapper;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import com.nubits.nubot.utils.logging.NuLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class TestWrappers {
    private static final Logger LOG = Logger.getLogger(TestWrappers.class.getName());
    private static final String TEST_OPTIONS_PATH = "res/options/private/old/options-full.json";
    public static final String testExchange = "bter";
    public static final CurrencyPair testPair = Constant.NBT_BTC;
    public static final Currency testCurrency = Constant.NBT;

    public static void main(String[] args) {
        Utils.loadProperties("settings.properties");
        TestWrappers.init();
        String[] inputs = new String[]{TEST_OPTIONS_PATH};
        Global.options = OptionsJSON.parseOptions(inputs);
        TestWrappers.configExchange(testExchange);
        TestWrappers.runTests();
        System.exit(0);
    }

    public static void runTests() {
        TestWrappers.testGetAvailableBalances(testPair);
        TestWrappers.testStressClearAllorders();
    }

    private static void testStressClearAllorders() {
        int i;
        TestWrappers.testClearAllOrders(testPair);
        for (i = 0; i <= 5; ++i) {
            TestWrappers.testSell(0.1, 0.004, testPair);
            try {
                Thread.sleep(400L);
                continue;
            }
            catch (InterruptedException ex) {
                LOG.severe(ex.toString());
            }
        }
        for (i = 0; i <= 5; ++i) {
            TestWrappers.testBuy(0.1, 0.001, testPair);
            try {
                Thread.sleep(400L);
                continue;
            }
            catch (InterruptedException ex) {
                LOG.severe(ex.toString());
            }
        }
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException ex) {
            LOG.severe(ex.toString());
        }
        TestWrappers.testClearAllOrders(testPair);
    }

    private static void testGetAvailableBalances(CurrencyPair pair) {
        ApiResponse balancesResponse = Global.exchange.getTrade().getAvailableBalances(pair);
        if (balancesResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.getBalance() ");
            Balance balance = (Balance)balancesResponse.getResponseObject();
            LOG.info(balance.toString());
        } else {
            LOG.severe(balancesResponse.getError().toString());
        }
    }

    private static void testGetAvailableBalance(Currency cur) {
        ApiResponse balanceResponse = Global.exchange.getTrade().getAvailableBalance(cur);
        if (balanceResponse.isPositive()) {
            LOG.info("Positive response from TradeInterface.getBalance(CurrencyPair pair) ");
            Amount balance = (Amount)balanceResponse.getResponseObject();
            LOG.info(balance.toString());
        } else {
            LOG.severe(balanceResponse.getError().toString());
        }
    }

    private static void testGetLastPrice(CurrencyPair pair) {
        ApiResponse lastPriceResponse = Global.exchange.getTrade().getLastPrice(pair);
        if (lastPriceResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.getLastPrice(CurrencyPair pair) ");
            Ticker ticker = (Ticker)lastPriceResponse.getResponseObject();
            LOG.info("Last price : 1 " + testPair.getOrderCurrency().getCode() + " = " + ticker.getLast() + " " + testPair.getPaymentCurrency().getCode());
            LOG.info("ask  : 1 " + testPair.getOrderCurrency().getCode() + " = " + ticker.getAsk() + " " + testPair.getPaymentCurrency().getCode());
            LOG.info("bid  : 1 " + testPair.getOrderCurrency().getCode() + " = " + ticker.getBid() + " " + testPair.getPaymentCurrency().getCode());
        } else {
            LOG.severe(lastPriceResponse.getError().toString());
        }
    }

    private static void testSell(double amountSell, double priceSell, CurrencyPair pair) {
        ApiResponse sellResponse = Global.exchange.getTrade().sell(pair, amountSell, priceSell);
        if (sellResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.sell(...) ");
            LOG.warning("Strategy : Submit order : sell" + amountSell + " " + pair.getOrderCurrency().getCode() + " @ " + priceSell + " " + pair.getPaymentCurrency().getCode());
            String sellResponseString = (String)sellResponse.getResponseObject();
            LOG.info("Response = " + sellResponseString);
        } else {
            LOG.severe(sellResponse.getError().toString());
        }
    }

    private static void testBuy(double amountBuy, double priceBuy, CurrencyPair pair) {
        ApiResponse buyResponse = Global.exchange.getTrade().buy(pair, amountBuy, priceBuy);
        if (buyResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.buy(...) ");
            LOG.info(": Submit order : buy" + amountBuy + " " + pair.getOrderCurrency().getCode() + " @ " + priceBuy + " " + pair.getPaymentCurrency().getCode());
            String buyResponseString = (String)buyResponse.getResponseObject();
            LOG.info("Response = " + buyResponseString);
        } else {
            LOG.severe(buyResponse.getError().toString());
        }
    }

    private static void testGetActiveOrders() {
        ApiResponse activeOrdersResponse = Global.exchange.getTrade().getActiveOrders();
        if (activeOrdersResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.getActiveOrders() ");
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            LOG.info("Active orders : " + orderList.size());
            for (int i = 0; i < orderList.size(); ++i) {
                Order tempOrder = (Order)orderList.get(i);
                LOG.info(tempOrder.toString());
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
        }
    }

    private static void testGetActiveOrders(CurrencyPair pair) {
        ApiResponse activeOrdersUSDNTBResponse = Global.exchange.getTrade().getActiveOrders(pair);
        if (activeOrdersUSDNTBResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.getActiveOrders(CurrencyPair pair) ");
            ArrayList orderListUSDNBT = (ArrayList)activeOrdersUSDNTBResponse.getResponseObject();
            LOG.info("Active orders : " + orderListUSDNBT.size());
            for (int i = 0; i < orderListUSDNBT.size(); ++i) {
                Order tempOrder = (Order)orderListUSDNBT.get(i);
                LOG.info(tempOrder.toString());
            }
        } else {
            LOG.severe(activeOrdersUSDNTBResponse.getError().toString());
        }
    }

    private static void testGetOrderDetail(String order_id_detail) {
        ApiResponse orderDetailResponse = Global.exchange.getTrade().getOrderDetail(order_id_detail);
        if (orderDetailResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.getOrderDetail(id) ");
            Order order = (Order)orderDetailResponse.getResponseObject();
            LOG.info(order.toString());
        } else {
            LOG.info(orderDetailResponse.getError().toString());
        }
    }

    private static void testCancelOrder(String order_id_delete, CurrencyPair pair) {
        ApiResponse deleteOrderResponse = Global.exchange.getTrade().cancelOrder(order_id_delete, pair);
        if (deleteOrderResponse.isPositive()) {
            boolean deleted = (Boolean)deleteOrderResponse.getResponseObject();
            if (deleted) {
                LOG.info("Order deleted succesfully");
            } else {
                LOG.info("Could not delete order");
            }
        } else {
            LOG.severe(deleteOrderResponse.getError().toString());
        }
    }

    private static void testGetTxFee() {
        ApiResponse txFeeResponse = Global.exchange.getTrade().getTxFee();
        if (txFeeResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.getTxFee()");
            double txFee = (Double)txFeeResponse.getResponseObject();
            LOG.info("Trasaction fee = " + txFee + "%");
        } else {
            LOG.severe(txFeeResponse.getError().toString());
        }
    }

    private static void testGetTxFeeWithArgs(CurrencyPair pair) {
        ApiResponse txFeeNTBUSDResponse = Global.exchange.getTrade().getTxFee(pair);
        if (txFeeNTBUSDResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.getTxFee(CurrencyPair pair)");
            double txFeeUSDNTB = (Double)txFeeNTBUSDResponse.getResponseObject();
            LOG.info("Trasaction fee = " + txFeeUSDNTB + "%");
        } else {
            LOG.severe(txFeeNTBUSDResponse.getError().toString());
        }
    }

    private static void testIsOrderActive(String orderId) {
        ApiResponse orderDetailResponse = Global.exchange.getTrade().isOrderActive(orderId);
        if (orderDetailResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.isOrderActive(id) ");
            boolean exist = (Boolean)orderDetailResponse.getResponseObject();
            LOG.info("Order " + orderId + "  active? " + exist);
        } else {
            LOG.severe(orderDetailResponse.getError().toString());
        }
    }

    private static void testClearAllOrders(CurrencyPair pair) {
        ApiResponse deleteOrdersResponse = Global.exchange.getTrade().clearOrders(pair);
        if (deleteOrdersResponse.isPositive()) {
            boolean deleted = (Boolean)deleteOrdersResponse.getResponseObject();
            if (deleted) {
                LOG.info("Order clear request succesfully");
            } else {
                LOG.info("Could not submit request to clear orders");
            }
        } else {
            LOG.severe(deleteOrdersResponse.getError().toString());
        }
    }

    private static void testGetLastTrades(CurrencyPair pair) {
        ApiResponse activeOrdersResponse = Global.exchange.getTrade().getLastTrades(pair);
        if (activeOrdersResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.getLastTrades(pair) ");
            ArrayList tradeList = (ArrayList)activeOrdersResponse.getResponseObject();
            LOG.info("Last 24h trades : " + tradeList.size());
            for (int i = 0; i < tradeList.size(); ++i) {
                Trade tempTrade = (Trade)tradeList.get(i);
                LOG.info(tempTrade.toString());
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
        }
    }

    private static void testGetLastTrades(CurrencyPair pair, long startTime) {
        ApiResponse activeOrdersResponse = Global.exchange.getTrade().getLastTrades(pair, startTime);
        if (activeOrdersResponse.isPositive()) {
            LOG.info("\nPositive response  from TradeInterface.getLastTrades(pair,startTime) ");
            ArrayList tradeList = (ArrayList)activeOrdersResponse.getResponseObject();
            LOG.info("Last trades from " + startTime + " : " + tradeList.size());
            for (int i = 0; i < tradeList.size(); ++i) {
                Trade tempTrade = (Trade)tradeList.get(i);
                LOG.info(tempTrade.toString());
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
        }
    }

    private static void init() {
        String folderName = "testwrappers_" + System.currentTimeMillis() + "/";
        String logsFolder = Global.settings.getProperty("log_path") + folderName;
        FileSystem.mkdir(logsFolder);
        try {
            NuLogger.setup(false, logsFolder);
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
        System.setProperty("javax.net.ssl.trustStore", Global.settings.getProperty("keystore_path"));
        System.setProperty("javax.net.ssl.trustStorePassword", Global.settings.getProperty("keystore_pass"));
    }

    public static void configExchange(String exchangeName) {
        Global.exchange = new Exchange(exchangeName);
        ExchangeLiveData liveData = new ExchangeLiveData();
        Global.exchange.setLiveData(liveData);
        Global.options.setExchangeName(exchangeName);
        if (exchangeName.equals("btce")) {
            ApiKeys keys = new ApiKeys("a27d7dd031ce00bf44fc0c760d94330089670456fd406039f73710e84509f98e", "8A1LURBN-C6XKA4YH-L6X877T1-8Z5Q7T4S-G9GUDGGQ");
            Global.exchange.setTrade(new BtceWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("peatio")) {
            ApiKeys keys = new ApiKeys("X6DZbcMUEDVWpjAMDgRga7liSLOy7gGIVo0zYxQD", "jp1nE97dfnJVR3mS9FanFKYwlPM00XFOixxLH74a");
            Global.exchange.setTrade(new PeatioWrapper(keys, Global.exchange, "http://178.62.186.229/"));
        } else if (exchangeName.equals("ccedk")) {
            ApiKeys keys = new ApiKeys("b910430q472qg2xc97gwu2dp5np8pj1szcn3b36zl9316yd87q8mjhi4q8m2qqeu", "1PS581UD5VZ5JSUHLGOTP32K33P2B9EBMWJA3HVURRH12MF2PQ2K4G1BFXIX7I5T");
            Global.exchange.setTrade(new CcedkWrapper(keys, Global.exchange));
        } else if (exchangeName.equals(testExchange)) {
            ApiKeys keys = new ApiKeys("ab2432aba7e95db56ce893058986bbce39c48fa7ce134746e3621fbdfd0525f4", "853FC50F-E8C8-4177-B62E-3FE2C1239A83");
            Global.exchange.setTrade(new BterWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("poloniex")) {
            ApiKeys keys = new ApiKeys("caa08a726ed19e604bdfb2686bbad457bec32ae18b5229a16cbc575eb31e2674ede0da733e35d3de5fe9fbb86e3d75bbf812f16c652575b5d2b530c10fbb4bf3", "ANHBHV2Z-T8PYNP2X-DUM90Y27-CDXPP68Q");
            Global.exchange.setTrade(new PoloniexWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("ccex")) {
            ApiKeys keys = new ApiKeys("64ED6B493924A5121FB9ECDEE2726977", "");
            Global.exchange.setTrade(new CcexWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("allcoin")) {
            ApiKeys keys = new ApiKeys("ae60d490cf996d6aea448e071de54328b4996d6a281765f142a97414a665ef", "7c9b8f524c9b7db5977eb21ad94120f0fec96a2f");
            Global.exchange.setTrade(new AllCoinWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("bitspark")) {
            ApiKeys keys = new ApiKeys("MTIjH2x10jObstAR7XSyFtKqQ0Ke7ZaBYBUPzQfX", "QGxlNMG2Jc2jANsOxor239JQ50WJWv8aCkR4WxkA");
            Global.exchange.setTrade(new BitSparkWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("excoin")) {
            ApiKeys keys = new ApiKeys("MnXwGc1HAmmP7JBDZKMv_Q1guIvTn2ZtvfyIZUOjRKMQ", "plG2RCgyH794--Y-7F3GoQ5rJN5Nhkh-k2iLnOZC228A");
            Global.exchange.setTrade(new ExcoinWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("bitcoincoid")) {
            ApiKeys keys = new ApiKeys("1c81ae7b748905b50a4b50fc03603464a8c3091f576065586b11d78a5c64403ec89482fbbfaef289", "VGUYLP7B-LFILPWLD-S0N9Q0ED-TLZCTIWY-TVTAME71");
            Global.exchange.setTrade(new BitcoinCoIDWrapper(keys, Global.exchange));
        } else {
            LOG.severe("Exchange " + exchangeName + " not supported");
            System.exit(0);
        }
        Global.exchange.getLiveData().setUrlConnectionCheck(Global.exchange.getTrade().getUrlConnectionCheck());
        Global.taskManager = new TaskManager();
        Global.taskManager.getCheckConnectionTask().start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            LOG.severe(ex.toString());
        }
    }
}

