/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tests;

import com.nubits.nubot.NTP.NTPClient;
import com.nubits.nubot.global.Constant;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.LastPrice;
import com.nubits.nubot.notifications.HipChatNotifications;
import com.nubits.nubot.notifications.jhipchat.messages.Message;
import com.nubits.nubot.pricefeeds.AbstractPriceFeed;
import com.nubits.nubot.pricefeeds.PriceFeedManager;
import com.nubits.nubot.utils.Utils;
import com.nubits.nubot.utils.logging.NuLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestSync
extends TimerTask {
    private static final Logger LOG = Logger.getLogger(TestSync.class.getName());
    private static final int TASK_INTERVAL = 61;
    private static final int TASK_MAX_EXECUTION_INTERVAL = 50;
    private static String id;
    private static int startTime;
    private static CurrencyPair pair;
    private static AbstractPriceFeed feed;

    public static void main(String[] args) throws InterruptedException {
        startTime = (int)(System.currentTimeMillis() / 1000L);
        System.out.println("Start-time = " + startTime);
        id = UUID.randomUUID().toString();
        TestSync.init();
        TestSync.message("Started");
        int rand = 10 + (int)Math.round(Math.random() * 10.0);
        Thread.sleep(rand * 1000);
        TestSync.message("Reading remote time");
        Date remoteDate = new NTPClient().getTime();
        GregorianCalendar remoteCalendar = new GregorianCalendar();
        remoteCalendar.setTime(remoteDate);
        TestSync.message("Computing delay");
        int remoteTimeInSeconds = remoteCalendar.get(13);
        TestSync.message("Remote time in sec = " + remoteTimeInSeconds);
        int delay = 60 - remoteTimeInSeconds;
        TestSync.message("Delay = " + delay + "  s");
        TestSync testSync = new TestSync();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)testSync, delay * 1000, 61000L);
        TestSync.message("Timer scheduled");
    }

    private static void message(String msg) {
        System.out.println(TestSync.getIdString() + msg);
    }

    private static String getIdString() {
        int now = (int)(System.currentTimeMillis() / 1000L);
        int secondsFromStart = now - startTime;
        return id.substring(id.lastIndexOf("-") + 10) + " , t=" + secondsFromStart + "     - ";
    }

    private static void init() {
        Utils.loadProperties("settings.properties");
        String folderName = "tests_" + System.currentTimeMillis() + "/";
        String logsFolder = Global.settings.getProperty("log_path") + folderName;
        try {
            NuLogger.setup(false, logsFolder);
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
        LOG.setLevel(Level.INFO);
        LOG.info("Set up SSL certificates");
        System.setProperty("javax.net.ssl.trustStore", Global.settings.getProperty("keystore_path"));
        System.setProperty("javax.net.ssl.trustStorePassword", Global.settings.getProperty("keystore_pass"));
    }

    @Override
    public void run() {
        TestSync.message("Run");
        HipChatNotifications.sendMessage(TestSync.getIdString() + " test price reading : 1BTC =" + this.readPrice() + "$ ", Message.Color.RED);
        int rand = (int)Math.round(Math.random() * 50.0);
        try {
            Thread.sleep(rand * 1000);
        }
        catch (InterruptedException ex) {
            LOG.severe(ex.getMessage());
        }
    }

    private double readPrice() {
        String mainFeed = "btce";
        ArrayList<String> backupFeedList = new ArrayList<String>();
        backupFeedList.add("bitcoinaverage");
        backupFeedList.add("blockchain");
        backupFeedList.add("coinbase");
        PriceFeedManager pfm = new PriceFeedManager(mainFeed, backupFeedList, pair);
        ArrayList<LastPrice> priceList = pfm.getLastPrices().getPrices();
        return priceList.get(0).getPrice().getQuantity();
    }

    static {
        pair = Constant.BTC_USD;
    }
}

