/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tasks;

import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Balance;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SubmitLiquidityinfoTask
extends TimerTask {
    private static final Logger LOG = Logger.getLogger(SubmitLiquidityinfoTask.class.getName());
    private boolean verbose;
    private String outputFile_orders;
    private String jsonFile_orders;
    private String jsonFile_balances;
    private boolean wallsBeingShifted = false;
    private boolean firstOrdersPlaced = false;

    public SubmitLiquidityinfoTask(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void run() {
        LOG.fine("Executing task : CheckOrdersTask ");
        this.checkOrders();
    }

    private void checkOrders() {
        if (!this.isWallsBeingShifted()) {
            if (this.isFirstOrdersPlaced()) {
                String response1 = this.reportTier1();
                String response2 = this.reportTier2();
                LOG.info(response1 + "\n" + response2);
            } else {
                LOG.warning("Liquidity is not being sent : orders are not yet initialized");
            }
        } else {
            LOG.warning("Liquidity is not being sent, a wall shift is happening. Will send on next execution.");
        }
    }

    private String reportTier1() {
        String toReturn = "";
        ApiResponse activeOrdersResponse = Global.exchange.getTrade().getActiveOrders(Global.options.getPair());
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            LOG.fine("Active orders : " + orderList.size());
            if (this.verbose) {
                LOG.info(Global.exchange.getName() + "OLD NBTonbuy  : " + Global.exchange.getLiveData().getNBTonbuy());
                LOG.info(Global.exchange.getName() + "OLD NBTonsell  : " + Global.exchange.getLiveData().getNBTonsell());
            }
            double nbt_onsell = 0.0;
            double nbt_onbuy = 0.0;
            int sells = 0;
            int buys = 0;
            String digest = "";
            for (int i = 0; i < orderList.size(); ++i) {
                Order tempOrder = (Order)orderList.get(i);
                digest = digest + tempOrder.getDigest();
                double toAdd = tempOrder.getAmount().getQuantity();
                if (this.verbose) {
                    LOG.fine(tempOrder.toString());
                }
                if (tempOrder.getType().equalsIgnoreCase("SELL")) {
                    nbt_onsell += toAdd;
                    ++sells;
                    continue;
                }
                if (!tempOrder.getType().equalsIgnoreCase("BUY")) continue;
                nbt_onbuy += toAdd;
                ++buys;
            }
            Global.exchange.getLiveData().setOrdersList(orderList);
            if (Global.conversion != 1.0 && Global.swappedPair) {
                nbt_onbuy *= Global.conversion;
                nbt_onsell *= Global.conversion;
            }
            Global.exchange.getLiveData().setNBTonbuy(nbt_onbuy);
            Global.exchange.getLiveData().setNBTonsell(nbt_onsell);
            Date timeStamp = new Date();
            String timeStampString = timeStamp.toString();
            Long timeStampLong = Utils.getTimestampLong();
            String toWrite = timeStampString + " , " + orderList.size() + " , " + sells + " , " + buys + " , " + digest;
            FileSystem.writeToFile(toWrite, this.outputFile_orders, true);
            JSONObject latestOrders = new JSONObject();
            latestOrders.put("time_stamp", timeStampLong);
            latestOrders.put("active_orders", orderList.size());
            JSONArray jsonDigest = new JSONArray();
            Iterator order = orderList.iterator();
            while (order.hasNext()) {
                JSONObject thisOrder = new JSONObject();
                Order _order = (Order)order.next();
                double amount = _order.getAmount().getQuantity();
                if (Global.conversion != 1.0 && Global.swappedPair) {
                    amount = _order.getAmount().getQuantity() * Global.conversion;
                }
                thisOrder.put("order_id", _order.getId());
                thisOrder.put("time", _order.getInsertedDate().getTime());
                thisOrder.put("order_type", _order.getType());
                thisOrder.put("order_currency", _order.getPair().getOrderCurrency().getCode());
                thisOrder.put("amount", amount);
                thisOrder.put("payment_currency", _order.getPair().getPaymentCurrency().getCode());
                thisOrder.put("price", _order.getPrice().getQuantity());
                jsonDigest.add(thisOrder);
            }
            latestOrders.put("digest", jsonDigest);
            JSONParser parser = new JSONParser();
            JSONObject orderHistory = new JSONObject();
            JSONArray orders = new JSONArray();
            try {
                orderHistory = (JSONObject)parser.parse(FileSystem.readFromFile(this.jsonFile_orders));
                orders = (JSONArray)orderHistory.get("orders");
            }
            catch (ParseException pe) {
                LOG.severe("Unable to parse " + this.jsonFile_orders);
            }
            orders.add(latestOrders);
            FileSystem.writeToFile(orderHistory.toJSONString(), this.jsonFile_orders, false);
            if (this.verbose) {
                LOG.info(Global.exchange.getName() + "Updated NBTonbuy  : " + nbt_onbuy);
                LOG.info(Global.exchange.getName() + "Updated NBTonsell  : " + nbt_onsell);
            }
            if (Global.options.isSendRPC()) {
                double sellSide;
                double buySide;
                if (!Global.swappedPair) {
                    buySide = Global.exchange.getLiveData().getNBTonbuy();
                    sellSide = Global.exchange.getLiveData().getNBTonsell();
                } else {
                    buySide = Global.exchange.getLiveData().getNBTonsell();
                    sellSide = Global.exchange.getLiveData().getNBTonbuy();
                }
                toReturn = this.sendLiquidityInfoImpl(buySide, sellSide, 1);
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
        }
        return toReturn;
    }

    private String reportTier2() {
        String toReturn = "";
        ApiResponse balancesResponse = Global.exchange.getTrade().getAvailableBalances(Global.options.getPair());
        if (balancesResponse.isPositive()) {
            Balance balance = (Balance)balancesResponse.getResponseObject();
            Amount NBTbalance = balance.getNBTAvailable();
            Amount PEGbalance = balance.getPEGAvailableBalance();
            double buyside = PEGbalance.getQuantity();
            double sellside = NBTbalance.getQuantity();
            JSONObject latestBalances = new JSONObject();
            latestBalances.put("time_stamp", Utils.getTimestampLong());
            JSONArray availableBalancesArray = new JSONArray();
            JSONObject NBTBalanceJSON = new JSONObject();
            NBTBalanceJSON.put("amount", sellside);
            NBTBalanceJSON.put("currency", NBTbalance.getCurrency().getCode().toUpperCase());
            JSONObject PEGBalanceJSON = new JSONObject();
            PEGBalanceJSON.put("amount", buyside);
            PEGBalanceJSON.put("currency", PEGbalance.getCurrency().getCode().toUpperCase());
            availableBalancesArray.add(PEGBalanceJSON);
            availableBalancesArray.add(NBTBalanceJSON);
            latestBalances.put("balance-not-on-order", availableBalancesArray);
            JSONParser parser = new JSONParser();
            JSONObject balanceHistory = new JSONObject();
            JSONArray balances = new JSONArray();
            try {
                balanceHistory = (JSONObject)parser.parse(FileSystem.readFromFile(this.jsonFile_balances));
                balances = (JSONArray)balanceHistory.get("balances");
            }
            catch (ParseException pe) {
                LOG.severe("Unable to parse " + this.jsonFile_balances);
            }
            balances.add(latestBalances);
            FileSystem.writeToFile(balanceHistory.toJSONString(), this.jsonFile_balances, false);
            buyside = Utils.round(buyside * Global.conversion, 2);
            if (Global.options.isSendRPC()) {
                toReturn = this.sendLiquidityInfoImpl(buyside, sellside, 2);
            }
        } else {
            LOG.severe(balancesResponse.getError().toString());
        }
        return toReturn;
    }

    private String sendLiquidityInfoImpl(double buySide, double sellSide, int tier) {
        String toReturn = "";
        if (Global.rpcClient.isConnected()) {
            JSONObject responseObject = Global.rpcClient.submitLiquidityInfo("B", buySide, sellSide, tier);
            toReturn = "buy : " + buySide + " sell : " + sellSide + " tier: " + tier + " response: " + responseObject.toJSONString();
            if (null == responseObject) {
                LOG.severe("Something went wrong while sending liquidityinfo");
            } else {
                LOG.fine(responseObject.toJSONString());
                if (((Boolean)responseObject.get("submitted")).booleanValue()) {
                    LOG.fine("RPC Liquidityinfo sent : \nbuyside : " + buySide + "\nsellside : " + sellSide);
                    if (this.verbose) {
                        JSONObject infoObject = Global.rpcClient.getLiquidityInfo("B");
                        LOG.info("getliquidityinfo result : ");
                        LOG.info(infoObject.toJSONString());
                    }
                }
            }
        } else {
            LOG.severe("Client offline. ");
        }
        return toReturn;
    }

    public void setOutputFiles(String outputFileOrders, String outputFileBalances) {
        this.outputFile_orders = outputFileOrders;
        this.jsonFile_orders = this.outputFile_orders.replace(".csv", ".json");
        File jsonF1 = new File(this.jsonFile_orders);
        if (!jsonF1.exists()) {
            JSONObject history = new JSONObject();
            JSONArray orders = new JSONArray();
            history.put("orders", orders);
            FileSystem.writeToFile(history.toJSONString(), this.jsonFile_orders, true);
        }
        this.jsonFile_balances = outputFileBalances;
        File jsonF2 = new File(this.jsonFile_balances);
        if (!jsonF2.exists()) {
            JSONObject history = new JSONObject();
            JSONArray balances = new JSONArray();
            history.put("balances", balances);
            FileSystem.writeToFile(history.toJSONString(), this.jsonFile_balances, true);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isWallsBeingShifted() {
        return this.wallsBeingShifted;
    }

    public void setWallsBeingShifted(boolean wallsBeingShifted) {
        this.wallsBeingShifted = wallsBeingShifted;
    }

    public boolean isFirstOrdersPlaced() {
        return this.firstOrdersPlaced;
    }

    public void setFirstOrdersPlaced(boolean firstOrdersPlaced) {
        this.firstOrdersPlaced = firstOrdersPlaced;
    }
}

