/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.pricefeeds;

import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.LastPrice;
import com.nubits.nubot.pricefeeds.AbstractPriceFeed;
import com.nubits.nubot.pricefeeds.BitcoinaveragePriceFeed;
import com.nubits.nubot.pricefeeds.BitfinexPriceFeed;
import com.nubits.nubot.pricefeeds.BitstampEURPriceFeed;
import com.nubits.nubot.pricefeeds.BitstampPriceFeed;
import com.nubits.nubot.pricefeeds.BlockchainPriceFeed;
import com.nubits.nubot.pricefeeds.BtcePriceFeed;
import com.nubits.nubot.pricefeeds.BterPriceFeed;
import com.nubits.nubot.pricefeeds.CcedkPriceFeed;
import com.nubits.nubot.pricefeeds.CoinbasePriceFeed;
import com.nubits.nubot.pricefeeds.CoinmarketcapnexuistPriceFeed;
import com.nubits.nubot.pricefeeds.CoinmarketcapnorthpolePriceFeed;
import com.nubits.nubot.pricefeeds.ExchangeratelabPriceFeed;
import com.nubits.nubot.pricefeeds.GoogleUnofficialPriceFeed;
import com.nubits.nubot.pricefeeds.OpenexchangeratesPriceFeed;
import com.nubits.nubot.pricefeeds.YahooPriceFeed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public class PriceFeedManager {
    private static final Logger LOG = Logger.getLogger(PriceFeedManager.class.getName());
    private ArrayList<AbstractPriceFeed> feedList = new ArrayList();
    private CurrencyPair pair;
    public static HashMap<String, AbstractPriceFeed> FEED_NAMES_MAP;
    public static final String BLOCKCHAIN = "blockchain";
    public static final String BITCOINAVERAGE = "bitcoinaverage";
    public static final String COINBASE = "coinbase";
    public static final String BITSTAMP = "bitstamp";
    public static final String BITFINEX = "bitfinex";
    public static final String BTER = "bter";
    public static final String CCEDK = "ccedk";
    public static final String BTCE = "btce";
    public static final String COINMARKETCAP_NO = "coinmarketcap_no";
    public static final String COINMARKETCAP_NE = "coinmarketcap_ne";
    public static final String BITSTAMP_EURUSD = "bitstampeurusd";
    public static final String GOOGLE_UNOFFICIAL = "google-unofficial";
    public static final String YAHOO = "yahoo";
    public static final String OPENEXCHANGERATES = "openexchangerates";
    public static final String EXCHANGERATELAB = "exchangeratelab";

    public PriceFeedManager(String mainFeed, ArrayList<String> backupFeedList, CurrencyPair pair) {
        this.initValidFeeds();
        this.pair = pair;
        this.feedList.add(this.createFeed(mainFeed));
        for (int i = 0; i < backupFeedList.size(); ++i) {
            this.feedList.add(this.createFeed(backupFeedList.get(i)));
        }
    }

    private void initValidFeeds() {
        FEED_NAMES_MAP = new HashMap();
        FEED_NAMES_MAP.put(BLOCKCHAIN, new BlockchainPriceFeed());
        FEED_NAMES_MAP.put(BITCOINAVERAGE, new BitcoinaveragePriceFeed());
        FEED_NAMES_MAP.put(COINBASE, new CoinbasePriceFeed());
        FEED_NAMES_MAP.put(BTER, new BterPriceFeed());
        FEED_NAMES_MAP.put(CCEDK, new CcedkPriceFeed());
        FEED_NAMES_MAP.put(BTCE, new BtcePriceFeed());
        FEED_NAMES_MAP.put(COINMARKETCAP_NO, new CoinmarketcapnorthpolePriceFeed());
        FEED_NAMES_MAP.put(COINMARKETCAP_NE, new CoinmarketcapnexuistPriceFeed());
        FEED_NAMES_MAP.put(BITSTAMP, new BitstampPriceFeed());
        FEED_NAMES_MAP.put(BITSTAMP_EURUSD, new BitstampEURPriceFeed());
        FEED_NAMES_MAP.put(GOOGLE_UNOFFICIAL, new GoogleUnofficialPriceFeed());
        FEED_NAMES_MAP.put(YAHOO, new YahooPriceFeed());
        FEED_NAMES_MAP.put(OPENEXCHANGERATES, new OpenexchangeratesPriceFeed());
        FEED_NAMES_MAP.put(EXCHANGERATELAB, new ExchangeratelabPriceFeed());
        FEED_NAMES_MAP.put(BITFINEX, new BitfinexPriceFeed());
    }

    public LastPriceResponse getLastPrices() {
        LastPriceResponse response = new LastPriceResponse();
        boolean isMainFeedValid = false;
        ArrayList<LastPrice> prices = new ArrayList<LastPrice>();
        for (int i = 0; i < this.feedList.size(); ++i) {
            AbstractPriceFeed tempFeed = this.feedList.get(i);
            LastPrice lastPrice = tempFeed.getLastPrice(this.pair);
            if (lastPrice != null) {
                if (!lastPrice.isError()) {
                    prices.add(lastPrice);
                    if (i != 0) continue;
                    isMainFeedValid = true;
                    continue;
                }
                LOG.warning("Error while updating " + this.pair.getOrderCurrency().getCode() + "" + " price from " + tempFeed.name);
                continue;
            }
            LOG.warning("Error (null) while updating " + this.pair.getOrderCurrency().getCode() + "" + " price from " + tempFeed.name);
        }
        response.setMainFeedValid(isMainFeedValid);
        response.setPrices(prices);
        return response;
    }

    public LastPrice getLastPrice() {
        boolean ok = false;
        for (int i = 0; i < this.feedList.size(); ++i) {
            AbstractPriceFeed tempFeed = this.feedList.get(i);
            LastPrice lastPrice = tempFeed.getLastPrice(this.pair);
            if (!lastPrice.isError()) {
                LOG.fine("Got last price of 1" + this.pair.getOrderCurrency().getCode() + "" + " from " + tempFeed.name + " : " + lastPrice.getPrice().getQuantity() + " " + lastPrice.getPrice().getCurrency().getCode());
                return lastPrice;
            }
            LOG.severe("Problem while updating the price on " + tempFeed.name);
        }
        return new LastPrice(true, "", this.pair.getOrderCurrency(), null);
    }

    private AbstractPriceFeed createFeed(String feedname) {
        if (FEED_NAMES_MAP.containsKey(feedname)) {
            return FEED_NAMES_MAP.get(feedname);
        }
        LOG.severe("Error wile adding price seed with name unrecognized : " + feedname);
        System.exit(0);
        return null;
    }

    public ArrayList<AbstractPriceFeed> getFeedList() {
        return this.feedList;
    }

    public void setFeedList(ArrayList<AbstractPriceFeed> feedList) {
        this.feedList = feedList;
    }

    public CurrencyPair getPair() {
        return this.pair;
    }

    public void setPair(CurrencyPair pair) {
        this.pair = pair;
    }

    public class LastPriceResponse {
        private boolean mainFeedValid;
        private ArrayList<LastPrice> prices;

        public boolean isMainFeedValid() {
            return this.mainFeedValid;
        }

        public void setMainFeedValid(boolean mainFeedValid) {
            this.mainFeedValid = mainFeedValid;
        }

        public ArrayList<LastPrice> getPrices() {
            return this.prices;
        }

        public void setPrices(ArrayList<LastPrice> prices) {
            this.prices = prices;
        }
    }
}

