/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.options;

import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.options.SecondaryPegOptionsJSON;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OptionsJSON {
    private static final Logger LOG = Logger.getLogger(OptionsJSON.class.getName());
    private String apiKey;
    private String apiSecret;
    private String mailRecipient;
    private String exchangeName;
    private boolean dualSide;
    private CurrencyPair pair;
    private SecondaryPegOptionsJSON secondaryPegOptions;
    private String rpcUser;
    private String rpcPass;
    private String nubitAddress;
    private int nudPort;
    private String nudIp;
    private boolean sendMails;
    private boolean submitLiquidity;
    private boolean executeOrders;
    private boolean verbose;
    private boolean sendHipchat;
    private boolean aggregate;
    private boolean multipleCustodians;
    private int executeStrategyInterval;
    private int sendLiquidityInterval;
    private double txFee;
    private double priceIncrement;
    private int emergencyTimeout;
    private double keepProceeds;
    private double maxSellVolume;
    private double maxBuyVolume;
    private SecondaryPegOptionsJSON cpo;

    public OptionsJSON(boolean dualSide, String apiKey, String apiSecret, String nubitAddress, String rpcUser, String rpcPass, String nudIp, int nudPort, double priceIncrement, double txFee, boolean sendRPC, String exchangeName, boolean executeOrders, boolean verbose, CurrencyPair pair, int executeStrategyInterval, int sendLiquidityInterval, boolean sendHipchat, boolean sendMails, String mailRecipient, int emergencyTimeout, double keepProceeds, boolean aggregate, boolean multipleCustodians, double maxSellVolume, double maxBuyVolume, SecondaryPegOptionsJSON secondaryPegOptions) {
        this.dualSide = dualSide;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.nubitAddress = nubitAddress;
        this.rpcUser = rpcUser;
        this.rpcPass = rpcPass;
        this.nudIp = nudIp;
        this.nudPort = nudPort;
        this.priceIncrement = priceIncrement;
        this.txFee = txFee;
        this.submitLiquidity = sendRPC;
        this.exchangeName = exchangeName;
        this.verbose = verbose;
        this.executeOrders = executeOrders;
        this.pair = pair;
        this.sendLiquidityInterval = sendLiquidityInterval;
        this.executeStrategyInterval = executeStrategyInterval;
        this.sendHipchat = sendHipchat;
        this.sendMails = sendMails;
        this.mailRecipient = mailRecipient;
        this.emergencyTimeout = emergencyTimeout;
        this.keepProceeds = keepProceeds;
        this.secondaryPegOptions = secondaryPegOptions;
        this.aggregate = aggregate;
        this.multipleCustodians = multipleCustodians;
        this.maxSellVolume = maxSellVolume;
        this.maxBuyVolume = maxBuyVolume;
    }

    public boolean isDualSide() {
        return this.dualSide;
    }

    public void setDualSide(boolean dualSide) {
        this.dualSide = dualSide;
    }

    public boolean isSendRPC() {
        return this.submitLiquidity;
    }

    public void setSendRPC(boolean sendRPC) {
        this.submitLiquidity = sendRPC;
    }

    public boolean isExecuteOrders() {
        return this.executeOrders;
    }

    public void setExecuteOrders(boolean executeOrders) {
        this.executeOrders = executeOrders;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public String getNubitsAddress() {
        return this.nubitAddress;
    }

    public void setNubitsAddress(String nubitAddress) {
        this.nubitAddress = nubitAddress;
    }

    public String getRpcUser() {
        return this.rpcUser;
    }

    public void setRpcUser(String rpcUser) {
        this.rpcUser = rpcUser;
    }

    public String getRpcPass() {
        return this.rpcPass;
    }

    public void setRpcPass(String rpcPass) {
        this.rpcPass = rpcPass;
    }

    public String getNudIp() {
        return this.nudIp;
    }

    public void setNudIp(String nudIp) {
        this.nudIp = nudIp;
    }

    public int getNudPort() {
        return this.nudPort;
    }

    public void setNudPort(int nudPort) {
        this.nudPort = nudPort;
    }

    public double getPriceIncrement() {
        return this.priceIncrement;
    }

    public void setPriceIncrement(double priceIncrement) {
        this.priceIncrement = priceIncrement;
    }

    public double getTxFee() {
        return this.txFee;
    }

    public void setTxFee(double txFee) {
        this.txFee = txFee;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public CurrencyPair getPair() {
        return this.pair;
    }

    public void setPair(CurrencyPair pair) {
        this.pair = pair;
    }

    public int getExecuteStrategyInterval() {
        return this.executeStrategyInterval;
    }

    public void getExecuteStrategyInterval(int executeStrategyInterval) {
        this.executeStrategyInterval = executeStrategyInterval;
    }

    public int getSendLiquidityInteval() {
        return this.sendLiquidityInterval;
    }

    public void setSendLiquidityInteval(int sendLiquidityInterval) {
        this.sendLiquidityInterval = sendLiquidityInterval;
    }

    public boolean isSendHipchat() {
        return this.sendHipchat;
    }

    public void setSendHipchat(boolean sendHipchat) {
        this.sendHipchat = sendHipchat;
    }

    public boolean isSendMails() {
        return this.sendMails;
    }

    public void setSendMails(boolean sendMails) {
        this.sendMails = sendMails;
    }

    public String getMailRecipient() {
        return this.mailRecipient;
    }

    public void setMailRecipient(String mailRecipient) {
        this.mailRecipient = mailRecipient;
    }

    public SecondaryPegOptionsJSON getSecondaryPegOptions() {
        return this.secondaryPegOptions;
    }

    public void setCryptoPegOptions(SecondaryPegOptionsJSON secondaryPegOptions) {
        this.secondaryPegOptions = secondaryPegOptions;
    }

    public boolean isMultipleCustodians() {
        return this.multipleCustodians;
    }

    public void setMultipleCustodians(boolean multipleCustodians) {
        this.multipleCustodians = multipleCustodians;
    }

    public double getMaxSellVolume() {
        return this.maxSellVolume;
    }

    public void setMaxSellVolume(double maxSellVolume) {
        this.maxSellVolume = maxSellVolume;
    }

    public double getMaxBuyVolume() {
        return this.maxBuyVolume;
    }

    public void setMaxBuyVolume(double maxBuyVolume) {
        this.maxBuyVolume = maxBuyVolume;
    }

    public static OptionsJSON parseOptions(String[] paths) {
        OptionsJSON options = null;
        ArrayList<String> filePaths = new ArrayList<String>();
        filePaths.addAll(Arrays.asList(paths));
        try {
            JSONObject inputJSON = OptionsJSON.parseFiles(filePaths);
            JSONObject optionsJSON = (JSONObject)inputJSON.get("options");
            String exchangeName = (String)optionsJSON.get("exchangename");
            String apiKey = "";
            if (!exchangeName.equalsIgnoreCase("ccex")) {
                if (!optionsJSON.containsKey("apikey")) {
                    Utils.exitWithMessage("The apikey parameter is compulsory.");
                } else {
                    apiKey = (String)optionsJSON.get("apikey");
                }
            }
            String apiSecret = (String)optionsJSON.get("apisecret");
            String mailRecipient = (String)optionsJSON.get("mail-recipient");
            String pairStr = (String)optionsJSON.get("pair");
            CurrencyPair pair = CurrencyPair.getCurrencyPairFromString(pairStr, "_");
            boolean aggregate = true;
            if (!pair.getPaymentCurrency().getCode().equalsIgnoreCase("USD")) {
                aggregate = false;
            }
            boolean dualside = (Boolean)optionsJSON.get("dualside");
            boolean requireCryptoOptions = Utils.requiresSecondaryPegStrategy(pair);
            SecondaryPegOptionsJSON cpo = null;
            if (requireCryptoOptions) {
                if (optionsJSON.containsKey("secondary-peg-options")) {
                    HashMap setMap = new HashMap();
                    JSONObject oldObject = (JSONObject)optionsJSON.get("secondary-peg-options");
                    Set tempSet = oldObject.entrySet();
                    Iterator i$ = tempSet.iterator();
                    while (i$.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = i$.next();
                        setMap.put(entry.getKey(), entry.getValue());
                    }
                    org.json.JSONObject pegOptionsJSON = new org.json.JSONObject(setMap);
                    cpo = SecondaryPegOptionsJSON.create(pegOptionsJSON, pair);
                } else {
                    LOG.severe("secondary-peg-options are required in the options");
                    System.exit(0);
                }
            }
            String nudIp = "127.0.0.1";
            boolean sendMails = true;
            boolean submitLiquidity = true;
            boolean executeOrders = true;
            boolean verbose = false;
            boolean sendHipchat = true;
            boolean multipleCustodians = false;
            int executeStrategyInterval = 41;
            int sendLiquidityInterval = Integer.parseInt(Global.settings.getProperty("submit_liquidity_seconds"));
            double txFee = 0.2;
            double priceIncrement = 3.0E-4;
            double keepProceeds = 0.0;
            double maxSellVolume = 0.0;
            double maxBuyVolume = 0.0;
            int emergencyTimeout = 60;
            if (optionsJSON.containsKey("nudip")) {
                nudIp = (String)optionsJSON.get("nudip");
            }
            if (optionsJSON.containsKey("priceincrement")) {
                priceIncrement = Utils.getDouble(optionsJSON.get("priceincrement"));
            }
            if (optionsJSON.containsKey("txfee")) {
                txFee = Utils.getDouble(optionsJSON.get("txfee"));
            }
            if (optionsJSON.containsKey("submit-liquidity")) {
                submitLiquidity = (Boolean)optionsJSON.get("submit-liquidity");
            }
            if (optionsJSON.containsKey("max-sell-order-volume")) {
                maxSellVolume = Utils.getDouble(optionsJSON.get("max-sell-order-volume"));
            }
            if (optionsJSON.containsKey("max-buy-order-volume")) {
                maxBuyVolume = Utils.getDouble(optionsJSON.get("max-buy-order-volume"));
            }
            String nubitAddress = "";
            String rpcPass = "";
            String rpcUser = "";
            int nudPort = 9091;
            if (submitLiquidity) {
                if (optionsJSON.containsKey("nubitaddress")) {
                    nubitAddress = (String)optionsJSON.get("nubitaddress");
                } else {
                    Utils.exitWithMessage("When submit-liquidity is set to true you need to declare a value for \"nubitaddress\" ");
                }
                if (optionsJSON.containsKey("rpcpass")) {
                    rpcPass = (String)optionsJSON.get("rpcpass");
                } else {
                    Utils.exitWithMessage("When submit-liquidity is set to true you need to declare a value for \"rpcpass\" ");
                }
                if (optionsJSON.containsKey("rpcuser")) {
                    rpcUser = (String)optionsJSON.get("rpcuser");
                } else {
                    Utils.exitWithMessage("When submit-liquidity is set to true you need to declare a value for \"rpcuser\" ");
                }
                if (optionsJSON.containsKey("nudport")) {
                    long nudPortlong = (Long)optionsJSON.get("nudport");
                    nudPort = (int)nudPortlong;
                } else {
                    Utils.exitWithMessage("When submit-liquidity is set to true you need to declare a value for \"nudport\" ");
                }
            }
            if (optionsJSON.containsKey("executeorders")) {
                executeOrders = (Boolean)optionsJSON.get("executeorders");
            }
            if (optionsJSON.containsKey("verbose")) {
                verbose = (Boolean)optionsJSON.get("verbose");
            }
            if (optionsJSON.containsKey("hipchat")) {
                sendHipchat = (Boolean)optionsJSON.get("hipchat");
            }
            if (optionsJSON.containsKey("mail-notifications")) {
                sendMails = (Boolean)optionsJSON.get("mail-notifications");
            }
            if (optionsJSON.containsKey("emergency-timeout")) {
                long emergencyTimeoutLong = (Long)optionsJSON.get("emergency-timeout");
                emergencyTimeout = (int)emergencyTimeoutLong;
            }
            if (optionsJSON.containsKey("keep-proceeds")) {
                keepProceeds = Utils.getDouble(optionsJSON.get("keep-proceeds"));
            }
            if (optionsJSON.containsKey("multiple-custodians")) {
                multipleCustodians = (Boolean)optionsJSON.get("multiple-custodians");
            }
            options = new OptionsJSON(dualside, apiKey, apiSecret, nubitAddress, rpcUser, rpcPass, nudIp, nudPort, priceIncrement, txFee, submitLiquidity, exchangeName, executeOrders, verbose, pair, executeStrategyInterval, sendLiquidityInterval, sendHipchat, sendMails, mailRecipient, emergencyTimeout, keepProceeds, aggregate, multipleCustodians, maxSellVolume, maxBuyVolume, cpo);
        }
        catch (NumberFormatException e) {
            LOG.severe("Error while parsing the options file : " + e);
        }
        return options;
    }

    public static JSONObject parseFiles(ArrayList<String> filePaths) {
        JSONObject optionsObject = new JSONObject();
        HashMap setMap = new HashMap();
        for (int i = 0; i < filePaths.size(); ++i) {
            try {
                JSONParser parser = new JSONParser();
                JSONObject fileJSON = (JSONObject)parser.parse(FileSystem.readFromFile(filePaths.get(i)));
                JSONObject tempOptions = (JSONObject)fileJSON.get("options");
                Set tempSet = tempOptions.entrySet();
                Iterator i$ = tempSet.iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    setMap.put(entry.getKey(), entry.getValue());
                }
                continue;
            }
            catch (ParseException ex) {
                LOG.severe("Parse exception \n" + ex.toString());
                System.exit(0);
            }
        }
        JSONObject content = new JSONObject((Map)setMap);
        optionsObject.put("options", content);
        return optionsObject;
    }

    public int getEmergencyTimeout() {
        return this.emergencyTimeout;
    }

    public void setEmergencyTimeoutMinutes(int emergencyTimeoutMinutes) {
        this.emergencyTimeout = emergencyTimeoutMinutes;
    }

    public double getKeepProceeds() {
        return this.keepProceeds;
    }

    public void setKeepProceeds(double keepProceeds) {
        this.keepProceeds = keepProceeds;
    }

    public String getNubitAddress() {
        return this.nubitAddress;
    }

    public void setNubitAddress(String nubitAddress) {
        this.nubitAddress = nubitAddress;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }

    public String toString() {
        String cryptoOptions = "";
        if (this.secondaryPegOptions != null) {
            cryptoOptions = this.secondaryPegOptions.toString();
        }
        return "OptionsJSON{dualSide=" + this.dualSide + ", submitLiquidity=" + this.submitLiquidity + ", executeOrders=" + this.executeOrders + ", verbose=" + this.verbose + ", sendHipchat=" + this.sendHipchat + ", apiKey=" + this.apiKey + ", apiSecret=" + this.apiSecret + ", nubitAddress=" + this.nubitAddress + ", rpcUser=" + this.rpcUser + ", rpcPass=" + this.rpcPass + ", nudIp=" + this.nudIp + ", nudPort=" + this.nudPort + ", priceIncrement=" + this.priceIncrement + ", txFee=" + this.txFee + ", exchangeName=" + this.exchangeName + ", pair=" + this.pair + ", executeStrategyInterval=" + this.executeStrategyInterval + ", sendLiquidityInterval=" + this.sendLiquidityInterval + ", sendMails=" + this.sendMails + ", mailRecipient=" + this.mailRecipient + "emergencyTimeoutMinutes " + this.emergencyTimeout + "keepProceeds=" + this.keepProceeds + "aggregate=" + this.aggregate + " , waitBeforeShift=" + this.multipleCustodians + " , cryptoPegOptions=" + cryptoOptions + '}';
    }

    public String toStringNoKeys() {
        String cryptoOptions = "";
        if (this.secondaryPegOptions != null) {
            cryptoOptions = this.secondaryPegOptions.toHtmlString();
        }
        return "Options : {<br>dualSide=" + this.dualSide + "<br> submitLiquidity=" + this.submitLiquidity + "<br> executeOrders=" + this.executeOrders + "<br> verbose=" + this.verbose + "<br> sendHipchat=" + this.sendHipchat + "<br> apiKey=" + this.apiKey + "<br> nubitAddress=" + this.nubitAddress + "<br> rpcUser=" + this.rpcUser + "<br> nudIp=" + this.nudIp + "<br> nudPort=" + this.nudPort + "<br> priceIncrement=" + this.priceIncrement + "<br> txFee=" + this.txFee + "<br> exchangeName=" + this.exchangeName + "<br> pair=" + this.pair + "<br> executeStrategyInterval=" + this.executeStrategyInterval + "<br> sendLiquidityInterval=" + this.sendLiquidityInterval + "<br> sendMails=" + this.sendMails + "<br> mailRecipient=" + this.mailRecipient + "<br> emergencyTimeoutMinutes " + this.emergencyTimeout + "<br> keepProceeds=" + this.keepProceeds + "<br> aggregate=" + this.aggregate + " <br><br>" + cryptoOptions + '}';
    }
}

